typedef struct tree_entry {
    char *name;			/* The full path of directory */
    int sublevel;		/* Number of parent directories (slashes) */
    long submask;		/* Bitmask of existing sublevels after this entry */
    char *subname;		/* The last part of name (the actual name) */
    int mark;			/* Flag: Is this entry marked (e. g. for delete)? */
    struct tree_entry *next;	/* Next item in the list */
    struct tree_entry *prev;	/* Previous item in the list */
} tree_entry;

int tree_init (char *current_dir, int lines);
void load_tree (void);
void save_tree (void);
void show_tree (Panel *panel);
void tree_chdir (char *dir);
int tree_rescan_cmd (void);
int tree_forget_cmd (void);
void tree_copy (char *default_dest);
void tree_move (char *default_dest);
void tree_event (int y);
char *tree (char *current_dir);

int search_tree (char *text);

tree_entry *tree_add_entry (char *name);
void tree_remove_entry (char *name);
void destroy_tree (void);
void start_tree_check (void);
void do_tree_check (const char *subname);
void end_tree_check (void);

void tree_move_backward (int i);
void tree_move_forward (int i);
void tree_move_to_parent (void);
void tree_move_to_child (void);
void tree_move_to_top (int i);
void tree_move_to_bottom (int i);

extern int tree_lines;
extern int tree_navigation_flag;
