
#include <mbase.h>
#include "example2.h"

/*
 * PROTOTYPES -----------------------------------------------------------------
 *
 */

   void main XARGS( (void) );
   long avg  XARGS( (char *) );


/*
 * CODE -----------------------------------------------------------------------
 *
 */

void
main ()
{
   long  num;

   num = avg ("example2.rel");

   printf ("Average was %ld\n", num);

   exit (0);
}


/*
 * Average all values within named relation: ----------------------------------
 *
 */

long
avg  (filename)
char *filename;
{
   relation *rel;    /* Relation structure */
   example2  rec;    /* See EXAMPLE2.H and EXAMPLE2.S for this */
   mb_action act;
   long      ttl = 0L, num;


/*
 * The first thing is to open the named relation...
 *
 */

   if ((rel = mb_inc (filename, "")) == RNULL)
      {
      fprintf (stderr, "mb_inc() failed: %s\n", mb_error);
      mb_exit (1);
      }


/*
 * Then we figure out if there are any records to average.  Do this
 * before we do any calculations, so we don't end up dividing by
 * zero.
 *
 */

   if ((num = mb_num (rel)) == 0)
      {
      return 0L;
      }


/*
 * Now the tricky part.  First, walk through the normal heap--those
 * records that have been indexed--and sum the 'val' field.
 *
 */

   for (act = FIRST; ; act = NEXT)
      {
      if (mb_sel (rel, idxnum(rel,"ix_item"), &rec, act, NULL) != MB_OKAY)
         {
         break;
         }
      ttl += rec.val;
      }


/*
 * And, if there are any records in the queue (secondary heap--those
 * records that haven't yet been indexed) and sum the 'val' field.
 * Why the second loop?  Because records that haven't been indexed
 * won't be reached through the last one.
 *
 */

   if (mb_num_q (rel))
      {
      for (act = FIRST_Q; ; act = NEXT_Q)
         {
         if (mb_sel (rel, idxnum(rel,"ix_val"), &rec, act, NULL) != MB_OKAY)
            {
            break;
            }
         ttl += rec.val;
         }
      }

/*
 * Now close any relations that are open, and return the average
 * of the values we've found.
 *
 */

   mb_die ();       /* close all opened relations */

   return (ttl / num);
}

