/*
 * METALBASE 5.1
 *
 * Released January 1st, 1993 by Huan-Ti [ t-richj@microsoft.com ]
 *
 */

#include <mbase.h>


static char bufIn[MAX_CBUF], bufOut[MAX_CBUF];

/*
 * PROTOTYPES -----------------------------------------------------------------
 *
 */

   static long     _bufCompress    XARGS( (long) );
   static long     _bufDecompress  XARGS( (long) );


/*
 * DECOMPRESS -----------------------------------------------------------------
 *
 */

#define sigCOMPRESSED '+'
#define sigFINISHED   '-'

long
_fhDecompress (fhOut, fhIn) /* Decompress enough text for one page, ret size */
file           fhOut, fhIn;
{
   char  sig;
   long  nRead;

   readx (fhIn, &sig, 1);
   if (sig == sigFINISHED)
      return  0L;
   if (sig != sigCOMPRESSED)
      return -1L;


   readx (fhIn, &nRead, 4);    /* Find out how much we'll need to decompress */
   readx (fhIn, bufIn, nRead); /* And read enough text for the upcoming page */

   if (nRead == 0L)
      return -1L;

/*
 * Decompress bufIn->bufOut, set nRead=size of data, decompressed
 *
 */
   nRead = _bufDecompress (nRead);


/*
 * Now that we've decompressed it, store the data in the output file and
 * return the decompressed length:
 *
 */

   writx (fhOut, bufOut, nRead);

   return nRead;
}


/*
 * COMPRESS -------------------------------------------------------------------
 *
 */

long
_fhCompress (fhOut, fhIn)     /* Compress one page; return compressed length */
file         fhOut, fhIn;
{
   long  nRead;
   char  sig;


   if ((nRead = readx (fhIn, bufIn, MAX_CBUF)) == 0L)
      {
      sig = sigFINISHED;
      writx (fhOut, &sig, 1);   /* We have to use at least 4 bytes here! */
      writx (fhOut, &sig, 1);
      writx (fhOut, &sig, 1);
      writx (fhOut, &sig, 1);
      return 4;
      }

/*
 * Compress bufIn->bufOut, store in fhOut, set nRead=new size
 *
 */
   nRead = _bufCompress (nRead);

   sig = sigCOMPRESSED;
   writx (fhOut, &sig, 1);
   writx (fhOut, &nRead, 4);        /* Number of chars needed to decomp page */
   writx (fhOut, bufOut, nRead);    /* Actual data to decompress, later      */

   return 5+nRead;
}


/*
 * SERVICE ROUTINES -----------------------------------------------------------
 *
 */

long
_fhCopy (fhOut, fhIn, n)     /* Copy one page; return number of bytes copied */
file     fhOut, fhIn;
long                  n;
{
   long  nRead;
   long  nWrote;

   if ((nRead = readx (fhIn, bufIn, n)) != 0L)
      {
      if ((nWrote = writx (fhOut, bufIn, nRead)) != nRead)
         return nWrote;
      }

   return nRead;
}


/*
 * Decompress bufIn->bufOut, return uncompressed length
 *
 */

static long
_bufDecompress (n)
long            n;
{

   /*
    * This routine will house the decompression routine; when called, 'bufIn'
    * contains 'n' bytes which need to be decompressed--depending on the
    * routine I eventually put in here, the first bytes of bufIn may contain
    * information necessary for decompressing this page.  Niether bufIn nor
    * bufOut should ever exceed MAX_CBUF.
    *
    */
   numcpy (bufOut, bufIn, (int)n);

   return n;
}


/*
 * Compress bufIn->bufOut, return compressed length
 *
 */

static long
_bufCompress (n)
long          n;
{

   /*
    * This routine will house the compression routine; when called, 'bufIn'
    * contains 'n' bytes which need to be compressed, and 'bufOut' should be
    * filled with compressed text, possibly with whatever headers are
    * necessary for decompression at the front.  Niether bufIn nor bufOut
    * should ever exceed MAX_CBUF.
    *
    */
   numcpy (bufOut, bufIn, (int)n);

   return n;
}

