/*
 *	comp_captab.c -- The names of the capabilities in a form ready for
 *		         the making of a hash table for the compiler.
 *
 */


#include "tic.h"
#include "terminfo.h"
#include "hashsize.h"


struct name_table_entry	cap_table[] =
{
	{ 0,           "bw",	BOOLEAN,	  0 },
	{ 0,           "am",	BOOLEAN,	  1 },
	{ 0,           "xb",	BOOLEAN,	  2 },
	{ 0,          "xsb",	BOOLEAN,	  2 },
	{ 0,           "xs",	BOOLEAN,	  3 },
	{ 0,          "xhp",	BOOLEAN,	  3 },
	{ 0,           "xn",	BOOLEAN,	  4 },
	{ 0,         "xenl",	BOOLEAN,	  4 },
	{ 0,           "eo",	BOOLEAN,	  5 },
	{ 0,           "gn",	BOOLEAN,	  6 },
	{ 0,           "hc",	BOOLEAN,	  7 },
	{ 0,           "km",	BOOLEAN,	  8 },
	{ 0,           "hs",	BOOLEAN,	  9 },
	{ 0,           "in",	BOOLEAN,	 10 },
	{ 0,           "da",	BOOLEAN,	 11 },
	{ 0,           "db",	BOOLEAN,	 12 },
	{ 0,           "mi",	BOOLEAN,	 13 },
	{ 0,          "mir",	BOOLEAN,	 13 },
	{ 0,           "ms",	BOOLEAN,	 14 },
	{ 0,         "msgr",	BOOLEAN,	 14 },
	{ 0,           "os",	BOOLEAN,	 15 },
	{ 0,           "es",	BOOLEAN,	 16 },
	{ 0,        "eslok",	BOOLEAN,	 16 },
	{ 0,           "xt",	BOOLEAN,	 17 },
	{ 0,           "hz",	BOOLEAN,	 18 },
	{ 0,           "ul",	BOOLEAN,	 19 },
	{ 0,           "xo",	BOOLEAN,	 20 },
	{ 0,          "xon",	BOOLEAN,	 20 },
	{ 0,           "nx",	BOOLEAN,	 21 },
	{ 0,         "nxon",	BOOLEAN,	 21 },
	{ 0,           "5i",	BOOLEAN,	 22 },
	{ 0,         "mc5i",	BOOLEAN,	 22 },
	{ 0,           "HC",	BOOLEAN,	 23 },
	{ 0,         "chts",	BOOLEAN,	 23 },
	{ 0,           "NR",	BOOLEAN,	 24 },
	{ 0,        "nrrmc",	BOOLEAN,	 24 },
	{ 0,           "NP",	BOOLEAN,	 25 },
	{ 0,          "npc",	BOOLEAN,	 25 },
	{ 0,           "ND",	BOOLEAN,	 26 },
	{ 0,        "ndscr",	BOOLEAN,	 26 },
	{ 0,           "cc",	BOOLEAN,	 27 },
	{ 0,          "ccc",	BOOLEAN,	 27 },
	{ 0,           "ut",	BOOLEAN,	 28 },
	{ 0,          "bce",	BOOLEAN,	 28 },
	{ 0,           "hl",	BOOLEAN,	 29 },
	{ 0,          "hls",	BOOLEAN,	 29 },
	{ 0,           "YA",	BOOLEAN,	 30 },
	{ 0,         "xhpa",	BOOLEAN,	 30 },
	{ 0,           "YB",	BOOLEAN,	 31 },
	{ 0,         "crxm",	BOOLEAN,	 31 },
	{ 0,           "YC",	BOOLEAN,	 32 },
	{ 0,        "daisy",	BOOLEAN,	 32 },
	{ 0,           "YD",	BOOLEAN,	 33 },
	{ 0,         "xvpa",	BOOLEAN,	 33 },
	{ 0,           "YE",	BOOLEAN,	 34 },
	{ 0,          "sam",	BOOLEAN,	 34 },
	{ 0,           "YF",	BOOLEAN,	 35 },
	{ 0,         "cpix",	BOOLEAN,	 35 },
	{ 0,           "YG",	BOOLEAN,	 36 },
	{ 0,         "lpix",	BOOLEAN,	 36 },
	{ 0,           "co",	NUMBER,		  0 },
	{ 0,         "cols",	NUMBER,		  0 },
	{ 0,           "it",	NUMBER,		  1 },
	{ 0,           "li",	NUMBER,		  2 },
	{ 0,        "lines",	NUMBER,		  2 },
	{ 0,           "lm",	NUMBER,		  3 },
	{ 0,           "sg",	NUMBER,		  4 },
	{ 0,          "xmc",	NUMBER,		  4 },
	{ 0,           "pb",	NUMBER,		  5 },
	{ 0,           "vt",	NUMBER,		  6 },
	{ 0,           "ws",	NUMBER,		  7 },
	{ 0,          "wsl",	NUMBER,		  7 },
	{ 0,           "Nl",	NUMBER,		  8 },
	{ 0,         "nlab",	NUMBER,		  8 },
	{ 0,           "lh",	NUMBER,		  9 },
	{ 0,           "lw",	NUMBER,		 10 },
	{ 0,           "ma",	NUMBER,		 11 },
	{ 0,           "MW",	NUMBER,		 12 },
	{ 0,         "wnum",	NUMBER,		 12 },
	{ 0,           "Co",	NUMBER,		 13 },
	{ 0,       "colors",	NUMBER,		 13 },
	{ 0,           "pa",	NUMBER,		 14 },
	{ 0,        "pairs",	NUMBER,		 14 },
	{ 0,           "NC",	NUMBER,		 15 },
	{ 0,          "ncv",	NUMBER,		 15 },
	{ 0,           "Ya",	NUMBER,		 16 },
	{ 0,        "bufsz",	NUMBER,		 16 },
	{ 0,           "Yc",	NUMBER,		 17 },
	{ 0,        "spinh",	NUMBER,		 17 },
	{ 0,           "Yb",	NUMBER,		 18 },
	{ 0,        "spinv",	NUMBER,		 18 },
	{ 0,           "Yd",	NUMBER,		 19 },
	{ 0,        "maddr",	NUMBER,		 19 },
	{ 0,           "Ye",	NUMBER,		 20 },
	{ 0,        "mjump",	NUMBER,		 20 },
	{ 0,           "Yf",	NUMBER,		 21 },
	{ 0,          "mcs",	NUMBER,		 21 },
	{ 0,           "Yg",	NUMBER,		 22 },
	{ 0,          "mls",	NUMBER,		 22 },
	{ 0,           "Yh",	NUMBER,		 23 },
	{ 0,        "npins",	NUMBER,		 23 },
	{ 0,           "Yi",	NUMBER,		 24 },
	{ 0,          "orc",	NUMBER,		 24 },
	{ 0,           "Yj",	NUMBER,		 25 },
	{ 0,          "orl",	NUMBER,		 25 },
	{ 0,           "Yk",	NUMBER,		 26 },
	{ 0,         "orhi",	NUMBER,		 26 },
	{ 0,           "Yl",	NUMBER,		 27 },
	{ 0,         "orvi",	NUMBER,		 27 },
	{ 0,           "Ym",	NUMBER,		 28 },
	{ 0,          "cps",	NUMBER,		 28 },
	{ 0,           "Yn",	NUMBER,		 29 },
	{ 0,        "widcs",	NUMBER,		 29 },
	{ 0,           "BT",	NUMBER,		 30 },
	{ 0,         "btns",	NUMBER,		 30 },
	{ 0,           "Yo",	NUMBER,		 31 },
	{ 0,       "bitwin",	NUMBER,		 31 },
	{ 0,           "Yp",	NUMBER,		 32 },
	{ 0,       "bitype",	NUMBER,		 32 },
	{ 0,           "bt",	STRING,		  0 },
	{ 0,          "cbt",	STRING,		  0 },
	{ 0,           "bl",	STRING,		  1 },
	{ 0,          "bel",	STRING,		  1 },
	{ 0,           "cr",	STRING,		  2 },
	{ 0,           "cs",	STRING,		  3 },
	{ 0,          "csr",	STRING,		  3 },
	{ 0,           "ct",	STRING,		  4 },
	{ 0,          "tbc",	STRING,		  4 },
	{ 0,           "cl",	STRING,		  5 },
	{ 0,        "clear",	STRING,		  5 },
	{ 0,           "ce",	STRING,		  6 },
	{ 0,           "el",	STRING,		  6 },
	{ 0,           "cd",	STRING,		  7 },
	{ 0,           "ed",	STRING,		  7 },
	{ 0,           "ch",	STRING,		  8 },
	{ 0,          "hpa",	STRING,		  8 },
	{ 0,           "CC",	STRING,		  9 },
	{ 0,        "cmdch",	STRING,		  9 },
	{ 0,           "cm",	STRING,		 10 },
	{ 0,          "cup",	STRING,		 10 },
	{ 0,           "do",	STRING,		 11 },
	{ 0,         "cud1",	STRING,		 11 },
	{ 0,           "ho",	STRING,		 12 },
	{ 0,         "home",	STRING,		 12 },
	{ 0,           "vi",	STRING,		 13 },
	{ 0,        "civis",	STRING,		 13 },
	{ 0,           "le",	STRING,		 14 },
	{ 0,         "cub1",	STRING,		 14 },
	{ 0,           "CM",	STRING,		 15 },
	{ 0,        "mrcup",	STRING,		 15 },
	{ 0,           "ve",	STRING,		 16 },
	{ 0,        "cnorm",	STRING,		 16 },
	{ 0,           "nd",	STRING,		 17 },
	{ 0,         "cuf1",	STRING,		 17 },
	{ 0,           "ll",	STRING,		 18 },
	{ 0,           "up",	STRING,		 19 },
	{ 0,         "cuu1",	STRING,		 19 },
	{ 0,           "vs",	STRING,		 20 },
	{ 0,        "cvvis",	STRING,		 20 },
	{ 0,           "dc",	STRING,		 21 },
	{ 0,         "dch1",	STRING,		 21 },
	{ 0,           "dl",	STRING,		 22 },
	{ 0,          "dl1",	STRING,		 22 },
	{ 0,           "ds",	STRING,		 23 },
	{ 0,          "dsl",	STRING,		 23 },
	{ 0,           "hd",	STRING,		 24 },
	{ 0,           "as",	STRING,		 25 },
	{ 0,        "smacs",	STRING,		 25 },
	{ 0,           "mb",	STRING,		 26 },
	{ 0,        "blink",	STRING,		 26 },
	{ 0,           "md",	STRING,		 27 },
	{ 0,         "bold",	STRING,		 27 },
	{ 0,           "ti",	STRING,		 28 },
	{ 0,        "smcup",	STRING,		 28 },
	{ 0,           "dm",	STRING,		 29 },
	{ 0,         "smdc",	STRING,		 29 },
	{ 0,           "mh",	STRING,		 30 },
	{ 0,          "dim",	STRING,		 30 },
	{ 0,           "im",	STRING,		 31 },
	{ 0,         "smir",	STRING,		 31 },
	{ 0,           "mk",	STRING,		 32 },
	{ 0,        "invis",	STRING,		 32 },
	{ 0,           "mp",	STRING,		 33 },
	{ 0,         "prot",	STRING,		 33 },
	{ 0,           "mr",	STRING,		 34 },
	{ 0,          "rev",	STRING,		 34 },
	{ 0,           "so",	STRING,		 35 },
	{ 0,         "smso",	STRING,		 35 },
	{ 0,           "us",	STRING,		 36 },
	{ 0,         "smul",	STRING,		 36 },
	{ 0,           "ec",	STRING,		 37 },
	{ 0,          "ech",	STRING,		 37 },
	{ 0,           "ae",	STRING,		 38 },
	{ 0,        "rmacs",	STRING,		 38 },
	{ 0,           "me",	STRING,		 39 },
	{ 0,         "sgr0",	STRING,		 39 },
	{ 0,           "te",	STRING,		 40 },
	{ 0,        "rmcup",	STRING,		 40 },
	{ 0,           "ed",	STRING,		 41 },
	{ 0,         "rmdc",	STRING,		 41 },
	{ 0,           "ei",	STRING,		 42 },
	{ 0,         "rmir",	STRING,		 42 },
	{ 0,           "se",	STRING,		 43 },
	{ 0,         "rmso",	STRING,		 43 },
	{ 0,           "ue",	STRING,		 44 },
	{ 0,         "rmul",	STRING,		 44 },
	{ 0,           "vb",	STRING,		 45 },
	{ 0,        "flash",	STRING,		 45 },
	{ 0,           "ff",	STRING,		 46 },
	{ 0,           "fs",	STRING,		 47 },
	{ 0,          "fsl",	STRING,		 47 },
	{ 0,           "i1",	STRING,		 48 },
	{ 0,          "is1",	STRING,		 48 },
	{ 0,           "is",	STRING,		 49 },
	{ 0,          "is2",	STRING,		 49 },
	{ 0,           "i3",	STRING,		 50 },
	{ 0,          "is3",	STRING,		 50 },
	{ 0,           "if",	STRING,		 51 },
	{ 0,           "ic",	STRING,		 52 },
	{ 0,         "ich1",	STRING,		 52 },
	{ 0,           "al",	STRING,		 53 },
	{ 0,          "il1",	STRING,		 53 },
	{ 0,           "ip",	STRING,		 54 },
	{ 0,           "kb",	STRING,		 55 },
	{ 0,          "kbs",	STRING,		 55 },
	{ 0,           "ka",	STRING,		 56 },
	{ 0,         "ktbc",	STRING,		 56 },
	{ 0,           "kC",	STRING,		 57 },
	{ 0,         "kclr",	STRING,		 57 },
	{ 0,           "kt",	STRING,		 58 },
	{ 0,        "kctab",	STRING,		 58 },
	{ 0,           "kD",	STRING,		 59 },
	{ 0,        "kdch1",	STRING,		 59 },
	{ 0,           "kL",	STRING,		 60 },
	{ 0,         "kdl1",	STRING,		 60 },
	{ 0,           "kd",	STRING,		 61 },
	{ 0,        "kcud1",	STRING,		 61 },
	{ 0,           "kM",	STRING,		 62 },
	{ 0,        "krmir",	STRING,		 62 },
	{ 0,           "kE",	STRING,		 63 },
	{ 0,          "kel",	STRING,		 63 },
	{ 0,           "kS",	STRING,		 64 },
	{ 0,          "ked",	STRING,		 64 },
	{ 0,           "k0",	STRING,		 65 },
	{ 0,          "kf0",	STRING,		 65 },
	{ 0,           "k1",	STRING,		 66 },
	{ 0,          "kf1",	STRING,		 66 },
	{ 0,           "k;",	STRING,		 67 },
	{ 0,         "kf10",	STRING,		 67 },
	{ 0,           "k2",	STRING,		 68 },
	{ 0,          "kf2",	STRING,		 68 },
	{ 0,           "k3",	STRING,		 69 },
	{ 0,          "kf3",	STRING,		 69 },
	{ 0,           "k4",	STRING,		 70 },
	{ 0,          "kf4",	STRING,		 70 },
	{ 0,           "k5",	STRING,		 71 },
	{ 0,          "kf5",	STRING,		 71 },
	{ 0,           "k6",	STRING,		 72 },
	{ 0,          "kf6",	STRING,		 72 },
	{ 0,           "k7",	STRING,		 73 },
	{ 0,          "kf7",	STRING,		 73 },
	{ 0,           "k8",	STRING,		 74 },
	{ 0,          "kf8",	STRING,		 74 },
	{ 0,           "k9",	STRING,		 75 },
	{ 0,          "kf9",	STRING,		 75 },
	{ 0,           "kh",	STRING,		 76 },
	{ 0,        "khome",	STRING,		 76 },
	{ 0,           "kI",	STRING,		 77 },
	{ 0,        "kich1",	STRING,		 77 },
	{ 0,           "kA",	STRING,		 78 },
	{ 0,         "kil1",	STRING,		 78 },
	{ 0,           "kl",	STRING,		 79 },
	{ 0,        "kcub1",	STRING,		 79 },
	{ 0,           "kH",	STRING,		 80 },
	{ 0,          "kll",	STRING,		 80 },
	{ 0,           "kN",	STRING,		 81 },
	{ 0,          "knp",	STRING,		 81 },
	{ 0,           "kP",	STRING,		 82 },
	{ 0,          "kpp",	STRING,		 82 },
	{ 0,           "kr",	STRING,		 83 },
	{ 0,        "kcuf1",	STRING,		 83 },
	{ 0,           "kF",	STRING,		 84 },
	{ 0,         "kind",	STRING,		 84 },
	{ 0,           "kR",	STRING,		 85 },
	{ 0,          "kri",	STRING,		 85 },
	{ 0,           "kT",	STRING,		 86 },
	{ 0,         "khts",	STRING,		 86 },
	{ 0,           "ku",	STRING,		 87 },
	{ 0,        "kcuu1",	STRING,		 87 },
	{ 0,           "ke",	STRING,		 88 },
	{ 0,         "rmkx",	STRING,		 88 },
	{ 0,           "ks",	STRING,		 89 },
	{ 0,         "smkx",	STRING,		 89 },
	{ 0,           "l0",	STRING,		 90 },
	{ 0,          "lf0",	STRING,		 90 },
	{ 0,           "l1",	STRING,		 91 },
	{ 0,          "lf1",	STRING,		 91 },
	{ 0,           "la",	STRING,		 92 },
	{ 0,         "lf10",	STRING,		 92 },
	{ 0,           "l2",	STRING,		 93 },
	{ 0,          "lf2",	STRING,		 93 },
	{ 0,           "l3",	STRING,		 94 },
	{ 0,          "lf3",	STRING,		 94 },
	{ 0,           "l4",	STRING,		 95 },
	{ 0,          "lf4",	STRING,		 95 },
	{ 0,           "l5",	STRING,		 96 },
	{ 0,          "lf5",	STRING,		 96 },
	{ 0,           "l6",	STRING,		 97 },
	{ 0,          "lf6",	STRING,		 97 },
	{ 0,           "l7",	STRING,		 98 },
	{ 0,          "lf7",	STRING,		 98 },
	{ 0,           "l8",	STRING,		 99 },
	{ 0,          "lf8",	STRING,		 99 },
	{ 0,           "l9",	STRING,		100 },
	{ 0,          "lf9",	STRING,		100 },
	{ 0,           "mo",	STRING,		101 },
	{ 0,          "rmm",	STRING,		101 },
	{ 0,           "mm",	STRING,		102 },
	{ 0,          "smm",	STRING,		102 },
	{ 0,           "nw",	STRING,		103 },
	{ 0,          "nel",	STRING,		103 },
	{ 0,           "pc",	STRING,		104 },
	{ 0,          "pad",	STRING,		104 },
	{ 0,           "DC",	STRING,		105 },
	{ 0,          "dch",	STRING,		105 },
	{ 0,           "DL",	STRING,		106 },
	{ 0,           "dl",	STRING,		106 },
	{ 0,           "DO",	STRING,		107 },
	{ 0,          "cud",	STRING,		107 },
	{ 0,           "IC",	STRING,		108 },
	{ 0,          "ich",	STRING,		108 },
	{ 0,           "SF",	STRING,		109 },
	{ 0,         "indn",	STRING,		109 },
	{ 0,           "AL",	STRING,		110 },
	{ 0,           "il",	STRING,		110 },
	{ 0,           "LE",	STRING,		111 },
	{ 0,          "cub",	STRING,		111 },
	{ 0,           "RI",	STRING,		112 },
	{ 0,          "cuf",	STRING,		112 },
	{ 0,           "SR",	STRING,		113 },
	{ 0,          "rin",	STRING,		113 },
	{ 0,           "UP",	STRING,		114 },
	{ 0,          "cuu",	STRING,		114 },
	{ 0,           "pk",	STRING,		115 },
	{ 0,        "pfkey",	STRING,		115 },
	{ 0,           "pl",	STRING,		116 },
	{ 0,        "pfloc",	STRING,		116 },
	{ 0,           "px",	STRING,		117 },
	{ 0,          "pfx",	STRING,		117 },
	{ 0,           "ps",	STRING,		118 },
	{ 0,          "mc0",	STRING,		118 },
	{ 0,           "pf",	STRING,		119 },
	{ 0,          "mc4",	STRING,		119 },
	{ 0,           "po",	STRING,		120 },
	{ 0,          "mc5",	STRING,		120 },
	{ 0,           "rp",	STRING,		121 },
	{ 0,          "rep",	STRING,		121 },
	{ 0,           "r1",	STRING,		122 },
	{ 0,          "rs1",	STRING,		122 },
	{ 0,           "r2",	STRING,		123 },
	{ 0,          "rs2",	STRING,		123 },
	{ 0,           "r3",	STRING,		124 },
	{ 0,          "rs3",	STRING,		124 },
	{ 0,           "rf",	STRING,		125 },
	{ 0,           "rc",	STRING,		126 },
	{ 0,           "cv",	STRING,		127 },
	{ 0,          "vpa",	STRING,		127 },
	{ 0,           "sc",	STRING,		128 },
	{ 0,           "sf",	STRING,		129 },
	{ 0,          "ind",	STRING,		129 },
	{ 0,           "sr",	STRING,		130 },
	{ 0,           "ri",	STRING,		130 },
	{ 0,           "sa",	STRING,		131 },
	{ 0,          "sgr",	STRING,		131 },
	{ 0,           "st",	STRING,		132 },
	{ 0,          "hts",	STRING,		132 },
	{ 0,           "wi",	STRING,		133 },
	{ 0,         "wind",	STRING,		133 },
	{ 0,           "ta",	STRING,		134 },
	{ 0,           "ht",	STRING,		134 },
	{ 0,           "ts",	STRING,		135 },
	{ 0,          "tsl",	STRING,		135 },
	{ 0,           "uc",	STRING,		136 },
	{ 0,           "hu",	STRING,		137 },
	{ 0,           "iP",	STRING,		138 },
	{ 0,        "iprog",	STRING,		138 },
	{ 0,           "K1",	STRING,		139 },
	{ 0,          "ka1",	STRING,		139 },
	{ 0,           "K3",	STRING,		140 },
	{ 0,          "ka3",	STRING,		140 },
	{ 0,           "K2",	STRING,		141 },
	{ 0,          "kb2",	STRING,		141 },
	{ 0,           "K4",	STRING,		142 },
	{ 0,          "kc1",	STRING,		142 },
	{ 0,           "K5",	STRING,		143 },
	{ 0,          "kc3",	STRING,		143 },
	{ 0,           "pO",	STRING,		144 },
	{ 0,         "mc5p",	STRING,		144 },
	{ 0,           "rP",	STRING,		145 },
	{ 0,          "rmp",	STRING,		145 },
	{ 0,           "ac",	STRING,		146 },
	{ 0,         "acsc",	STRING,		146 },
	{ 0,           "pn",	STRING,		147 },
	{ 0,          "pln",	STRING,		147 },
	{ 0,           "kB",	STRING,		148 },
	{ 0,         "kcbt",	STRING,		148 },
	{ 0,           "SX",	STRING,		149 },
	{ 0,        "smxon",	STRING,		149 },
	{ 0,           "RX",	STRING,		150 },
	{ 0,        "rmxon",	STRING,		150 },
	{ 0,           "SA",	STRING,		151 },
	{ 0,         "smam",	STRING,		151 },
	{ 0,           "RA",	STRING,		152 },
	{ 0,         "rmam",	STRING,		152 },
	{ 0,           "XF",	STRING,		153 },
	{ 0,        "xoffc",	STRING,		153 },
	{ 0,           "XN",	STRING,		154 },
	{ 0,         "xonc",	STRING,		154 },
	{ 0,           "eA",	STRING,		155 },
	{ 0,        "enacs",	STRING,		155 },
	{ 0,           "LO",	STRING,		156 },
	{ 0,         "smln",	STRING,		156 },
	{ 0,           "LF",	STRING,		157 },
	{ 0,         "rmln",	STRING,		157 },
	{ 0,           "@1",	STRING,		158 },
	{ 0,         "kbeg",	STRING,		158 },
	{ 0,           "@2",	STRING,		159 },
	{ 0,         "kcan",	STRING,		159 },
	{ 0,           "@3",	STRING,		160 },
	{ 0,         "kclo",	STRING,		160 },
	{ 0,           "@4",	STRING,		161 },
	{ 0,         "kcmd",	STRING,		161 },
	{ 0,           "@5",	STRING,		162 },
	{ 0,         "kcpy",	STRING,		162 },
	{ 0,           "@6",	STRING,		163 },
	{ 0,         "kcrt",	STRING,		163 },
	{ 0,           "@7",	STRING,		164 },
	{ 0,         "kend",	STRING,		164 },
	{ 0,           "@8",	STRING,		165 },
	{ 0,         "kent",	STRING,		165 },
	{ 0,           "@9",	STRING,		166 },
	{ 0,         "kext",	STRING,		166 },
	{ 0,           "@0",	STRING,		167 },
	{ 0,         "kfnd",	STRING,		167 },
	{ 0,           "%1",	STRING,		168 },
	{ 0,         "khlp",	STRING,		168 },
	{ 0,           "%2",	STRING,		169 },
	{ 0,         "kmrk",	STRING,		169 },
	{ 0,           "%3",	STRING,		170 },
	{ 0,         "kmsg",	STRING,		170 },
	{ 0,           "%4",	STRING,		171 },
	{ 0,         "kmov",	STRING,		171 },
	{ 0,           "%5",	STRING,		172 },
	{ 0,         "knxt",	STRING,		172 },
	{ 0,           "%6",	STRING,		173 },
	{ 0,         "kopn",	STRING,		173 },
	{ 0,           "%7",	STRING,		174 },
	{ 0,         "kopt",	STRING,		174 },
	{ 0,           "%8",	STRING,		175 },
	{ 0,         "kprv",	STRING,		175 },
	{ 0,           "%9",	STRING,		176 },
	{ 0,         "kprt",	STRING,		176 },
	{ 0,           "%0",	STRING,		177 },
	{ 0,         "krdo",	STRING,		177 },
	{ 0,           "&1",	STRING,		178 },
	{ 0,         "kref",	STRING,		178 },
	{ 0,           "&2",	STRING,		179 },
	{ 0,         "krfr",	STRING,		179 },
	{ 0,           "&3",	STRING,		180 },
	{ 0,         "krpl",	STRING,		180 },
	{ 0,           "&4",	STRING,		181 },
	{ 0,         "krst",	STRING,		181 },
	{ 0,           "&5",	STRING,		182 },
	{ 0,         "kres",	STRING,		182 },
	{ 0,           "&6",	STRING,		183 },
	{ 0,         "ksav",	STRING,		183 },
	{ 0,           "&7",	STRING,		184 },
	{ 0,         "kspd",	STRING,		184 },
	{ 0,           "&8",	STRING,		185 },
	{ 0,         "kund",	STRING,		185 },
	{ 0,           "&9",	STRING,		186 },
	{ 0,         "kBEG",	STRING,		186 },
	{ 0,           "&0",	STRING,		187 },
	{ 0,         "kCAN",	STRING,		187 },
	{ 0,           "*1",	STRING,		188 },
	{ 0,         "kCMD",	STRING,		188 },
	{ 0,           "*2",	STRING,		189 },
	{ 0,         "kCPY",	STRING,		189 },
	{ 0,           "*3",	STRING,		190 },
	{ 0,         "kCRT",	STRING,		190 },
	{ 0,           "*4",	STRING,		191 },
	{ 0,          "kDC",	STRING,		191 },
	{ 0,           "*5",	STRING,		192 },
	{ 0,          "kDL",	STRING,		192 },
	{ 0,           "*6",	STRING,		193 },
	{ 0,         "kslt",	STRING,		193 },
	{ 0,           "*7",	STRING,		194 },
	{ 0,         "kEND",	STRING,		194 },
	{ 0,           "*8",	STRING,		195 },
	{ 0,         "kEOL",	STRING,		195 },
	{ 0,           "*9",	STRING,		196 },
	{ 0,         "kEXT",	STRING,		196 },
	{ 0,           "*0",	STRING,		197 },
	{ 0,         "kFND",	STRING,		197 },
	{ 0,           "#1",	STRING,		198 },
	{ 0,         "kHLP",	STRING,		198 },
	{ 0,           "#2",	STRING,		199 },
	{ 0,         "kHOM",	STRING,		199 },
	{ 0,           "#3",	STRING,		200 },
	{ 0,          "kIC",	STRING,		200 },
	{ 0,           "#4",	STRING,		201 },
	{ 0,         "kLFT",	STRING,		201 },
	{ 0,           "%a",	STRING,		202 },
	{ 0,         "kMSG",	STRING,		202 },
	{ 0,           "%b",	STRING,		203 },
	{ 0,         "kMOV",	STRING,		203 },
	{ 0,           "%c",	STRING,		204 },
	{ 0,         "kNXT",	STRING,		204 },
	{ 0,           "%d",	STRING,		205 },
	{ 0,         "kOPT",	STRING,		205 },
	{ 0,           "%e",	STRING,		206 },
	{ 0,         "kPRV",	STRING,		206 },
	{ 0,           "%f",	STRING,		207 },
	{ 0,         "kPRT",	STRING,		207 },
	{ 0,           "%g",	STRING,		208 },
	{ 0,         "kRDO",	STRING,		208 },
	{ 0,           "%h",	STRING,		209 },
	{ 0,         "kRPL",	STRING,		209 },
	{ 0,           "%i",	STRING,		210 },
	{ 0,         "kRIT",	STRING,		210 },
	{ 0,           "%j",	STRING,		211 },
	{ 0,         "kRES",	STRING,		211 },
	{ 0,           "!1",	STRING,		212 },
	{ 0,         "kSAV",	STRING,		212 },
	{ 0,           "!2",	STRING,		213 },
	{ 0,         "kSPD",	STRING,		213 },
	{ 0,           "!3",	STRING,		214 },
	{ 0,         "kUND",	STRING,		214 },
	{ 0,           "RF",	STRING,		215 },
	{ 0,          "rfi",	STRING,		215 },
	{ 0,           "F1",	STRING,		216 },
	{ 0,         "kf11",	STRING,		216 },
	{ 0,           "F2",	STRING,		217 },
	{ 0,         "kf12",	STRING,		217 },
	{ 0,           "F3",	STRING,		218 },
	{ 0,         "kf13",	STRING,		218 },
	{ 0,           "F4",	STRING,		219 },
	{ 0,         "kf14",	STRING,		219 },
	{ 0,           "F5",	STRING,		220 },
	{ 0,         "kf15",	STRING,		220 },
	{ 0,           "F6",	STRING,		221 },
	{ 0,         "kf16",	STRING,		221 },
	{ 0,           "F7",	STRING,		222 },
	{ 0,         "kf17",	STRING,		222 },
	{ 0,           "F8",	STRING,		223 },
	{ 0,         "kf18",	STRING,		223 },
	{ 0,           "F9",	STRING,		224 },
	{ 0,         "kf19",	STRING,		224 },
	{ 0,           "FA",	STRING,		225 },
	{ 0,         "kf20",	STRING,		225 },
	{ 0,           "FB",	STRING,		226 },
	{ 0,         "kf21",	STRING,		226 },
	{ 0,           "FC",	STRING,		227 },
	{ 0,         "kf22",	STRING,		227 },
	{ 0,           "FD",	STRING,		228 },
	{ 0,         "kf23",	STRING,		228 },
	{ 0,           "FE",	STRING,		229 },
	{ 0,         "kf24",	STRING,		229 },
	{ 0,           "FF",	STRING,		230 },
	{ 0,         "kf25",	STRING,		230 },
	{ 0,           "FG",	STRING,		231 },
	{ 0,         "kf26",	STRING,		231 },
	{ 0,           "FH",	STRING,		232 },
	{ 0,         "kf27",	STRING,		232 },
	{ 0,           "FI",	STRING,		233 },
	{ 0,         "kf28",	STRING,		233 },
	{ 0,           "FJ",	STRING,		234 },
	{ 0,         "kf29",	STRING,		234 },
	{ 0,           "FK",	STRING,		235 },
	{ 0,         "kf30",	STRING,		235 },
	{ 0,           "FL",	STRING,		236 },
	{ 0,         "kf31",	STRING,		236 },
	{ 0,           "FM",	STRING,		237 },
	{ 0,         "kf32",	STRING,		237 },
	{ 0,           "FN",	STRING,		238 },
	{ 0,         "kf33",	STRING,		238 },
	{ 0,           "FO",	STRING,		239 },
	{ 0,         "kf34",	STRING,		239 },
	{ 0,           "FP",	STRING,		240 },
	{ 0,         "kf35",	STRING,		240 },
	{ 0,           "FQ",	STRING,		241 },
	{ 0,         "kf36",	STRING,		241 },
	{ 0,           "FR",	STRING,		242 },
	{ 0,         "kf37",	STRING,		242 },
	{ 0,           "FS",	STRING,		243 },
	{ 0,         "kf38",	STRING,		243 },
	{ 0,           "FT",	STRING,		244 },
	{ 0,         "kf39",	STRING,		244 },
	{ 0,           "FU",	STRING,		245 },
	{ 0,         "kf40",	STRING,		245 },
	{ 0,           "FV",	STRING,		246 },
	{ 0,         "kf41",	STRING,		246 },
	{ 0,           "FW",	STRING,		247 },
	{ 0,         "kf42",	STRING,		247 },
	{ 0,           "FX",	STRING,		248 },
	{ 0,         "kf43",	STRING,		248 },
	{ 0,           "FY",	STRING,		249 },
	{ 0,         "kf44",	STRING,		249 },
	{ 0,           "FZ",	STRING,		250 },
	{ 0,         "kf45",	STRING,		250 },
	{ 0,           "Fa",	STRING,		251 },
	{ 0,         "kf46",	STRING,		251 },
	{ 0,           "Fb",	STRING,		252 },
	{ 0,         "kf47",	STRING,		252 },
	{ 0,           "Fc",	STRING,		253 },
	{ 0,         "kf48",	STRING,		253 },
	{ 0,           "Fd",	STRING,		254 },
	{ 0,         "kf49",	STRING,		254 },
	{ 0,           "Fe",	STRING,		255 },
	{ 0,         "kf50",	STRING,		255 },
	{ 0,           "Ff",	STRING,		256 },
	{ 0,         "kf51",	STRING,		256 },
	{ 0,           "Fg",	STRING,		257 },
	{ 0,         "kf52",	STRING,		257 },
	{ 0,           "Fh",	STRING,		258 },
	{ 0,         "kf53",	STRING,		258 },
	{ 0,           "Fi",	STRING,		259 },
	{ 0,         "kf54",	STRING,		259 },
	{ 0,           "Fj",	STRING,		260 },
	{ 0,         "kf55",	STRING,		260 },
	{ 0,           "Fk",	STRING,		261 },
	{ 0,         "kf56",	STRING,		261 },
	{ 0,           "Fl",	STRING,		262 },
	{ 0,         "kf57",	STRING,		262 },
	{ 0,           "Fm",	STRING,		263 },
	{ 0,         "kf58",	STRING,		263 },
	{ 0,           "Fn",	STRING,		264 },
	{ 0,         "kf59",	STRING,		264 },
	{ 0,           "Fo",	STRING,		265 },
	{ 0,         "kf60",	STRING,		265 },
	{ 0,           "Fp",	STRING,		266 },
	{ 0,         "kf61",	STRING,		266 },
	{ 0,           "Fq",	STRING,		267 },
	{ 0,         "kf62",	STRING,		267 },
	{ 0,           "Fr",	STRING,		268 },
	{ 0,         "kf63",	STRING,		268 },
	{ 0,           "cb",	STRING,		269 },
	{ 0,          "el1",	STRING,		269 },
	{ 0,           "MC",	STRING,		270 },
	{ 0,          "mgc",	STRING,		270 },
	{ 0,           "ML",	STRING,		271 },
	{ 0,         "smgl",	STRING,		271 },
	{ 0,           "MR",	STRING,		272 },
	{ 0,         "smgr",	STRING,		272 },
	{ 0,           "Lf",	STRING,		273 },
	{ 0,          "fln",	STRING,		273 },
	{ 0,           "SC",	STRING,		274 },
	{ 0,         "sclk",	STRING,		274 },
	{ 0,           "DK",	STRING,		275 },
	{ 0,         "dclk",	STRING,		275 },
	{ 0,           "RC",	STRING,		276 },
	{ 0,        "rmclk",	STRING,		276 },
	{ 0,           "CW",	STRING,		277 },
	{ 0,         "cwin",	STRING,		277 },
	{ 0,           "WG",	STRING,		278 },
	{ 0,        "wingo",	STRING,		278 },
	{ 0,           "HU",	STRING,		279 },
	{ 0,          "hup",	STRING,		279 },
	{ 0,           "DI",	STRING,		280 },
	{ 0,         "dial",	STRING,		280 },
	{ 0,           "QD",	STRING,		281 },
	{ 0,        "qdial",	STRING,		281 },
	{ 0,           "TO",	STRING,		282 },
	{ 0,         "tone",	STRING,		282 },
	{ 0,           "PU",	STRING,		283 },
	{ 0,        "pulse",	STRING,		283 },
	{ 0,           "fh",	STRING,		284 },
	{ 0,         "hook",	STRING,		284 },
	{ 0,           "PA",	STRING,		285 },
	{ 0,        "pause",	STRING,		285 },
	{ 0,           "WA",	STRING,		286 },
	{ 0,         "wait",	STRING,		286 },
	{ 0,           "u0",	STRING,		287 },
	{ 0,           "u1",	STRING,		288 },
	{ 0,           "u2",	STRING,		289 },
	{ 0,           "u3",	STRING,		290 },
	{ 0,           "u4",	STRING,		291 },
	{ 0,           "u5",	STRING,		292 },
	{ 0,           "u6",	STRING,		293 },
	{ 0,           "u7",	STRING,		294 },
	{ 0,           "u8",	STRING,		295 },
	{ 0,           "u9",	STRING,		296 },
	{ 0,           "op",	STRING,		297 },
	{ 0,           "oc",	STRING,		298 },
	{ 0,           "Ic",	STRING,		299 },
	{ 0,        "initc",	STRING,		299 },
	{ 0,           "Ip",	STRING,		300 },
	{ 0,        "initp",	STRING,		300 },
	{ 0,           "sp",	STRING,		301 },
	{ 0,          "scp",	STRING,		301 },
	{ 0,           "Sf",	STRING,		302 },
	{ 0,         "setf",	STRING,		302 },
	{ 0,           "Sb",	STRING,		303 },
	{ 0,         "setb",	STRING,		303 },
	{ 0,           "ZA",	STRING,		304 },
	{ 0,          "cpi",	STRING,		304 },
	{ 0,           "ZB",	STRING,		305 },
	{ 0,          "lpi",	STRING,		305 },
	{ 0,           "ZC",	STRING,		306 },
	{ 0,          "chr",	STRING,		306 },
	{ 0,           "ZD",	STRING,		307 },
	{ 0,          "cvr",	STRING,		307 },
	{ 0,           "ZE",	STRING,		308 },
	{ 0,         "defc",	STRING,		308 },
	{ 0,           "ZF",	STRING,		309 },
	{ 0,        "swidm",	STRING,		309 },
	{ 0,           "ZG",	STRING,		310 },
	{ 0,        "sdrfq",	STRING,		310 },
	{ 0,           "ZH",	STRING,		311 },
	{ 0,         "sitm",	STRING,		311 },
	{ 0,           "ZI",	STRING,		312 },
	{ 0,          "slm",	STRING,		312 },
	{ 0,           "ZJ",	STRING,		313 },
	{ 0,        "smicm",	STRING,		313 },
	{ 0,           "ZK",	STRING,		314 },
	{ 0,         "snlq",	STRING,		314 },
	{ 0,           "ZL",	STRING,		315 },
	{ 0,        "snrmq",	STRING,		315 },
	{ 0,           "ZM",	STRING,		316 },
	{ 0,         "sshm",	STRING,		316 },
	{ 0,           "ZN",	STRING,		317 },
	{ 0,        "ssubm",	STRING,		317 },
	{ 0,           "ZO",	STRING,		318 },
	{ 0,        "ssupm",	STRING,		318 },
	{ 0,           "ZP",	STRING,		319 },
	{ 0,          "sum",	STRING,		319 },
	{ 0,           "ZQ",	STRING,		320 },
	{ 0,        "rwidm",	STRING,		320 },
	{ 0,           "ZR",	STRING,		321 },
	{ 0,         "ritm",	STRING,		321 },
	{ 0,           "ZS",	STRING,		322 },
	{ 0,          "rlm",	STRING,		322 },
	{ 0,           "ZT",	STRING,		323 },
	{ 0,        "rmicm",	STRING,		323 },
	{ 0,           "ZU",	STRING,		324 },
	{ 0,         "rshm",	STRING,		324 },
	{ 0,           "ZV",	STRING,		325 },
	{ 0,        "rsubm",	STRING,		325 },
	{ 0,           "ZW",	STRING,		326 },
	{ 0,        "rsupm",	STRING,		326 },
	{ 0,           "ZX",	STRING,		327 },
	{ 0,          "rum",	STRING,		327 },
	{ 0,           "ZY",	STRING,		328 },
	{ 0,         "mhpa",	STRING,		328 },
	{ 0,           "ZZ",	STRING,		329 },
	{ 0,        "mcud1",	STRING,		329 },
	{ 0,           "Za",	STRING,		330 },
	{ 0,        "mcub1",	STRING,		330 },
	{ 0,           "Zb",	STRING,		331 },
	{ 0,        "mcuf1",	STRING,		331 },
	{ 0,           "Zc",	STRING,		332 },
	{ 0,         "mvpa",	STRING,		332 },
	{ 0,           "Zd",	STRING,		333 },
	{ 0,        "mcuu1",	STRING,		333 },
	{ 0,           "Ze",	STRING,		334 },
	{ 0,       "porder",	STRING,		334 },
	{ 0,           "Zf",	STRING,		335 },
	{ 0,         "mcud",	STRING,		335 },
	{ 0,           "Zg",	STRING,		336 },
	{ 0,         "mcub",	STRING,		336 },
	{ 0,           "Zh",	STRING,		337 },
	{ 0,         "mcuf",	STRING,		337 },
	{ 0,           "Zi",	STRING,		338 },
	{ 0,         "mcuu",	STRING,		338 },
	{ 0,           "Zj",	STRING,		339 },
	{ 0,          "scs",	STRING,		339 },
	{ 0,           "Zk",	STRING,		340 },
	{ 0,         "smgb",	STRING,		340 },
	{ 0,           "Zl",	STRING,		341 },
	{ 0,        "smgbp",	STRING,		341 },
	{ 0,           "Zm",	STRING,		342 },
	{ 0,        "smglp",	STRING,		342 },
	{ 0,           "Zn",	STRING,		343 },
	{ 0,        "smgrp",	STRING,		343 },
	{ 0,           "Zo",	STRING,		344 },
	{ 0,         "smgt",	STRING,		344 },
	{ 0,           "Zp",	STRING,		345 },
	{ 0,        "smgtp",	STRING,		345 },
	{ 0,           "Zq",	STRING,		346 },
	{ 0,         "sbim",	STRING,		346 },
	{ 0,           "Zr",	STRING,		347 },
	{ 0,         "scsd",	STRING,		347 },
	{ 0,           "Zs",	STRING,		348 },
	{ 0,         "rbim",	STRING,		348 },
	{ 0,           "Zt",	STRING,		349 },
	{ 0,         "rcsd",	STRING,		349 },
	{ 0,           "Zu",	STRING,		350 },
	{ 0,        "subcs",	STRING,		350 },
	{ 0,           "Zv",	STRING,		351 },
	{ 0,        "supcs",	STRING,		351 },
	{ 0,           "Zw",	STRING,		352 },
	{ 0,         "docr",	STRING,		352 },
	{ 0,           "Zx",	STRING,		353 },
	{ 0,        "zerom",	STRING,		353 },
	{ 0,           "Zy",	STRING,		354 },
	{ 0,         "csnm",	STRING,		354 },
	{ 0,           "Km",	STRING,		355 },
	{ 0,        "kmous",	STRING,		355 },
	{ 0,           "Mi",	STRING,		356 },
	{ 0,        "minfo",	STRING,		356 },
	{ 0,           "RQ",	STRING,		357 },
	{ 0,        "reqmp",	STRING,		357 },
	{ 0,           "Gm",	STRING,		358 },
	{ 0,         "getm",	STRING,		358 },
	{ 0,           "AF",	STRING,		359 },
	{ 0,        "setaf",	STRING,		359 },
	{ 0,           "AB",	STRING,		360 },
	{ 0,        "setab",	STRING,		360 },
	{ 0,           "xl",	STRING,		361 },
	{ 0,         "pfxl",	STRING,		361 },
	{ 0,           "dv",	STRING,		362 },
	{ 0,         "devt",	STRING,		362 },
	{ 0,           "ci",	STRING,		363 },
	{ 0,         "csin",	STRING,		363 },
	{ 0,           "s0",	STRING,		364 },
	{ 0,         "s0ds",	STRING,		364 },
	{ 0,           "s1",	STRING,		365 },
	{ 0,         "s1ds",	STRING,		365 },
	{ 0,           "s2",	STRING,		366 },
	{ 0,         "s2ds",	STRING,		366 },
	{ 0,           "s3",	STRING,		367 },
	{ 0,         "s3ds",	STRING,		367 },
	{ 0,           "ML",	STRING,		368 },
	{ 0,        "smglr",	STRING,		368 },
	{ 0,           "MT",	STRING,		369 },
	{ 0,        "smgtb",	STRING,		369 },
	{ 0,           "Xy",	STRING,		370 },
	{ 0,        "birep",	STRING,		370 },
	{ 0,           "Zz",	STRING,		371 },
	{ 0,        "binel",	STRING,		371 },
	{ 0,           "Yv",	STRING,		372 },
	{ 0,         "bicr",	STRING,		372 },
	{ 0,           "Yw",	STRING,		373 },
	{ 0,      "colornm",	STRING,		373 },
	{ 0,           "Yx",	STRING,		374 },
	{ 0,        "defbi",	STRING,		374 },
	{ 0,           "Yy",	STRING,		375 },
	{ 0,        "endbi",	STRING,		375 },
	{ 0,           "Yz",	STRING,		376 },
	{ 0,     "setcolor",	STRING,		376 },
	{ 0,           "YZ",	STRING,		377 },
	{ 0,       "slines",	STRING,		377 },
	{ 0,           "S1",	STRING,		378 },
	{ 0,        "dispc",	STRING,		378 },
	{ 0,           "S2",	STRING,		379 },
	{ 0,        "smpch",	STRING,		379 },
	{ 0,           "S3",	STRING,		380 },
	{ 0,        "rmpch",	STRING,		380 },
	{ 0,           "S4",	STRING,		381 },
	{ 0,         "smsc",	STRING,		381 },
	{ 0,           "S5",	STRING,		382 },
	{ 0,         "rmsc",	STRING,		382 },
	{ 0,           "S6",	STRING,		383 },
	{ 0,        "pctrm",	STRING,		383 },
	{ 0,           "S7",	STRING,		384 },
	{ 0,        "scesc",	STRING,		384 },
	{ 0,           "S8",	STRING,		385 },
	{ 0,        "scesa",	STRING,		385 },
	{ 0,           "bs",	BOOLEAN,	 37 },
	{ 0,         "OTbs",	BOOLEAN,	 37 },
	{ 0,           "ns",	BOOLEAN,	 38 },
	{ 0,         "OTns",	BOOLEAN,	 38 },
	{ 0,           "pt",	BOOLEAN,	 39 },
	{ 0,         "OTpt",	BOOLEAN,	 39 },
	{ 0,           "NL",	BOOLEAN,	 40 },
	{ 0,         "OTNL",	BOOLEAN,	 40 },
	{ 0,           "nc",	BOOLEAN,	 41 },
	{ 0,         "OTnc",	BOOLEAN,	 41 },
	{ 0,           "xr",	BOOLEAN,	 42 },
	{ 0,         "OTxr",	BOOLEAN,	 42 },
	{ 0,           "EP",	BOOLEAN,	 43 },
	{ 0,         "OTEP",	BOOLEAN,	 43 },
	{ 0,           "OP",	BOOLEAN,	 44 },
	{ 0,         "OTOP",	BOOLEAN,	 44 },
	{ 0,           "HD",	BOOLEAN,	 45 },
	{ 0,         "OTHD",	BOOLEAN,	 45 },
	{ 0,           "LC",	BOOLEAN,	 46 },
	{ 0,         "OTLC",	BOOLEAN,	 46 },
	{ 0,           "UC",	BOOLEAN,	 47 },
	{ 0,         "OTUC",	BOOLEAN,	 47 },
	{ 0,           "xq",	BOOLEAN,	 48 },
	{ 0,         "OTxq",	BOOLEAN,	 48 },
	{ 0,           "xx",	BOOLEAN,	 49 },
	{ 0,         "OTxx",	BOOLEAN,	 49 },
	{ 0,           "dB",	NUMBER,		 33 },
	{ 0,         "OTdB",	NUMBER,		 33 },
	{ 0,           "dC",	NUMBER,		 34 },
	{ 0,         "OTdC",	NUMBER,		 34 },
	{ 0,           "dF",	NUMBER,		 35 },
	{ 0,         "OTdF",	NUMBER,		 35 },
	{ 0,           "dV",	NUMBER,		 36 },
	{ 0,         "OTdV",	NUMBER,		 36 },
	{ 0,           "dN",	NUMBER,		 37 },
	{ 0,         "OTdN",	NUMBER,		 37 },
	{ 0,           "kn",	NUMBER,		 38 },
	{ 0,         "OTkn",	NUMBER,		 38 },
	{ 0,           "dT",	NUMBER,		 39 },
	{ 0,         "OTdT",	NUMBER,		 39 },
	{ 0,           "ug",	NUMBER,		 40 },
	{ 0,         "OTug",	NUMBER,		 40 },
	{ 0,           "bc",	STRING,		386 },
	{ 0,         "OTbc",	STRING,		386 },
	{ 0,           "ko",	STRING,		387 },
	{ 0,         "OTko",	STRING,		387 },
	{ 0,           "ma",	STRING,		388 },
	{ 0,         "OTma",	STRING,		388 },
	{ 0,           "ml",	STRING,		389 },
	{ 0,         "OTml",	STRING,		389 },
	{ 0,           "mu",	STRING,		390 },
	{ 0,         "OTmu",	STRING,		390 },
	{ 0,           "nl",	STRING,		391 },
	{ 0,         "OTnl",	STRING,		391 },
	{ 0,           "MT",	BOOLEAN,	 50 },
	{ 0,         "GUMT",	BOOLEAN,	 50 },
	{ 0,           "tw",	NUMBER,		 41 },
	{ 0,         "GUtw",	NUMBER,		 41 },
	{ 0,           "ki",	STRING,		392 },
	{ 0,         "UWki",	STRING,		392 },
	{ 0,           "kk",	STRING,		393 },
	{ 0,         "UWkk",	STRING,		393 },
	{ 0,           "kz",	STRING,		394 },
	{ 0,         "UWkz",	STRING,		394 },
	{ 0,           "xc",	BOOLEAN,	 51 },
	{ 0,         "UWxc",	BOOLEAN,	 51 },
	{ 0,           "xl",	BOOLEAN,	 52 },
	{ 0,         "UWxl",	BOOLEAN,	 52 },
	{ 0,           "Sl",	STRING,		395 },
	{ 0,          "sl1",	STRING,		395 },
	{ 0,           "Sr",	STRING,		396 },
	{ 0,          "sr1",	STRING,		396 },
	{ 0,           "SL",	STRING,		397 },
	{ 0,           "sl",	STRING,		397 },
	{ 0,           "SR",	STRING,		398 },
	{ 0,           "sr",	STRING,		398 },
};

struct name_table_entry *cap_hash_table[HASHTABSIZE];

#if (BOOLCOUNT!=53)||(NUMCOUNT!=42)||(STRCOUNT!=399)
#error	--> terminfo.h and comp_captab.c disagree about the <--
#error	--> numbers of booleans, numbers and/or strings <--
#endif
