'\" t
.TH X3270 1 "28 October 1993"
.SH NAME
x3270 \-
.SM IBM
host access tool
.SH SYNOPSIS
.B x3270
[
.I options
] [ [
.B a:
]
.I hostname
]
.SH DESCRIPTION
.B x3270
opens a telnet connection to an
.SM IBM
host in an X window.
Since the window created by
.B x3270
can use its own font for displaying characters, is a fairly accurate
representation of an
.SM IBM
3278.
It is similar to
.IR tn3270 (1)
except that it is X-based, not curses-based.
.LP
Prepending an
.B a:
onto
.I hostname
puts
.B x3270
in initial
.SM ANSI
X3.64 emulation mode.
See
.SM "ANSI MODE"
below for further information.
.SH OPTIONS
.B x3270 
is a toolkit based program, so it understands standard options and resources.
It also understands the following options:
.TP
.B \-activeicon
Specifies that the icon should be a miniature version of the screen image.
See
.SM ICONS
below.
.TP
.B \-apl
Sets up
.SM APL
mode.
This is actually an abbreviation for several options.
See
.SM "APL SUPPORT"
below.
.TP
.BI \-efont " name"
Specifies a font for the emulator window.
See
.SM FONTS
below.
.TP
.BI \-keymap " name"
Specifies a keymap name and optional modifiers.
See
.SM KEYMAPS
below.
.TP
.BI \-charset " name"
Specifies an
.SM EBCDIC
national character set.
See
.SM CHARACTER SETS
below.
.TP
.BI \-model " n"
The type of 3278 to be emulated.
The sizes of various emulated models are:
.PP
.RS
.TS
center;
c c c l .
Model	Columns	Rows
_
2	80	24
3	80	30
4	80	43	default
5	132	27
.TE
.RE
.TP
.B \-mono
Forces monochrome emulation on a color display.
.TP
.B \-once
Causes
.B x3270
to exit after a host disconnects.
.TP
.BI \-port " n"
Specifies a different
.SM TCP
port to connect to.
.I n
can be a name from
.B /etc/services
like
.BR telnet ,
or a number.
.TP
.BI \-tn " name"
Specifies the terminal name to be transmitted over the telnet connection.
The default name is
.BI IBM\-3278\- n
where
.I n
is the model number.
The name can also be specified with the "x3270.termName" resource.
.SH FONTS
By default,
.B x3270
does not use the "*font" resource for its main display.
Instead, it uses a custom 14-point font called
.BR 3270 ,
which is a close
approximation of a real 3278 display and allows
.B x3270
to display a complete
.SM EBCDIC
character set and special status-line symbols.
A more compact font,
.BR 3270\-12 ,
is also supported.
.LP
The font may be specified with the
.B \-efont
option or the "x3270.emulatorFont" resource.
.LP
.B x3270
can also use any constant-spaced X font, but unless the font implements the
entire
.SM ISO
8859\-1 (Latin-\1) character set,
.B x3270
may not properly display several
.SM EBCDIC
graphics that do not have
.SM ASCII
equivalents.
.PP
.B Note:
.B x3270
requires that fonts have a
.SM SPACING
property with the value
.SM C.
Many otherwise valid fonts are not properly configured and appear unusable.
You may override the check by placing a `!' in front of the font name.
.LP
For speed,
.B x3270
also uses a second font for bold (high-intensity) characters.
It finds this font by appending
.B bold
to the name of its emulator font; if such a font cannot be found, it uses the
slower method of overstriking each bold character.
The bold font may be specified explicitly with the
.B \-bfont
option or the "x3270.boldFont" resource.
.SH "CHARACTER SETS"
The
.B \-charset
option or the "x3270.charset" resource controls the
.SM EBCDIC
national character set used by
.B x3270.
By default, the U.S. character set (code 01) is used.
Available sets include:
.PP
.TS
center;
l c
lfB c.
Charset Name	Q121 Code
_
us	01
german	03
finnish	09
uk	22
norwegian	23
french	30
.TE
.PP
The charset name
.B bracket
is also supported to communicate with older
.SM IBM
hosts which use
.SM EBCDIC
codes 0xAD and 0xBD for the `[' and `]' characters, respectively.
.PP
You can also specify national-language translations for your keyboard; see
.SM KEYMAPS
below.
.SH KEYPAD
A keypad may optionally be displayed, with a mouse-clickable button for each
3270 function key (these functions are also available from the keyboard).
The keypad can be turned on and off by clicking on the "keypad" button in the
upper-right-hand corner of the window.
The "x3270.keypad" resource controls where it is displayed.
Options are:
.PP
.TS
center;
l l.
right	in a separate window, to the right of the screen
bottom	in a separate window, below the screen
integral	in the same window as the screen, below it
.TE
.PP
The default is
.B right.
.PP
If the "x3270.keypadOn" resource is set to
.BR true ,
the keypad will be displayed at startup.
.SH "HOSTS DATABASE"
.B x3270
uses the
.I ibm_hosts
database to construct a pull-down menu of hosts to connect to.
It supports the
.B loginstring
function, which allows you to specify a macro to be sent to the host when the
connection is first made.
See
.IR ibm_hosts (5)
for details.
.LP
You may specify a different
.I ibm_hosts
database with the "x3270.hostsFile" resource.
.SH COLOR
.B x3270 
does not understand
.SM IBM
3270 color protocols.
It draws text in one of three colors depending on the field attributes.
Those colors may be customized using the following resources (shown with their
default values):
.nf
	x3270.normalColor:	green
	x3270.boldColor:	cyan
	x3270.inputColor:	orange
	x3270.colorBackground:	black
	x3270.selectBackground:	dim gray
.fi
.PP
It is possible to get monochrome colors and behavior using the
.B \-mono
switch.
.SH "ANSI MODE"
Some hosts use an
.SM ASCII
front-end to do initial login negotiation, then later switch to 3270 mode.
Prepending an
.B a:
onto the
.I hostname
causes
.B x3270
to emulate an
.SM ANSI
X.64 terminal until the host places it in 3270 mode (telnet
.SM BINARY
and
.SM "SEND EOR"
modes).
The emulation is far from complete, however, and not intended to make
.B x3270
a replacement for
.IR xterm (1).
.PP
If the host later negotiates to stop functioning in 3270 mode,
.B x3270
will disconnect.
.PP
When emulating an
.SM ANSI
terminal,
.B x3270
supports both character-at-a-time mode and line mode operation.
You may select the mode with a menu option.
When in line mode, the special characters and operational characteristics are
defined by resources:
.PP
.TS
center;
l c c.
Mode/Character	Resource	Default
_
Translate CR to NL	x3270.icrnl	true
Translate NL to CR	x3270.inlcr	false
Erase previous character	x3270.erase	^?
Erase entire line	x3270.kill	^U
Erase previous word	x3270.werase	^W
Redisplay line	x3270.rprnt	^R
Ignore special meaning of next character	x3270.lnext	^V
Interrupt	x3270.intr	^C
Quit	x3270.quit	^\\\\
End of file	x3270.eof	^D
.TE
.SH MENUS
.B x3270
has a menu bar with three pull-down menus (Quit, Options, and
Connect) and a button to turn the keypad on and off.
The pull-down menus are also available as pop-up menus by using the "Ctrl"
key and the left, middle and right mouse buttons, respectively.
.PP
The menu bar can be turned off by setting the "x3270.menuBar" resource to
.B false.
.SH ICONS
If the
.B \-activeicon
option is given (or the "x3270.activeIcon" resource is set to
.BR true ),
.B x3270
will attempt to make its icon a miniature version of the current screen image.
This function is highly dependent on your window manager:
.TP
.B mwm
The size of the icon is limited by the "Mwm.iconImageMaximum" resource, which
defaults to
.B 50x50.
The image will be clipped at the bottom and right.
The icon cannot accept keyboard input.
.TP
.B olwm
The full screen image of all 3270 models can be displayed on the icon.
However, the icon cannot be resized, so if the model is later changed with an
.B x3270
menu option, the icon image will be corrupted.
The icon cannot accept keyboard input.
.TP
.BR twm " and " tvtwm
The full screen image of all 3270 models can be displayed on the icon, and the
icon can be resized.
The icon can accept keyboard input.
.IP
However,
.B twm
does not put labels on application-supplied icon windows.
You can have
.B x3270
add its own label to the icon by setting the "x3270.labelIcon" resource to
.B true.
The default font for icon labels is
.BR 8x13 ;
you may change it with the "x3270.iconLabelFont" resource.
.SH KEYMAPS
.PP
The type of keyboard may be specified with the
.B \-keymap
switch or using either the 
.SM KEYMAP
or
.SM KEYBD
environment variables.
The types of supported keyboards include
.BR hp\-k1 ,
.BR ncd ,
.BR sun\-k4 ,
and
.BR sun\-k3 \.
.PP
The keymap may also be specified as a comma-separated list of names.
Later definitions override earlier ones.
This is used to specify both a primary keyboard type and a set of modifiers.
The modifiers defined include:
.TP
.B ow
(OpenWindows) Swaps the middle and right mouse button definitions, so the
middle button performs the "Paste" function.
Also changes the cut and paste actions to use the OpenWindows
.SM CLIPBOARD.
.TP
.B alt
Replaces all of the "Meta" key definitions with "Alt" definitions,
for keyboards which do not have a "Meta" key.
.TP
.B apl
Allows entry of
.SM APL
characters (see
.SM "APL SUPPORT"
below).
.TP
.B finnish7
Replaces the bracket, brace and bar keys with common Finnish characters.
.TP
.B norwegian7
Replaces the bracket, brace and bar keys with common Norwegian characters.
.PP
The X Toolkit translation mechanism is used to provide keyboard emulation.
It maps 
.B events
into 
.B actions.
The best documentation can be found with X11R5 X toolkit documents, but the
following should suffice for simple customization.
.PP
An Xt event consists of (at least) four fields.  The first is called a
.B modifier.
It may be any combination of meta, shift and ctrl.  If it is prefaced by !,
it means those modifiers only.  The second field is the specific event,
in 
.B x3270
usually just <Key>.  The third field is the detail field, which gives the
actual key.  The name of the key may be determined using the R5
.I xev
program.  The last field is the action, which is the internal emulator
function.  A complete list of actions may be found later in the manual.
.PP
There are three levels of translation tables in
.B x3270.
The first is a default, compiled in table. It defines alphabetic, numeric,
function keys, and such basic functions as Enter and Delete.  It allows a
minimal useful functionality.
.PP
The second level is a keyboard specific table, which is found in the
application default file, which defines actions for such things as keypad
keys, and keys unique to certain keyboards.
.PP
The third level is a user customizable table which may be used to augment or
override key definitions.  This will typically be found in the users 
.B .Xdefaults
file.
The naming for a sun4 keyboard would be:
.RS
x3270.keymap.default:
.br
x3270.keymap.sun\-k4:
.br
x3270.keymap.sun\-k4.user:
.RE
.PP
The basic default translation table is:
.RS
.TS
l l .
<Key>Return:	Enter()
<Key>Linefeed:	Newline()
!Shift<Key>Tab:	BackTab()
<Key>Tab:	Tab()
<Key>Home:  	Home()
<Key>Left:	Left()
!Meta<Key>Left:	Left2()
<Key>Right: 	Right()
!Meta<Key>Right:	Right2()
<Key>Up:	Up()
<Key>Down:	Down()
<Key>Delete: 	Delete()
<Key>BackSpace: 	BackSpace()
<Btn1Down>:	select\-start()
<Btn1Motion>:	select\-extend()
<Btn2Down>:	ignore()
<Btn2Motion>:	ignore()
<Btn2Up>:	insert\-selection(PRIMARY)
<Btn3Down>:	start\-extend()
<Btn3Motion>:	select\-extend()
<BtnUp>:	select\-end(PRIMARY)
Shift<Btn1Down>:	MoveCursor()
!Meta<Key>F1:	PF13()
!Meta<Key>F2:	PF14()
!Meta<Key>F3:	PF15()
!Meta<Key>F4:	PF16()
!Meta<Key>F5:	PF17()
!Meta<Key>F6:	PF18()
!Meta<Key>F7:	PF19()
!Meta<Key>F8:	PF20()
!Meta<Key>F9:	PF21()
!Meta<Key>F10:	PF22()
!Meta<Key>F11:	PF23()
!Meta<Key>F12:	PF24()
<Key>F1:	PF1()
<Key>F2:	PF2()
<Key>F3:	PF3()
<Key>F4:	PF4()
<Key>F5:	PF5()
<Key>F6:	PF6()
<Key>F7:	PF7()
<Key>F8:	PF8()
<Key>F9:	PF9()
<Key>F10:	PF10()
<Key>F11:	PF11()
<Key>F12:	PF12()
Meta<Key>1:	PA1()
Meta<Key>2:	PA2()
Meta<Key>3:	PA3()
Meta<Key>a:	Attn()
Meta<Key>b:	PrintWindow()
Meta<Key>c:	Clear()
Meta<Key>d:	Delete()
Meta<Key>h:	Home()
Meta<Key>i:	Insert()
Meta<Key>l:	Redraw()
Meta<Key>p:	PrintText()
Meta<Key>q:	Quit()
Meta<Key>r:	Reset()
Ctrl<Key>u:	DeleteField()
Ctrl<Key>w:	DeleteWord()
:<Key>:	Default()
.TE
.RE
.PP
Meta is the diamond shaped key on a sun\-k4, "Alt" on an
.SM NCD,
"Extend Char" on an
.SM HP.
The following
.I xmodmap
command must be used on the
.SM NCD
to allow use the the "Alt"
key:
.PP
.RS
xmodmap \-e "keysym Alt_L = Meta_L"
.RE
.PP
The left mouse button may be used to make a selection.
Clicking once unselects the current selection.
Clicking twice selects the word under the mouse cursor.
Clicking three times selects the line under the mouse cursor.
Clicking and dragging selects a rectangular area of the display.
.PP
The middle mouse button may be used to paste a selection.
.PP
The right mouse button may also be used for selections, selecting the
rectangular area between the current position and where the left button was
last pressed.
.PP
.PP
On color displays, the "x3270.selectBackground" resource is used to distinguish
the selected text from the rest of the screen.
On monochrome displays, selected text is in reverse video.
(It can be distinguished from a block cursor because the block cursor covers
slightly less than an entire character position on the screen.)
.PP
The left mouse button, when pressed with the "Shift" key held down, moves the
3270 cursor to the where the mouse cursor is pointing.
.PP
This is the complete list of actions:
.PP
.RS
.TS
l l
.
Attn	attention key
AltCursor	switch between block and underscore cursor
BackSpace	move cursor left (or send ASCII BS)
BackTab	tab to start of previous input field
Clear	clear screen
Compose	next two keys form a special symbol
CursorSelect	Cursor Select AID
Default	enter key literally
Delete	delete character under cursor (or send ASCII DEL)
DeleteField	delete the entire field
DeleteWord	delete the current or previous word
Down	move cursor down
Dup	duplicate field
Enter	Enter AID (or send ASCII CR)
Erase	erase previous character (or send ASCII BS)
EraseEOF	erase to end of current field
EraseInput	erase all input fields
FieldEnd	move cursor to end of field
FieldMark	mark field
Home	move cursor to first input field
Insert	set insert mode
Key(\fIkeysym\fP)	insert key \fIkeysym\fP
Left	move cursor left
Left2	move cursor left 2 positions
MoveCursor	move cursor to mouse position
MonoCase	toggle uppercase-only mode
Newline	move cursor to first field on next line (or send ASCII LF)
PA1-PA3	Program Attention AID
PF1-PF24	Program Function AID
PrintText(\fIcommand\fP)	print screen text on printer
PrintWindow(\fIcommand\fP)	print screen image (bitmap) on printer
Quit	exit \fBx3270\fP
Redraw	redraw window
Reset	reset locked keyboard
Right	move cursor right
Right2	move cursor right 2 positions
SetFont(\fIfont\fP)	change emulator font
String(\fIstring\fP)	insert string (macro facility)
SysReq	System Request AID
Tab	move cursor to next input field
ToggleInsert	toggle insert mode
Up	move cursor up
_
(the following are similar to xterm)
_
ignore	do nothing
insert\-selection([\fIatom\fP[\fI,atom...\fP]])	paste selection
move-select	a combination of \fBMoveCursor\fP and \fBselect\-start\fP
select\-extend	move the end of a selection
select\-start	mark the beginning of a selection
start\-extend	begin marking the end of a selection
.TE
.RE
.SH MACROS
A simple macro facility is provided via the String action.
The arguments to String() are one or more double-quoted strings which are
inserted directly as if typed.
Hex constants may be entered in the form 0xff, and the C backslash conventions
are honored as follows:
.RS
.TS
l l.
\eb	Left
\ef	Clear
\en	Enter
\er	Newline
\et	Tab
.TE
.RE
.PP
An example action would be:
.RS
Meta<Key>p: String("probs clearrdr\en")
.RE
.PP
.B Note:
The strings are in
.SM ASCII
and converted to
.SM EBCDIC,
so beware of inserting
control codes.
.SH "COMPOSITE CHARACTERS"
If your keyboard has a "Compose" key,
.B x3270
allows the direct entry of accented letters and special symbols.
Pressing and releasing the "Compose" key, followed by two other keys, causes
entry of the symbol combining those two keys.
For example, "Compose" followed by the "C" key and the "," (comma) key, enters
the "C-cedilla" symbol.
A `C' on the status line indicates a pending composite character.
.PP
The mappings between these pairs of ordinary keys and the symbols they
represent is controlled by the "x3270.composeMap" resource; it gives the
name of the map to use.
The maps themselves are named "x3270.composeMap.\fIname\fR".
The default is "latin1", which gives mappings for most of the symbols in the
.SM ISO
8859\-1 Latin\-1 character set that are not in the 7-bit
.SM ASCII
character set.
.PP
.B Note:
The default keymap defines the "Multi_key" keysym as the "Compose" key.
If your keyboard lacks such a key, you may set up your own "Compose" key with
a keymap that maps some other keysym onto the "Compose" action.
.SH "APL SUPPORT"
.B x3270
supports an
.SM APL
character set and the entry of
.SM APL
characters from the keyboard.
.PP
.SM APL
characters are supported by a special font
.RB ( 3270\-apl )
which replaces the accented characters and special symbols with
.SM APL
graphics.
.PP
Keyboard entry of
.SM APL
characters is supported through the
.B apl
keymap modifier.
This modifier defines the "Alt" key as an
.SM APL
shift key, with a typical
.SM APL
keyboard layout,
.IR e . g .,
"Alt" pressed with the
.B A
key results in the \s-1APL\s+1 `alpha' symbol.
Overstruck characters such as `quad-quote' are not defined as single
keystrokes; instead they are entered as composites (see
.SM "COMPOSITE CHARACTERS"
above).
A special composite map,
.BR apl ,
is provided for this purpose.
.PP
.B Note:
Some keyboards do not define the "Alt" key as a modifier, so keymaps that use
the "Alt" key will not function.
On a Sun for example, this can be remedied with the command:
.IP
xmodmap \-e "add mod2 = Alt_L"
.PP
For convenience, an
.B \-apl
option is defined, which is an abbreviation for the following resource
definitions:
.RS
x3270.emulatorFont: 3270\-apl
.br
.RI x3270.keymap: " your_keymap_name" ,apl
.br
x3270.charset: apl
.br
x3270.composeMap: apl
.RE
.PP
There are a number of
.SM APL
characters that are similar in appearance to non-\s-1APL\s+1 characters.
In particular, the \s-1APL\s+1 `stile', `slope,' `tilde' and `quotedot'
characters are similar to the \s-1EBCDIC\s+1 `bar', `backslash,' `tilde'
and `exclaim' characters.
The
.SM APL
characters are entered with the "Alt" key, and have slightly different
appearances.
.PP
The complete list of special
.SM APL
keysyms is as follows:
.PP
.RS
.TS
l c.
Keysym	\s-1EBCDIC\s+1 Code
_
apl_Aunderbar	41
apl_Bunderbar	42
apl_Cunderbar	43
apl_Dunderbar	44
apl_Eunderbar	45
apl_Funderbar	46
apl_Gunderbar	47
apl_Hunderbar	48
apl_Iunderbar	49
apl_Junderbar	51
apl_Kunderbar	52
apl_Lunderbar	53
apl_Munderbar	54
apl_Nunderbar	55
apl_Ounderbar	56
apl_Punderbar	57
apl_Qunderbar	58
apl_Runderbar	59
apl_Sunderbar	62
apl_Tunderbar	63
apl_Uunderbar	64
apl_Vunderbar	65
apl_Wunderbar	66
apl_Xunderbar	67
apl_Yunderbar	68
apl_Zunderbar	69
apl_alpha	b0
apl_bracketleft	ad
apl_bracketright	bd
apl_circle	9d
apl_circlebar	cd
apl_circleslope	cf
apl_circlestar	fd
apl_circlestile	cd
apl_del	ba
apl_delstile	dd
apl_delta	bb
apl_deltastile	dd
apl_deltaunderbar	fc
apl_deltilde	fb
apl_diaeresis	72
apl_diaeresisdot	ec
apl_diamond	70
apl_divide	b8
apl_downarrow	8b
apl_downcaret	78
apl_downcarettilde	cb
apl_downshoe	ab
apl_downstile	8e
apl_downtack	ac
apl_downtackjot	fe
apl_downtackup	da
apl_epsilon	b1
apl_epsilonunderbar	75
apl_iota	b2
apl_iotaunderbar	74
apl_jot	af
apl_leftarrow	9f
apl_leftshoe	9b
apl_lefttack	76
apl_multiply	b6
apl_notequal	be
apl_notgreater	8c
apl_notless	ae
apl_omega	b4
apl_overbar	a2
apl_plusminus	9e
apl_quad	90
apl_quaddivide	ee
apl_quadjot	73
apl_quadquote	de
apl_quotedot	db
apl_rho	b3
apl_rightarrow	8f
apl_rightshoe	9a
apl_righttack	77
apl_slashbar	ea
apl_slope	b7
apl_slopebar	eb
apl_slopequad	ce
apl_splat	9c
apl_squad	cc
apl_stile	bf
apl_tilde	80
apl_uparrow	8a
apl_upcaret	71
apl_upcarettilde	ca
apl_upshoe	aa
apl_upshoejot	df
apl_upstile	8d
apl_uptack	bc
apl_uptackjot	ef
.TE
.RE
.SH "SCREEN PRINTING"
Screen printing is handled through the PrintText and PrintWindow actions.
.PP
The PrintText action (usually assigned to the key <Meta>p) sends the current
screen image to the printer as 
.SM ASCII
characters.
The default command used to print the data is controlled by
the "x3270.printTextCommand" resource; the default is
.BR lpr .
You may also use a keymap definition to pass a print command the PrintText
action itself.
The command receives the screen text as its standard input.
For example, the following keymap will save the screen text in a file:
.IP
Meta<Key>f: PrintText("cat >screen.image")
.PP
Note: HardPrint is an alias for PrintText.
.PP
The PrintWindow action (usually assigned to the key <Meta>b) sends the current
screen image to the printer as a bitmap.
The default command used to print the data is controlled by
the "x3270.printWindowCommand" resource; the default is
.IP
.BR "xwd -id %d | xpr | lpr" .
.PP
You may also use a keymap definition to pass a print command to the
PrintWindow action itself.
If the command contains the text "%d", the window ID of
.B x3270
will be substituted before it is run.
For example, the following keymap will pop up a duplicate of the current
screen image:
.IP
Meta<Key>g: PrintWindow("xwd -id %d | xwud &")
.SH BUGS
Cursor highlighting will not work with if you use the
.B NoTitleFocus
option in your .twmrc file.
.SH FILES
.nf
/usr/lib/X11/app\-defaults/X3270
/usr/local/pub/ibm_hosts
.SH "SEE ALSO"
telnet(1), tn3270(1), ibm_hosts(5)
.br
X Toolkit Intrinsics (R5 version)
.br
Data Stream Programmer's Reference, IBM GA23\-0059
.br
Character Set Reference, IBM GA27\-3831
.SH AUTHORS
Robert Viduya \- SunView based 3270tool
.br
Jeff Sparkes \- X11 port
.br
Paul Mattes \- X enhancements and fixes
