.TH XCUCKOO 1 "local" 
.SH NAME
xcuckoo - cuckoo clock for X
.SH SYNOPSIS
.nf
\fBxcuckoo\fP [-display \fIdisplay\fP]  [-window \fIname\fP]    [-icon] 
        [-command \fIcommand\fP]  [-mode replace|append|prepend]
        [-separator \fIstring\fP] [-update \fIseconds\fP] [-wait \fIseconds\fP]
        [-version]
.fi
.SH DESCRIPTION
.I xcuckoo
is an X application, which, like its avian cousin, lays its eggs in
another's nest. In its basic form xcuckoo is a clock,
displaying the time in the form hh:mm. Alternatively, the display may be the
1-line output of an arbitrary command pipeline. The nest that is used
is the title bar of some window.  xcuckoo runs until terminated via a
SIGHUP, SIGINT, SIGQUIT or SIGTERM signal, when the original contents
of the title bar are reinstated, or the host window no longer exists
at the time an update is due.
.SH OPTIONS
.PP
xcuckoo accepts the following command line options:
.TP
.B -display \fIdisplay\fP
The display to open.
.TP
.B -window \fIname\fP
The name of the window whose title bar is to be used.
.TP
.B -icon
If the window's icon name should be updated too.
.TP
.B -command \fIcommand\fP
The command whose output is to be displayed.
.TP
.B -mode replace|append|prepend
How the output should be related to the current title bar contents.
.TP
.B -separator \fIstring\fP
How the output should be separated from the existing title bar contents
if the mode is append or prepend.
.TP
.B -update \fIseconds\fP
The frequency with which to execute the command and update the title bar.
.TP
.B -wait \fIseconds\fP
How long to wait before abandoning attempts to locate the target window
- useful in startup scripts when the target can't be guaranteed to be
available immediatley.
.TP
.B -version
Print the version number on standard output and exit.
.PP
Executing xcuckoo with no options is equivalent to executing
.nf

xcuckoo -window 'TWM Icon Manager' -command 'date "+%H:%M"' 
        -mode replace -update 60 -wait 0

.fi        
except that date isn't actually executed - localtime is called.
.SH RESOURCES
xcuckoo recognises top level resources stored in the RESOURCE_MANAGER
property of the server's root window that have the same names as the
option keywords, except for \fIdisplay\fP, since the display has to be 
opened in order to read the property, and version. They are, with their 
defaults:
.nf

      window:    TWM Icon Manager
      icon:      false
      command:   date "+%H:%M"
      mode:      replace
      separator: <space>
      update:    60
      wait:      0

.fi
Any value other than \fItrue\fP for the icon resource is equivalent to
\fIfalse\fP.
.SH EXAMPLES
.nf
xcuckoo -window mailbox -command date -mode append -wait 30

xcuckoo -command 'echo `who | wc -l` users' -update 3000
.fi
.SH ENVIRONMENT
.PP
.TP
.B DISPLAY
the default host and display number.
.SH BUGS
Just like real cuckoos, xcuckoo may lay its eggs in more than one nest. If the
host application is terminated and its window ID reallocated before the next
update takes place then xcuckoo will be unaware that anything has happened and
proceed to impose on the new owner. Of course, you are at liberty to interpret
this behaviour as a feature.
.SH AUTHOR
Jim Wight (j.k.wight@newcastle.ac.uk)
.br
Computing Laboratory, The University, Newcastle upon Tyne, UK, NE1 7RU
.SH ACKNOWLEDGEMENTS
Gerry M Tomlinson <gerry.tomlinson@newcastle.ac.uk> for the initial idea; 
in fact an early version was called xgmt. Simon Marshall 
<S.Marshall@uk.ac.hull.seq> and Malcolm Strickland 
<chuck-strickland@orl.mmc.com> for ideas for enhancements.
