/*
 * defaults.c
 * 
 * Kevin P. Smith  6/11/89
 * 
 * $Log: defaults.c,v $ Revision 1.6  1993/10/05  16:40:38  hadley checkin
 * 
 * Revision 1.6  1993/10/05  16:38:08  hadley checkin
 * 
 * 
 */
#include "copyright2.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <sys/file.h>
#include <unistd.h>
#include "Wlib.h"
#include "defs.h"
#include "struct.h"
#include "data.h"

#include "prog_version.h"

struct stringlist
{
  char           *string;
  char           *value;
  struct stringlist *next;
};

struct stringlist *defaults = NULL;

char           *getenv ();
char           *strdup ();

#ifdef NBTDIST
char           *
                new_param (v)

  char           *v;
{
  char           *temp;

  temp = strdup (v);

#ifdef nodef
  if (strlen (temp) > 12)
  {
    printf ("Distress stat: '%s' is too long. (max = 12)\n", v);
    temp[12] = '\0';
  }
#endif

  return temp;
}



figure_distress (file, v)
  char           *file, *v;
{
  int             index = 0;
  char           *check;

  if ((check = strstr (file, "d.sb.")) != NULL)
    index = 1;			/* its a SB param */
  else if ((check = strstr (file, "d.")) == NULL)
  {
    fprintf (stderr, "Unknown distress param %s\n", file);
    return;
  }
  file = check;
  /* set on/offs */
  if ((check = strstr (file, "whole")) != NULL)
  {
    distress[index].shld_on = 0;/* reset the on/offs */
    distress[index].dam_on = 0;
    distress[index].wtmp_on = 0;
    distress[index].etmp_on = 0;
    distress[index].arms_on = 0;
    if (strstr (v, "shld") != NULL)
      distress[index].shld_on = 1;
    if (strstr (v, "dam") != NULL)
      distress[index].dam_on = 1;
    if (strstr (v, "wtmp") != NULL)
      distress[index].wtmp_on = 1;
    if (strstr (v, "etmp") != NULL)
      distress[index].etmp_on = 1;
    if (strstr (v, "arms") != NULL)
      distress[index].arms_on = 1;
  }
  /* Do the shields */
  else if ((check = strstr (file, "shld")) != NULL)
  {
    if (strstr (check, "lvl"))
      sscanf (v, "%d %d", &distress[index].min_shld, &distress[index].max_shld);
    else if (strstr (check, "low"))
      distress[index].low_shld = new_param (v);
    else if (strstr (check, "mid"))
      distress[index].mid_shld = new_param (v);
    else if (strstr (check, "high"))
      distress[index].high_shld = new_param (v);
  }
  /* Do the Damage */
  else if ((check = strstr (file, "dam")) != NULL)
  {
    if (strstr (check, "lvl"))
      sscanf (v, "%d %d", &distress[index].min_dam, &distress[index].max_dam);
    else if (strstr (check, "low"))
      distress[index].low_dam = new_param (v);
    else if (strstr (check, "mid"))
      distress[index].mid_dam = new_param (v);
    else if (strstr (check, "high"))
      distress[index].high_dam = new_param (v);
  }
  /* Do the wtmp */
  else if ((check = strstr (file, "wtmp")) != NULL)
  {
    if (strstr (check, "lvl"))
      sscanf (v, "%d %d", &distress[index].min_wtmp, &distress[index].max_wtmp);
    else if (strstr (check, "low"))
      distress[index].low_wtmp = new_param (v);
    else if (strstr (check, "mid"))
      distress[index].mid_wtmp = new_param (v);
    else if (strstr (check, "high"))
      distress[index].high_wtmp = new_param (v);
  }
  /* Do the etmp */
  else if ((check = strstr (file, "etmp")) != NULL)
  {
    if (strstr (check, "lvl"))
      sscanf (v, "%d %d", &distress[index].min_etmp, &distress[index].max_etmp);
    else if (strstr (check, "low"))
      distress[index].low_etmp = new_param (v);
    else if (strstr (check, "mid"))
      distress[index].mid_etmp = new_param (v);
    else if (strstr (check, "high"))
      distress[index].high_etmp = new_param (v);
  }
  /* Do the armies */
  else if ((check = strstr (file, "arms")) != NULL)
  {
    if (strstr (check, "lvl"))
      sscanf (v, "%d %d", &distress[index].min_arms, &distress[index].max_arms);
    else if (strstr (check, "low"))
      distress[index].low_arms = new_param (v);
    else if (strstr (check, "mid"))
      distress[index].mid_arms = new_param (v);
    else if (strstr (check, "high"))
      distress[index].high_arms = new_param (v);
  }
  /* Do the fuel */
  else if ((check = strstr (file, "fuel")) != NULL)
  {
    if (strstr (check, "lvl"))
      sscanf (v, "%d %d", &distress[index].min_fuel, &distress[index].max_fuel);
    else if (strstr (check, "low"))
      distress[index].low_fuel = new_param (v);
    else if (strstr (check, "mid"))
      distress[index].mid_fuel = new_param (v);
    else if (strstr (check, "high"))
      distress[index].high_fuel = new_param (v);
  }
  /* What else is there except an error */
  else
    fprintf (stderr, "netrek: Unknown distress param %s\n", file);
}

#endif				/* NBTDIST */

int      init_macros = 1;

initDefaults (deffile)
  char           *deffile;	/* As opposed to defile? */
{
  FILE           *fp;
  char           *home;
  char           *v;
  char            file[BUFSIZ];
  struct stringlist *new;

#ifdef FEATURE
  struct dmacro_list *dm;
  struct dmacro_list *dm_def;
  int             notdone;
  int             ignore = 0;
  char            buf[256];

#ifdef MULTILINE_MACROS

  unsigned char   keysused[256];
 
  MZERO (keysused, sizeof(keysused));

#endif

  /* sizeof doesn't work if it isn't in the same source file, shoot me */
  MCOPY (dist_defaults, dist_prefered, sizedist);
#endif

  if (deffile && deffile[0] == '~')
  {
    home = getenv ("HOME");

    if (home)
    {
      strcpy (buf, home);
      strcat (buf, deffile[1]);
      deffile = buf;
    }
    else if (strlen (deffile) > 3)
      deffile = (char *) deffile[2];
  }

  if (!deffile)
  {
    deffile = file;
    home = getenv ("HOME");
    if (!findDefaults (home, /* initialized */ deffile))
    {
      if (home)
      {
	sprintf (file, "%s/.xtrekrc", home);
      }
      else
      {
	strcpy (file, ".xtrekrc");
      }
      deffile = file;
    }
  }
  fp = fopen (deffile, "r");
  if (!fp)
    return;
  IFDEBUG (printf ("Using defaults file %s\n", deffile);
  )

#ifdef NBT
  if (init_macros)
    init_macros = macrocnt = 0;	/* reset macros */
#endif

  while (fgets (file, BUFSIZ - 2, fp))
  {
    if (*file == '#')
      continue;
    if (*file != 0)
      file[strlen (file) - 1] = '\0';

#ifdef MAKE_XTREKRC
    if (strncmp (file, "cow-lite-exclude", strlen ("cow-lite-exclude")) == 0)
      ignore = 1;

    if (strncmp (file, "cow-lite-include", strlen ("cow-lite-include")) == 0)
      ignore = 0;

    if (strncmp (file, "cow-literc-override", strlen ("cow-literc-override")) == 0)
      cow_literc_override = 1;

    if (ignore)
      continue;
#endif

    v = file;
    while (*v != ':' && *v != 0)
    {
      v++;
    }
    if (*v == 0)
      continue;
    *v = 0;
    v++;
    while (*v == ' ' || *v == '\t')
    {
      v++;
    }

#ifdef NBT
    if (strncmp (file, "macro.", 6) == 0)
    {
      if (macrocnt == MAX_MACRO)
      {
	fprintf (stderr, "Maximum number of macros is %d\n", MAX_MACRO);
      }
      else if (file[6] == '?')
      {
	fprintf (stderr, "Cannot use '?' for a macro\n");
      }
      else
      {
	int             i = 0;

	if (file[6] == '^' && file[7] != '.')
	{
	  i = 1;
	  macro[macrocnt].key = (char) (file[7] + 96);
	}
	else
	  macro[macrocnt].key = file[6];

	macro[macrocnt].who = file[8 + i];
	macro[macrocnt].string = strdup (v);

#ifdef FEATURE
	macro[macrocnt].type = NBTM;

#ifdef MULTILINE_MACROS
	if (keysused[macro[macrocnt].key])
	  {
	    macro[keysused[macro[macrocnt].key] - 1].type = NEWMULTIM;
	    macro[macrocnt].type = NEWMULTIM;
	  }
	else
	  {
	    keysused[macro[macrocnt].key] = macrocnt + 1;
	  }
	
#endif /* MULTILINE_MACROS */
	
#endif
	
	macrocnt++;
      }
    }
    else
#endif

#ifdef FEATURE
    if (strncmp (file, "mac.", 4) == 0)
    {
      int             i = 0;

      if (macrocnt == MAX_MACRO)
      {
	fprintf (stderr, "Maximum number of macros is %d\n", MAX_MACRO);
      }
      else if (file[4] == '?')
	fprintf (stderr, "Cannot use '?' for a macro\n");
      else
      {
	if (file[4] == '^' && file[5] != '.')
	{
	  i = 1;
	  macro[macrocnt].key = (char) (file[5] + 96);
	}
	else
	  macro[macrocnt].key = file[4];

	if (file[5 + i] == '.')
	{
	  if (file[6 + i] == '%')
	  {
	    switch (file[7 + i])
	    {
	      case 'u':
	      case 'U':
	      case 'p':
		macro[macrocnt].who = MACRO_PLAYER;
		break;
	      case 't':
	      case 'z':
	      case 'Z':
		macro[macrocnt].who = MACRO_TEAM;
		break;
	      case 'g':
		macro[macrocnt].who = MACRO_FRIEND;
		break;
	      case 'h':
		macro[macrocnt].who = MACRO_ENEMY;
		break;
	      default:
		macro[macrocnt].who = MACRO_ME;
		break;
	    }
	    macro[macrocnt].type = NEWMMOUSE;

	    if (keysused[macro[macrocnt].key])
	      {
		printf("Multiline macros of nonstandard types are not recommended.\n");
		printf("You might experience strange behaviour of macros.\n");
		printf("Type: mouse specific, key: %c.\n",macro[macrocnt].key);
	      }
	  }
	  else
	  {
	    macro[macrocnt].who = file[6 + i];
	    macro[macrocnt].type = NEWMSPEC;
	  }
	}
	else
	{
	  macro[macrocnt].who = '\0';
	  macro[macrocnt].type = NEWM;

#ifdef MULTILINE_MACROS

	  if (keysused[macro[macrocnt].key])
	    {
	      printf("Multiline macros of nonstandard types are not recommended.\n");
	      printf("You might experience strange behaviour of macros.\n");
	      printf("Type: unspecified macro, key: %c.\n",macro[macrocnt].key);
	    }

#endif /* MULTILINE_MACROS */

	}

#ifdef MULTILINE_MACROS

	if (keysused[macro[macrocnt].key])
	  {
	    macro[keysused[macro[macrocnt].key] - 1].type = NEWMULTIM;
	    macro[macrocnt].type = NEWMULTIM;
	  }
	else
	  {
	    keysused[macro[macrocnt].key] = macrocnt + 1;
	  }
#endif /* MULTILINE_MACROS */

	macro[macrocnt].string = strdup (v);
	macrocnt++;
      }
    }

    else if (strncasecmp (file, "dist.", 5) == 0)
    {
      int             offset = 5;

      if (file[6] == '.')
	offset = 7;

      notdone = 1;
      for (dm = &dist_prefered[take], dm_def = &dist_defaults[take];
	   dm->name && notdone; dm++, dm_def++)

      {
	if (strcmpi (file + offset, dm->name) == 0)
	{
	  dm->macro = strdup (v);

#ifdef DIST_KEY_NAME
	  if (offset == 7)
	  {
	    dm->c = file[5];
	    dm_def->c = file[5];
	  }
#endif				/* DIST_KEY_NAME */

	  notdone = 0;
	}
      }
      if (notdone) fprintf (stderr, "Unknown RCD %s\n",file + offset);
     }

#ifdef BEEPLITE

    else if (strncasecmp (file, "lite.", 5) == 0)
    {
      int             offset = 5;
      char **lt;

      if (file[6] == '.')
	offset = 7;

      notdone = 1;

      for (lt = &distlite[take], dm = &dist_prefered[take], 
	   dm_def = &dist_defaults[take];
	   dm->name && notdone; dm++, dm_def++, lt++)
	{
	  if (strcmpi (file + offset, dm->name) == 0)
	    {
	      *lt = strdup (v);
	      printf("lite\n");

	      notdone = 0;
	    }
	}
      if (notdone) fprintf (stderr, "Unknown lite %s\n",file + offset);
    }

#endif /*BEEPLITE*/

    else if (strncasecmp (file, "singleMacro", 11) == 0)
    {
      char           *str = v;
      int             i;

      singleMacro = malloc ((strlen (v) > 64) ? strlen (v) : 64);

      for (i = 0; *str; str++)
	if (*str == '^')
	  singleMacro[i++] = (char) (*(++str) + 96);
	else
	  singleMacro[i++] = *str;

      singleMacro[i] = '\0';
    }
#endif

#ifdef NBTDIST
    if (strncmp (file, "d.", 2) == 0)
      figure_distress (file, v);
    else
#endif

    /* This allows us to include a default file into a .xtrekrc
     * the purpose of this was to allow me to use different defaults
     * files for different types of workstations, yet only have to edit
     * my macros and such once  SRS 3/3/94
     */
    if (strncmp (file, "include", 7) == 0)
      initDefaults(v);
    else if (*v != 0)
    {
      new = (struct stringlist *) malloc (sizeof (struct stringlist));
      new->next = defaults;
      new->string = strdup (file);
      new->value = strdup (v);
      defaults = new;
    }
  }
  fclose (fp);
}

/*
 * free up the defaults linked list, so that it can possibly be * re-read, or
 * for Possible cases where exit doesn't clear allocated * memory (for the
 * eventual Amiga port!)   -EM 12/3/92
 */
int
                FreeDefaults ()
{
  struct stringlist *freeme;
  struct stringlist *nextnode;
  nextnode = defaults;
  while (nextnode != NULL)
  {
    free (nextnode->value);
    free (nextnode->string);
    freeme = nextnode;
    nextnode = freeme->next;
    free (freeme);
  }
}

#ifndef AXP
char           *
                strdup (str)

#if defined(__STDC__)		/* doing this so strdup() will match
				 * prototype in string.h */
                const
#endif
  char           *str;
{
  char           *s;

  s = (char *) malloc (strlen (str) + 1);
  strcpy (s, str);
  return (s);
}
#endif /* strdup() */

char           *
                getdefault (str)
  char           *str;
{
  struct stringlist *sl;

  sl = defaults;
  while (sl != NULL)
  {
    if (strcmpi (sl->string, str) == 0)
    {
      return (sl->value);
    }
    sl = sl->next;
  }
  return (NULL);
}

/*
 * strcmpi tweaked 9/17/92 E-Mehlhaff to not tweak the strings it's * called
 * with... * writing into a 'constant' strings space is bad!
 */
strcmpi (str1, str2)
  char           *str1, *str2;
{
  char            chr1, chr2;
  /* #ifdef strcasecmp */
  return (strcasecmp (str1, str2));
  /*
   * #else for(;;) { chr1 = isupper(*str1) ? *str1 : toupper(*str1); chr2 =
   * isupper(*str2) ? *str2 : toupper(*str2); if (chr1 != chr2) return(chr2 -
   * chr1); if (chr1==0 || chr2==0) return(1); if (chr1==0 && chr2==0)
   * return(0); str1++; str2++; } return (0); #endif
   */
}

booleanDefault (def, preferred)
  char           *def;
  int             preferred;
{
  char           *str;

  str = getdefault (def);
  if (str == NULL)
    return (preferred);
  if (strcmpi (str, "on") == 0)
  {
    return (1);
  }
  else
  {
    return (0);
  }
}

intDefault (def, preferred)
  char           *def;
  int             preferred;
{
  char           *str;
  str = getdefault (def);
  if (!str)
    return preferred;
  return atoi (str);
}

/*
 * no default file given on command line. See if serverName is defined.  If
 * it exists we look for HOME/.xtrekrc-<serverName> and .xtrekrc-<serverName>
 * Otherwise we try DEFAULT_SERVER.
 */

/*
 * since this is Find Defaults, I moved all the defaults file checking to *
 * it, and put in support for a system defaults file. * and it uses the
 * access() system call to determine if a defaults *  file exists. * note,
 * access() returns 0 if user can read file, -1 on error or if * they can't. *
 * -EM *
 * 
 * Is anyone else bothered by the fact that this writes to deffile * without
 * really knowing how much of deffile is allocated? *
 * 
 */

findDefaults (home, deffile)
  char           *home, *deffile;
{
  int             accessible = -1;

  /* first look for server specific .xtrekrc in $HOME */
  if (serverName)
  {
    if (home)
      sprintf (deffile, "%s/.xtrekrc-%s", home, serverName);
    else
      sprintf (deffile, ".xtrekrc-%s", serverName);
    IFDEBUG (printf ("Looking for defaults file in %s\n", deffile);
    )
      accessible = access (deffile, R_OK);
    if (accessible == 0)
      return 1;
    /* else return 0; */
  }
  /* then try default server server-speciric defaults file in $HOME */
  if (home)
    sprintf (deffile, "%s/.xtrekrc-%s", home, DEFAULT_SERVER);
  else
    sprintf (deffile, ".xtrekrc-%s", DEFAULT_SERVER);
  IFDEBUG (printf ("Looking for defaults file in %s\n", deffile);
  )
    accessible = access (deffile, R_OK);
  if (accessible == 0)
    return 1;

  /* now try .xtrekrc in $HOME */
  if (home)
    sprintf (deffile, "%s/.xtrekrc", home);
  else
    sprintf (deffile, ".xtrekrc");
  IFDEBUG (printf ("Looking for defaults file in %s\n", deffile);
  )
    accessible = access (deffile, R_OK);
  if (accessible == 0)
    return 1;

  /* and of course, try for a .netrekrc  in $HOME, for the new generation */
  /* now try .xtrekrc in $HOME */
  if (home)
    sprintf (deffile, "%s/.netrekrc", home);
  else
    sprintf (deffile, ".netrekrc");
  IFDEBUG (printf ("Looking for defaults file in %s\n", deffile);
  )
    accessible = access (deffile, R_OK);
  if (accessible == 0)
    return 1;

#ifdef SYSTEM_DEFAULTFILE
  /* now try for a system default defaults file */
  sprintf (deffile, SYSTEM_DEFAULTFILE);
  IFDEBUG (printf ("Looking for defaults file in %s\n", deffile);
  )
    accessible = access (deffile, R_OK);
  if (accessible == 0)
    return 1;
#endif

  return 0;
}

#ifdef MOO
int
                defaultShip (preferred)
  int             preferred;
{
  char           *type;

  type = getdefault ("defaultShip");

#ifdef SHOW_DEFAULTS
  show_defaults ("string", "defaultShip", classes[preferred],
	  "Default ship to use on button-click entry (SC,DD,CA,BB,AS,SB).");
#endif

  if (type == NULL)
    return preferred;
  if ((strcmpi (type, "scout") == 0) || (strcmpi (type, "SC") == 0))
    return SCOUT;
  else if ((strcmpi (type, "destroyer") == 0) || (strcmpi (type, "DD") == 0))
    return DESTROYER;
  else if ((strcmpi (type, "cruiser") == 0) || (strcmpi (type, "CA") == 0))
    return CRUISER;
  else if ((strcmpi (type, "battleship") == 0) || (strcmpi (type, "BB") == 0))
    return BATTLESHIP;
  else if ((strcmpi (type, "assault") == 0) || (strcmpi (type, "AS") == 0))
    return ASSAULT;
  else if ((strcmpi (type, "starbase") == 0) || (strcmpi (type, "SB") == 0))
    return STARBASE;
  else
    return preferred;
}

#endif

#ifdef MAKE_XTREKRC
static char     defaults_filename[128];
static FILE    *fo;

set_defaults_filename (filename)
  char           *filename;
{
  if (filename)
    strncpy (defaults_filename, filename, 128);
}

comment_default (str)
  char           *str;
{
  char            buf[BUFSIZ];

  if (!showDefaults)
    return;

  if (!fo)
  {
    /* clear file */
    fo = fopen (defaults_filename, "w+");
    fclose (fo);
    fo = fopen (defaults_filename, "a+");

    if (!fo)
      return;
  }

  fprintf (fo, "%s\n", str);
}

show_defaults (category, name, value, desc)

  char           *category;
  char           *name;
  char           *value;
  char           *desc;
{
  char            buf[BUFSIZ];
  char            key[80], shortn[80];  /* *index () What the hell is this? */
  static char     olddesc[BUFSIZ], oldkey[80];
  register char  *s;

  if (!showDefaults)
    return;

  if (!fo)
  {
    /* clear file */
    fo = fopen (defaults_filename, "w+");
    fclose (fo);
    fo = fopen (defaults_filename, "a+");

    if (!fo)
      return;
  }

  strcpy (shortn, name);
  if (strncmp (name, "color", 5) == 0 || (strncmp (category, "windows", 7) == 0))
  {
    if ((s = index (shortn, '.')))
      *s = 0;
  }
  sprintf (key, "#(%s-%s) ", category, shortn);

  s = desc;
  if (strcmp (category, "windows") != 0)
  {
    if (strcmp (desc, olddesc) != 0)
    {
      fprintf (fo, "%s ", key);
      while (*s)
      {
	while (*s && *s != '\n')
	{
	  putc (*s, fo);
	  s++;
	}
	if (*s == '\n')
	  fprintf (fo, "\n", key);
	if (*s)
	  s++;
      }
      fprintf (fo, "\n");
    }
  }
  else if (strcmp (key, oldkey) != 0)
  {
    fprintf (fo, "%s\n", key);
  }
  sprintf (buf, "%s:", name);
  fprintf (fo, "%-32s %s\n", buf, value);
  strcpy (olddesc, desc);
  strcpy (oldkey, key);
}

finish_defaults ()
{
  if (!showDefaults)
    return;

  fclose (fo);
  fprintf (stderr, "Finished making %s defaults file\n", defaults_filename);
}

#endif
