/*
 * getship.c for client of socket protocol.
 * 
 * This file has been mangled so it only sets the ship characteristics needed.
 */
#include "copyright.h"

#include <stdio.h>
#include <sys/types.h>
#include "Wlib.h"
#include "defs.h"
#include "struct.h"
#include "data.h"

/* fill in ship characteristics */

getship(shipp, s_type)
    struct ship    *shipp;
    int             s_type;
{
   switch (s_type) {
   case SCOUT:
      shipp->s_type = SCOUT;
      shipp->s_torpspeed = 16;
      shipp->s_phaserdamage = 75;
      shipp->s_maxspeed = 12;
      shipp->s_maxfuel = 5000;
      shipp->s_maxarmies = 2;
      shipp->s_maxshield = 75;
      shipp->s_maxdamage = 75;
      shipp->s_maxwpntemp = 1000;
      shipp->s_maxegntemp = 1000;
      shipp->s_width = 20;
      shipp->s_height = 20;
      break;
   case DESTROYER:
      shipp->s_type = DESTROYER;
      shipp->s_torpspeed = 14;
      shipp->s_phaserdamage = 85;
      shipp->s_maxspeed = 10;
      shipp->s_maxfuel = 7000;
      shipp->s_maxarmies = 5;
      shipp->s_maxshield = 85;
      shipp->s_maxdamage = 85;
      shipp->s_maxwpntemp = 1000;
      shipp->s_maxegntemp = 1000;
      shipp->s_width = 20;
      shipp->s_height = 20;
      break;
   case BATTLESHIP:
      shipp->s_type = BATTLESHIP;
      shipp->s_torpspeed = 12;
      shipp->s_phaserdamage = 105;
      shipp->s_maxspeed = 8;
      shipp->s_maxfuel = 14000;
      shipp->s_maxarmies = 6;
      shipp->s_maxshield = 130;
      shipp->s_maxdamage = 130;
      shipp->s_maxwpntemp = 1000;
      shipp->s_maxegntemp = 1000;
      shipp->s_width = 20;
      shipp->s_height = 20;
      break;
   case ASSAULT:
      shipp->s_type = ASSAULT;
      shipp->s_torpspeed = 16;
      shipp->s_phaserdamage = 80;
      shipp->s_maxspeed = 8;
      shipp->s_maxfuel = 6000;
      shipp->s_maxarmies = 20;
      shipp->s_maxshield = 80;
      shipp->s_maxdamage = 200;
      shipp->s_maxwpntemp = 1000;
      shipp->s_maxegntemp = 1200;
      shipp->s_width = 20;
      shipp->s_height = 20;
      break;
   case STARBASE:
      shipp->s_type = STARBASE;
      shipp->s_torpspeed = 14;
      shipp->s_phaserdamage = 120;
      shipp->s_maxspeed = 2;
      shipp->s_maxfuel = 60000;
      shipp->s_maxarmies = 25;
      shipp->s_maxshield = 500;
      shipp->s_maxdamage = 600;
      shipp->s_maxwpntemp = 1300;
      shipp->s_maxegntemp = 1000;
      shipp->s_width = 20;
      shipp->s_height = 20;
      break;
#ifdef GALAXY
   case SGALAXY:
      shipp->s_type = SGALAXY;
      shipp->s_torpspeed = 13;
      shipp->s_phaserdamage = 100;
      shipp->s_maxspeed = 9;
      shipp->s_maxfuel = 12000;
      shipp->s_maxarmies = 12;
      shipp->s_maxshield = 140;
      shipp->s_maxdamage = 120;
      shipp->s_maxwpntemp = 1000;
      shipp->s_maxegntemp = 1000;
      shipp->s_width = 20;
      shipp->s_height = 20;
      break;
#endif				/* GALAXY */
   case ATT:
      shipp->s_type = ATT;
      shipp->s_torpspeed = 30;
      shipp->s_phaserdamage = 10000;
      shipp->s_maxspeed = 60;
      shipp->s_maxfuel = 60000;
      shipp->s_maxarmies = 1000;
      shipp->s_maxshield = 30000;
      shipp->s_maxdamage = 30000;
      shipp->s_maxwpntemp = 10000;
      shipp->s_maxegntemp = 10000;
      shipp->s_width = 20;
      shipp->s_height = 20;
      break;
   case CRUISER:
   default:
      shipp->s_type = CRUISER;
      shipp->s_torpspeed = 12;
      shipp->s_phaserdamage = 100;
      shipp->s_maxspeed = 9;
      shipp->s_maxfuel = 10000;
      shipp->s_maxarmies = 10;
      shipp->s_maxshield = 100;
      shipp->s_maxdamage = 100;
      shipp->s_maxwpntemp = 1000;
      shipp->s_maxegntemp = 1000;
      shipp->s_width = 20;
      shipp->s_height = 20;
      break;
   }
}
