#ifdef FEATURE
/*
 * macrowin.c from helpwin.c
 * copyright 1993 Nick Trown
 * copyright 1991 ERic mehlhaff
 * Free to use, hack, etc. Just keep these credits here.
 * Use of this code may be dangerous to your health and/or system.
 * Its use is at your own risk.
 * I assume no responsibility for damages, real, potential, or imagined,
 * resulting  from the use of it.
 * Yeah.....what Eric said...
 */

#include <stdio.h>
#include "math.h"
#include <signal.h>
#include <sys/types.h>
#ifdef hpux
#include <time.h>
#else	/* hpux */
#include <sys/time.h>
#endif	/* hpux */
#include "Wlib.h"
#include "defs.h"
#include "struct.h"
#include "data.h"
#ifdef Solaris
#include <string.h>
#else
#include <strings.h>
#endif


/*
	Fills in macro window with the macros defined in the .xtrekrc.
*/

#define MAXMACRO 70
/* maximum length in characters of key explanation */

#define MACROLEN 255
/* length of construction string since we don't know how long a macro can be */

showMacroWin()
{
   if(!macroWin){
      macroWin = W_MakeTextWindow("macro",WINSIDE,-BORDER,80,macrocnt+3, NULL, 
        			  BORDER);
      W_MapWindow(macroWin);
   }
   else if(W_IsMapped(macroWin))
      W_UnmapWindow(macroWin);
   else
      W_MapWindow(macroWin);
}

void 
fillmacro()
{
   register int                    row, i;
   char                            macromessage[MACROLEN];

   sprintf(macromessage, "Packages active:  NBT%s%s%s",
	   (F_UseNewMacro ? ", NEWMACRO" : ""),
	   (F_UseSmartMacro ? ", SMARTMACRO" : ""),
	   (F_gen_distress ? ", RC_DISTRESS" : ""));

   W_WriteText(macroWin, 2, 1, textColor,
       macromessage, strlen(macromessage), W_RegularFont);

   /* 4 column macro window. This may be changed depending on font size */
   for (row = 2, i = 0; i < macrocnt; row++, i++) {
      sprintf(macromessage, "%c ", macro[i].key);
      if (macro[i].type == NEWMMOUSE) {
	 switch (macro[i].who) {
	 case MACRO_PLAYER:
	    strcat(macromessage, " PL MS ");
	    break;
	 case MACRO_TEAM:
	    strcat(macromessage, " TM MS ");
	    break;
	 default:
	    strcat(macromessage, " SELF  ");
	    break;
	 }
      } else {
	 switch (macro[i].who) {
	 case 't':
	 case 'T':
	    strcat(macromessage, " TEAM  ");
	    break;
	 case 'A':
	    strcat(macromessage, " ALL   ");
	    break;
	 case 'F':
	    strcat(macromessage, " FED   ");
	    break;
	 case 'R':
	    strcat(macromessage, " ROM   ");
	    break;
	 case 'K':
	    strcat(macromessage, " KLI   ");
	    break;
	 case 'O':
	    strcat(macromessage, " ORI   ");
	    break;
	 case '\0':
	    strcat(macromessage, " SPEC  ");
	    break;
	 default:
	    strcat(macromessage, " ----  ");
	    break;
	 }
      }
      strcat(macromessage, macro[i].string);
      macromessage[MAXMACRO] = '\0';
      W_WriteText(macroWin, 2, row, textColor,
       macromessage, strlen(macromessage), W_RegularFont);
   }
}
#endif
