
/*
 * playerlist.c
 *
 *   Fairly substantial re-write to do variable player lists: Sept 93 DRG
 */
#include "copyright.h"

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "Wlib.h"
#include "defs.h"
#include "struct.h"
#include "data.h"

static char *my_classes[NUM_TYPES + 1] =
{
  "SC", "DD", "CA", "BB", "AS", "SB", "GA", "??"
};

static char header[BUFSIZ];
int header_len;
int old_newPlist=-1, change=0;

/*===========================================================================*/

int playerlistnum()
{
  int num=0;
  char *ptr;

  if (change) 
    {
      plist[0]='\0';

      if (newPlist) 
        {
          if (getdefault("playerlist")) {
            strcpy(plist, getdefault("playerlist"));
          } else {
            strcpy(plist, "nTR N  K lrSd");
        }
        }
      else {
        strcpy(plist,"nTRNKWLr O D d ");
      }

      change = 0;
    }
  else 
  {
#ifdef PLIST
     if (!no_init_plist) 
       {
         if (getdefault ("playerlist") == NULL) 
           {
#endif
             if (newPlist) 
               strcpy(plist,"nTR N  K lrSd");
             else {
               strcpy(plist,"nTRNKWLr O D d ");
	     }
#ifdef PLIST
           }
         else
           strcpy(plist, getdefault ("playerlist"));
       }
#endif
  }

  old_newPlist = newPlist;


  ptr=plist; header[0] = '\0';
  while (ptr[0] != '\0') {
     switch (ptr[0]) {
        case 'n':   /* Ship Number */
           strcat(header," No"); 
           num+=3;
           break;
        case 'T':   /* Ship Type */
           strcat(header," Ty"); 
           num+=3;
           break;
        case 'R':   /* Rank */
           strcat(header," Rank      "); 
           num+=11;
           break;
        case 'N':   /* Name */
           strcat(header," Name            "); 
           num+=17;
           break;
        case 'K':   /* Kills */
           strcat(header," Kills"); 
           num+=6;
           break;
        case 'l':   /* Login Name */
           strcat(header," Login           "); 
           num+=17;
           break;
        case 'O':   /* Offense */
           strcat(header," Offse"); 
           num+=6;
           break;
        case 'W':   /* Wins */
           strcat(header,"  Wins"); 
           num+=6;
           break;
        case 'D':   /* Defense */
           strcat(header," Defse"); 
           num+=6;
           break;
        case 'L':   /* Losses */
           strcat(header,"  Loss"); 
           num+=6;
           break;
        case 'S':   /* Total Rating (stats) */
           strcat(header," Stats"); 
           num+=6;
           break;
        case 'r':   /* Ratio */
           strcat(header," Ratio"); 
           num+=6;
           break;
        case 'd':   /* Damage Inflicted (DI) */
           strcat(header,"      DI"); 
           num+=8;
           break;
        case ' ':   /* White Space */
           strcat(header," "); 
           num+=1;
           break;
#ifdef PLIST1
        case 'B':   /* Bombing */
           strcat(header," Bmbng"); 
           num+=6;
           break;
        case 'b':   /* Armies Bombed */
           strcat(header," Bmbed"); 
           num+=6;
           break;
        case 'P':   /* Planets */
           strcat(header," Plnts"); 
           num+=6;
           break;
        case 'p':   /* Planets Taken */
           strcat(header," Plnts"); 
           num+=6;
           break;
        case 'M':   /* Display, Host Machine */
           strcat(header," Host Machine    "); 
           num+=17;
           break;
        case 'H':   /* Hours Played */
           strcat(header," Hours "); 
           num+=7;
           break;
        case 'k':   /* Max Kills */
           strcat(header," Max K"); 
           num+=6;
           break;
#ifdef SBHOURS
        case 'V':               /* Kills per hour */
          strcat (header, "   KPH");
          num += 6;
          break;
        case 'v':               /* Deaths per hour */
          strcat (header, "   DPH");
          num += 6;
          break;
#endif
#endif
#ifdef PLIST2
        case 'w':   /* War staus */
           strcat(header," War Stat"); 
           num+=9;
           break;
        case 's':   /* Speed */
           strcat(header," Sp"); 
           num+=3;
           break;
#endif
	default:
           fprintf(stderr,"%c is not an option for the playerlist\n",ptr[0]);
           break;
     }
     ptr++; 
  }
  header_len=num;
  return(num);
}

/*===========================================================================*/

redraw_playerlist_header ()
{
  W_WriteText (playerw, 0, 1, textColor, header, header_len, W_BoldFont);
}

playerlist ()
{
  int i;

  if (old_newPlist != newPlist) { change=1; playerlistnum();}

  W_ClearWindow (playerw);

  W_WriteText (playerw, 0, 1, textColor, header, header_len, W_BoldFont);

  for (i = 0; i < MAXPLAYER; i++)
    {
      updatePlayer[i] = 1;
    }

  playerlist2 ();
}

/*===========================================================================*/

plist_line (j, pos)
     struct player *j;
     int pos;
{
  char buf[BUFSIZ];
  char *ptr;
  char tmp[30];
  int kills,losses,my_ticks;
  float pRating,oRating,dRating,bRating,Ratings;
  double ratio,max_kills;
#ifdef SBHOURS
  float KillsPerHour, LossesPerHour;  /* Added 12/27/93 ATH */
#endif

  if (j->p_ship.s_type == STARBASE)
    {
      kills = j->p_stats.st_sbkills;
      losses = j->p_stats.st_sblosses;
      max_kills = j->p_stats.st_sbmaxkills;
#ifdef SBHOURS
      if (SBhours)
      {
	my_ticks = j->p_stats.st_sbticks;
      }
      else
      {
	my_ticks = j->p_stats.st_tticks;
      }
      
      KillsPerHour = (float) (my_ticks==0) ? 0.0 : 
        (float) kills * 36000.0 / (float) my_ticks;
      LossesPerHour = (float) (my_ticks==0) ? 0.0 : 
        (float) losses * 36000.0 / (float) my_ticks;
#else
      my_ticks = j->p_stats.st_sbticks;
#endif
    }
  else
    {
      kills = j->p_stats.st_kills + j->p_stats.st_tkills;
      losses = j->p_stats.st_losses + j->p_stats.st_tlosses;
      max_kills = j->p_stats.st_maxkills;
      my_ticks = j->p_stats.st_tticks;
#ifdef SBHOURS
      KillsPerHour = (float) (my_ticks==0) ? 0.0 : 
        (float) j->p_stats.st_tkills * 36000.0 / (float) my_ticks;
      LossesPerHour = (float) (my_ticks==0) ? 0.0 : 
        (float) j->p_stats.st_tlosses * 36000.0 / (float) my_ticks;
#endif
    }

  if (losses == 0)
    {
      ratio = (double) kills;
    }
  else
    {
      ratio = (double) kills / (double) losses;
    }

  if (!j->p_stats.st_tticks)
    {
      oRating = pRating = bRating = Ratings = 0.0;
      dRating = defenseRating (j);
    }
  else
    {
      oRating = offenseRating (j);
      pRating = planetRating (j);
      bRating = bombingRating (j);
      Ratings = oRating + pRating + bRating;
      dRating = defenseRating (j);
#ifdef SHOURS
      if ((j->p_ship.s_type == STARBASE) && (SBhours)) 
        {             /* If SB, show KPH for offense etc. */
          oRating = KillsPerHour;
          dRating = LossesPerHour;
        }
#endif
    }

  ptr=plist; buf[0] = '\0';
  while (ptr[0] != '\0') {
     tmp[0]='\0';     
     switch (ptr[0]) {
        case 'n':   /* Ship Number */
           if (j->p_status != PALIVE) 
             {
               tmp [0] = ' ';
               tmp [1] = ' ';
               tmp [2] = shipnos[j->p_no];
               tmp [3] = '\0';
             }
           else  
             {
               tmp [0] = ' ';
               tmp [1] = teamlet[j->p_team];
               tmp [2] = shipnos[j->p_no];
               tmp [3] = '\0';
             }
           strcat(buf,tmp); 
           break;
        case 'T':   /* Ship Type */
           if (j->p_status != PALIVE) 
             {
               tmp [0] = ' ';
               tmp [1] = ' ';
               tmp [2] = ' ';
               tmp [3] = '\0';
             }
           else  
             {
               tmp [0] = ' ';
               tmp [1] = my_classes[j->p_ship.s_type] [0];
               tmp [2] = my_classes[j->p_ship.s_type] [1];
               tmp [3] = '\0';
             }
           strcat(buf,tmp); 
           break;
        case 'R':   /* Rank */
	   tmp [0] = ' ';
           format (&(tmp [1]), ranks [j->p_stats.st_rank].name, 10, 0);
           strcat(buf,tmp); 
           break;
        case 'N':   /* Name */
	   tmp [0] = ' ';
           format (&(tmp [1]), j->p_name, 16, 0);
           strcat(buf,tmp); 
           break;
        case 'K':   /* Kills */
	   tmp [0] = ' ';
           ftoa (j->p_kills, &(tmp [1]), 0, 2, 2);
           strcat(buf,tmp); 
           break;
        case 'l':   /* Login Name */
	   tmp [0] = ' ';
           format (&(tmp [1]), j->p_login, 16, 0);
           strcat(buf,tmp); 
           break;
        case 'O':   /* Offense */
	   tmp [0] = ' ';
           ftoa (oRating, &(tmp [1]), 0, 2, 2);
           strcat(buf,tmp); 
           break;
        case 'W':   /* Wins */
	   tmp [0] = ' ';
           dectoa (kills, &(tmp [1]), 0, 5);
           strcat(buf,tmp); 
           break;
        case 'D':   /* Defense */
	   tmp [0] = ' ';
           ftoa (dRating, &(tmp [1]), 0, 2, 2);
           strcat(buf,tmp); 
           break;
        case 'L':   /* Losses */
	   tmp [0] = ' ';
           dectoa (losses, &(tmp [1]), 0, 5);
           strcat(buf,tmp); 
           break;
        case 'S':   /* Total Rating (stats) */
	   tmp [0] = ' ';
           ftoa (Ratings, &(tmp [1]), 0, 2, 2);
           strcat(buf,tmp); 
           break;
        case 'r':   /* Ratio */
	   tmp [0] = ' ';
           ftoa (ratio, &(tmp [1]), 0, 2, 2);
           strcat(buf,tmp); 
           break;
        case 'd':   /* Damage Inflicted (DI) */
	   tmp [0] = ' ';
           ftoa (Ratings*(j->p_stats.st_tticks/36000.0), &(tmp [1]), 0, 4, 2);
           strcat(buf,tmp); 
           break;
        case ' ':   /* White Space */
           strcat(buf," "); 
           break;
#ifdef PLIST1
        case 'B':   /* Bombing */
	   tmp [0] = ' ';
           ftoa (bRating, &(tmp [1]), 0, 2, 2);
           strcat(buf,tmp); 
           break;
        case 'b':   /* Armies Bombed */
	   tmp [0] = ' ';
           dectoa (j->p_stats.st_tarmsbomb+j->p_stats.st_armsbomb, &(tmp [1]), 0, 5);
           strcat(buf,tmp); 
           break;
        case 'P':   /* Planets */
	   tmp [0] = ' ';
           ftoa (pRating, &(tmp [1]), 0, 2, 2);
           strcat(buf,tmp); 
           break;
        case 'p':   /* Planets Taken */
	   tmp [0] = ' ';
           dectoa (j->p_stats.st_tplanets+j->p_stats.st_planets, &(tmp [1]), 0, 5);
           strcat(buf,tmp); 
           break;
        case 'M':   /* Display, Host Machine */
	   tmp [0] = ' ';
           format (&(tmp [1]), j->p_monitor, 16, 0);
           strcat(buf,tmp); 
           break;
        case 'H':   /* Hours Played */
	   tmp [0] = ' ';
           ftoa (my_ticks/36000.0, &(tmp [1]), 0, 3, 2);
           strcat(buf,tmp); 
           break;
        case 'k':   /* Max Kills  */
	   tmp [0] = ' ';
           ftoa (max_kills, &(tmp [1]), 0, 2, 2);
           strcat(buf,tmp); 
           break;
#ifdef SBHOURS
        case 'V':               /* Kills Per Hour  */
          tmp[0] = ' ';
          ftoa (KillsPerHour, &(tmp[1]), 0, 3, 1);
          strcat (buf, tmp);
          break;
        case 'v':               /* Deaths Per Hour  */
          tmp[0] = ' ';
          ftoa (LossesPerHour, &(tmp[1]), 0, 3, 1);
          strcat (buf, tmp);
          break;
#endif
#endif
#ifdef PLIST2
        case 'w':   /* War staus */
           if (j->p_swar & me->p_team) strcat(buf," WAR     ");
           else if (j->p_hostile & me->p_team) strcat(buf," HOSTILE "); 
                else strcat(buf," PEACEFUL");
           break;
        case 's':   /* Speed */
	   tmp [0] = ' ';
           dectoa (j->p_speed, &(tmp [1]), 0, 2);
           strcat(buf,tmp); 
           break;
#endif
	default:
           break;
     }
     ptr++; 
  }

   W_WriteText (playerw, 0, pos, playerColor (j), buf, strlen (buf), shipFont (j));

}

/*===========================================================================*/

Sorted_playerlist2 ()
{
  register int i, h, pos = 1, last, boolflag = 0;
  register struct player *j;
  static int num;

  if (++num % 21 == 0)
    {
      boolflag = 1;
      num = 0;
    }

  for (h = 0; h < NUMTEAM; h++)
    {
      if (me->p_team == (1 << h))
	continue;

      for (i = 0, j = &players[i]; i < MAXPLAYER; i++, j++)
	{
	  if (j->p_team != (1 << h))
	    continue;

	  pos++;

	  if ((!plshowstatus && j->p_status != PALIVE) || j->p_status == PFREE)
	    {
	      W_ClearArea (playerw, 0, pos, header_len, 1);
	      continue;
	    }

	  if (!updatePlayer[i] && (!boolflag))
	    continue;

	  updatePlayer[i] = 0;
	  plist_line (j, pos);
	}
    }

  for (i = 0, j = &players[i]; i < MAXPLAYER; i++, j++)
    {
      if (j->p_team != me->p_team)
	continue;

      pos++;

      if ((!plshowstatus && j->p_status != PALIVE) || j->p_status == PFREE)
	{
	  W_ClearArea (playerw, 0, pos, header_len, 1);
	  continue;
	}

      if (!updatePlayer[i] && (!boolflag))
	continue;

      updatePlayer[i] = 0;
      plist_line (j, pos);
    }

  last = MAXPLAYER + 2;

  for (i = MAXPLAYER - 1, j = &players[i]; i >= 0; i--, j--)
    {
      if (j->p_team != NOBODY)
	continue;

      if (j->p_status == PFREE)
	continue;

      if ((!plshowstatus && j->p_status != PALIVE) || j->p_status == PFREE)
	continue;

      last--;

      if (!updatePlayer[i] && (!boolflag))
	continue;

      updatePlayer[i] = 0;
      plist_line (j, last);
    }

  if (boolflag && (last > (pos + 1)))
    W_ClearArea (playerw, 0, pos + 1, header_len, last - (pos + 1));
}

/*===========================================================================*/

playerlist2 ()
{
  register int i;
  char buf[BUFSIZ];
  char killstring[32];
  register struct player *j;
  int kills, losses;
  double ratio;
  float pRating, oRating, dRating, bRating, Ratings;

  if (!W_IsMapped (playerw))
    return;

  if (sortPlayers)
    {
      Sorted_playerlist2 ();
      return;
    }

  for (i = 0, j = &players[i]; i < MAXPLAYER; i++, j++)
    {
      if (!updatePlayer[i])
	continue;

      updatePlayer[i] = 0;

      if ((!plshowstatus && j->p_status != PALIVE) || j->p_status == PFREE)
	{
	  W_ClearArea (playerw, 0, i + 2, header_len, 1);
	  continue;
	}

      plist_line(j,i+2);

    }
}


