/*
 * warning.c
 */
#include "copyright.h"

#include <stdio.h>
#include <math.h>
#include <signal.h>
#include "Wlib.h"
#include "defs.h"
#include "struct.h"
#include "data.h"

/*
 * * The warning in text will be printed in the warning window. * The message
 * will last WARNTIME/10 seconds unless another message * comes through and
 * overwrites it.
 */
warning (text)
     char *text;
{
#ifdef TIME_STAMP_ON_PHASER
  char timed_phaser [256];
#endif
  W_Window phaser;
  warntimer = udcounter + WARNTIME;	/* set the line to be cleared */
  
  if (warncount > 0)
  {
    /* XFIX */
    W_ClearArea (warnw, 5, 5, W_Textwidth * warncount, W_Textheight);
  }
  
  warncount = strlen(text);
  
  if (!recv_short && strncmp(text, "Phaser burst", 12)==0)
  {
    if (phaserWindow)
    {
#ifdef TIME_STAMP_ON_PHASER
      if (!tclock)
        update_timebuf ();

      strcpy (timed_phaser, text);
      strcat (timed_phaser, " ");
      strcat (timed_phaser, timebuf);

      W_WriteText(phaserwin, 0, 0, textColor, timed_phaser,
		  strlen(timed_phaser), W_RegularFont);
#else
      W_WriteText(phaserwin, 0, 0, textColor, text,
		  strlen(text), W_RegularFont);
#endif
      W_FlushScrollingWindow(phaserwin);
      return;
    }
    else
    {
#ifdef MOO
      switch (phas_msg)
      {
      case 1 :
	phaser = messwa;
	break;
      case 2 :
	phaser = messwt;
	break;
      case 3 :
	phaser = messwi;
	break;
      case 4 :
	phaser = messwk;
	break;
      case 5 :
	phaser = reviewWin;
	break;
      default :
	phaser = NULL;
/*	warning (text); */
	break;
      }
      
      if (phaser)
	W_WriteText(phaser, 0, 0, textColor, text, strlen(text),
		    W_RegularFont);
#endif
    }
  }
  
  W_WriteText(warnw, 5, 5, textColor, text, warncount, W_RegularFont);
}
