////////////////////////////////////////////////////////////////////////////////
//  Implementation of the global list.                                        //  
//  LAST EDIT: Fri Aug  5 08:55:28 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "glist.h"
#include "image.h"
#include "texture.h"
#include "camera.h"
#include "scene.h"
#include "primitiv.h"
#include "tclclass.h"
#include "attrobj.h"

#include "high/recorder.h"

extern "C" {
#include <stdlib.h>
}

void RT_GlobalList::specialRemove( const char *cname, RT_Object *o) {
    RT_GeneralListElem *tmp = root;
    if (!tmp) return;
    do 	if (tmp->elem->isA( cname ))
	if ( !strcmp( cname, RTN_SCENE )) ((RT_Scene*)tmp->elem)->remove( o );
    while(tmp = tmp->next);
}

void RT_GlobalList::print(FILE *f) const {
    RT_GeneralListElem *tmp = root;
    RT_Object *o;
    if (!tmp) return;
    fprintf( f, "#!/bin/sh\n#\\\nexec %s -file $0 $*\n", (char*)rt_YARTProgram );
    fprintf( f, "#################################################\n" );
    fprintf( f, "#  YART Object File. Automatically generated.   #\n" );
    fprintf( f, "#            Release %s                       #\n", 
	    RT_GOOD_RELEASE );
    fprintf( f, "#################################################\n" );

    // the globals:
    fprintf( f, "set rt_RayDebug %i\n", rt_RayDebug );
    fprintf( f, "set rt_PickDebug %i\n", rt_PickDebug );
    fprintf( f, "set rt_RefractedShadows %i\n", rt_RefractedShadows );
    fprintf( f, "set rt_YARTProgram {%s}\n", (char*)rt_YARTProgram );

    // save the Tcl composite class descriptions:
    RT_TclObject::classes.print( f );
    fprintf( f, "##### Attributes #####\n" );
    RT_AttributeObject::print( f );
    fprintf( f, "\n##### Images and Textures #####\n" );
    tmp = root;
    do {
	o = (RT_Object*)tmp->elem;
	if (o->isA( RTN_IMAGE) || o->isA( RTN_TEXTURE_3D )) o->print( f );
    }
    while (tmp = tmp->next);
    fprintf( f, "##### Mappings #####\n" );
    tmp = root;
    do {
	o = (RT_Object*)tmp->elem;
	if (o->isA( RTN_MAPPING )) o->print( f );
    }
    while (tmp = tmp->next);
    fprintf( f, "##### Objects #####\n" );

    // save all objects without scenes and cameras and some others:
    tmp = root;
    do {
	o = (RT_Object*)tmp->elem;
	if (o->isA( RTN_SCENE )) continue;
	if (o->isA( RTN_CAMERA )) continue;
	if (o->isA( RTN_IMAGE )) continue;
	if (o->isA( RTN_TEXTURE_3D )) continue;
	if (o->isA( RTN_MAPPING )) continue;
	if (o->isA( RTN_RECORDER )) continue;
	if (o->isA( RTN_PRIMITIVE )) {
	    if (!((RT_Primitive*)o)->get_father())
		// if primitive has father - dont save it!
		// father will save it
		((RT_Primitive*)o)->printHierarchical( f );
	}
	else o->print( f );
    }
    while (tmp = tmp->next);
    tmp = root;

    // save the scenes:
    fprintf( f, "##### Scenes #####\n" );
    do  {
	o = (RT_Object*)tmp->elem;
	if (o->isA( RTN_SCENE )) o->print( f );
    }
    while (tmp = tmp->next);
    tmp = root;

    // save the cameras:
    fprintf( f, "##### Cameras #####\n" );
    do  {
	o = (RT_Object*)tmp->elem;
	if (o->isA( RTN_CAMERA )) o->print( f );
    }
    while (tmp = tmp->next);
    tmp = root;

    // save the recorders:
    fprintf( f, "##### Recorders #####\n" );
    do  {
	o = (RT_Object*)tmp->elem;
	if (o->isA( RTN_RECORDER )) o->print( f );
    }
    while (tmp = tmp->next);
}

void RT_GlobalList::removeAll() {
    // remove NON-scenes:
    RT_GeneralListElem *tmp = root;
    if (!tmp) return;
    do if ( !(tmp->elem)->isA( RTN_SCENE )) {
	delete tmp->elem;
	// object clears itself from list 
	tmp->elem = 0;
    }
    while (tmp = tmp->next); 
    tmp = root;
    if (!tmp) return;
    // delete all Scenes:
    do if (tmp->elem) delete tmp->elem;
    while(tmp = tmp->next); 
}
