////////////////////////////////////////////////////////////////////////////////
//  definition of an internal BSpline utility class                           //  
//  LAST EDIT: Fri Feb 10 15:24:31 1995 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1993 - 1995 YART team                                        //
////////////////////////////////////////////////////////////////////////////////

#ifndef __BSPLINE_H__
#define __BSPLINE_H__                                              

#include "genmatrix.h"
#include "genvector.h"

typedef enum _SplineMode {
    _OPEN = 0, // default
    _CLOSED
};

class _bspline {
  private:
    // array's dimensions:
    static int parVecDim, matRow, matCol, knotVecDim, err;
    // set of values, describing a b-spline:
    int numVal, order, dim;
    _SplineMode mode;

    // matrix of base function values,
    // actual base functions values for a given parameter (stored
    // in the dim-dimensional vector T), 
    // are determined by the column-index like that( k = order ):
    //
    // for a open uniform b-spline (RTE_OPEN) :
    //      c
    //   r 00      01     02        0n
    //   N(0,k)  N(1,k) N(2,k)..N(numVal,k)  
    //     10      11     12        1n
    //   N(0,k)  N(1,k)..       N(numVal,k)
    //       
    //    dim,0  dim,1            dim,n
    //   N(0,k)  N(0,k)..       N(numVal,k)
    //   ..so the dimension of the matrix must be (rows/columns): dim, numVal
    // 
    // for a closed b-spline:
    //       00     01     02               0n
    //     N(0,k) N(1,k) N(2,k)....   N(numVal+k-1, k)   
    //      
    //   ..the dimension of the matrix
    //   must be (rows/columns): dim, (numVal+k-1) 
    ////////////////

    _Matrix N;
    _Vector T;
    _Vector knotV;

    double tLimit;
    // intern updating methods and flags:
    int splChanged;
    void computeKnotVector();
    void createMatrix();

    // "dangerous" methods:
    void setLimits();
    int checkValues();
    double blend( int, int, double );
  public:
    _bspline( int, int, int, _SplineMode );
    _bspline();

    ~_bspline();
    
    // interface to a math. spline:
    
    void setNum(int val) {
	numVal = val;
	splChanged = 1;
    }

    void setDim(int val) {
	dim = val;
	splChanged = 1;
    }
    
    void setMod(_SplineMode val) {
	mode = val;
	splChanged = 1;
    }
    
    void setOrd(int val) {
	order = val;
	splChanged = 1;
    }
    
    int getOrd() const { return order; }
    int getDim() const { return dim; }
    int getMod() const { return mode; }
    int getNum() const { return numVal; }

    const _Matrix getBase() const;
    const _Vector getParVector() const;

    int update();
};

#endif

