#ifndef __QUADRIC_H__
#define __QUADRIC_H__

////////////////////////////////////////////////////////////////////////////////
//  Ray-tracing primitive Quadric.                                            //  
//  LAST EDIT: Fri Aug  5 08:54:59 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "primitiv.h"

///// the class QUADRIC

extern const char *RTN_QUADRIC;

class RT_Quadric: public RT_Primitive {
friend class RT_Sphere; // cos it needs access to setConst()
    RT_Matrix qmat;
    void quadric2Matrix();
  protected:
    RT_Vector qu2Terms, quMixedTerms, quTerms;
    double quConstant;

    // set the coefficients:
    void set2Terms(RT_Vector v) { qu2Terms = v; quadric2Matrix(); }
    void setMixedTerms(RT_Vector v) { quMixedTerms = v; quadric2Matrix(); }
    void setTerms(RT_Vector v) { quTerms = v; quadric2Matrix(); }
    void setConst(double d) { quConstant = d; quadric2Matrix(); }
  public:
    //##### Tcl/C++ methdos:
    RT_Quadric( char *_name, const RT_Vector &a, const RT_Vector &b, 
	       const RT_Vector &c, double d): RT_Primitive(_name) {
		   qu2Terms = a; quMixedTerms = b; quTerms = c; quConstant = d;
		   quadric2Matrix();
	       }
    
    void printCon( FILE *f) const {
	RT_Object::printCon( f);
	qu2Terms.print( f); quMixedTerms.print( f); quTerms.print( f);
	fprintf( f, "%lf ", quConstant);
    }

    RT_Bounds get_bounds() {
	RT_Bounds b;
	b.max.x = b.max.y = b.max.z = rt_UndefinedBounds;
	b.min.x = b.min.y = b.min.z = -rt_UndefinedBounds;
	return b;
    } 

    const char *get_description() const { return "A parameterizable quadric."; }
    const char *get_class() const { return RTN_QUADRIC; }
    int isA(const char *c) const { return RT_Primitive::isA( c ) || RTM_isA( c, RTN_QUADRIC ); }

    //#### ray-tracer interface:
    int intersect(const RT_Ray&, RT_InterSectionList&); 
    void normal(const RT_Vector&, RT_Vector &);

    //#### the Tcl commands:
    static int classCMD(ClientData, Tcl_Interp *, int, char *[]);
    int objectCMD(char *argv[]) { return RT_Primitive::objectCMD( argv); } 
};

#endif
