//  LAST EDIT: Fri Feb 11 04:01:35 1994 by ekki(@prakinf.tu-ilmenau.de)
#include "fhard.h"

/* Grafik einschalten, liefert true, wenn erfolgreich */
int G_On(RT_Pixmap *_bitmap)
{ 
  bitmap = _bitmap; 
  return (true);
}

/* Standard-VGA Mode (Text) aktivieren und evtl. alte Palette
   wieder einstellen */
void G_Off(void)
{
}

/* setzt ein Pixel mit den Koordinaten x, y mit der Farbe r,g,b
   in Abhaengigkeit von ColorTyp */
void RGB_Dot(int x, int y, int r, int g, int b)
{
  if ((x < bitmap->getW()) && (y <  bitmap->getH())) 
      bitmap->putPixel(x , bitmap->getH()-y-1, RT_Color(r/255.0,g/255.0,b/255.0));
}

/* Linie von x1,y1 nach x2,y2 (mit Farbe r,g,b
   in Abhaengigkeit von ColorTyp) zeichnen */
void RGB_Line(int x1, int y1, int x2, int y2, int r, int g, int b)
{
  float dyDdx, dxDdy, sy, sx;
  int dy, dx, h;

  dy = (int)fabs(y2 - y1);
  dx = (int)fabs(x2 - x1);
  if (dx > dy) {
    if (x2 < x1) {
      h = x1;
      x1 = x2;
      x2 = h;
      h = y1;
      y1 = y2;
      y2 = h;
    }
    RGB_Dot(x1, y1, r, g, b);
    if (dx == 0)
      return;
    sy = y1 + 0.5;
    dyDdx = y2 - y1;
    dyDdx /= dx;
    while (x1 < x2 - 1) {
      x1++;
      sy += dyDdx;
      RGB_Dot(x1, (int)floor(sy), r, g, b);
    }
    RGB_Dot(x2, y2, r, g, b);
    return;
  }
  if (y2 < y1) {
    h = x1;
    x1 = x2;
    x2 = h;
    h = y1;
    y1 = y2;
    y2 = h;
  }
  RGB_Dot(x1, y1, r, g, b);
  if (dy == 0)
    return;
  sx = x1 + 0.5;
  dxDdy = x2 - x1;
  dxDdy /= dy;
  while (y1 < y2 - 1) {
    y1++;
    sx += dxDdy;
    RGB_Dot((int)floor(sx), y1, r, g, b);
  }
  RGB_Dot(x2, y2, r, g, b);
}
