////////////////////////////////////////////////////////////////////////////////
// YART interface to Tk and OpenGL 1.0                                        //  
// LAST EDIT: Wed Mar  8 16:28:03 1995 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1993 - 1995 YART team                                        //
////////////////////////////////////////////////////////////////////////////////

#define TK

#include <yart.h>

extern "C" {
#include <GL/glx.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include "tk.h"
#include "X11/Xlib.h"
#include "X11/Xutil.h"
#include <assert.h>
}

#include <unistd.h>

Tk_Window rt_TkWin;

// the first pixmap will create a new graphics context
// all other will link this

static GLXContext globalContext = 0;

class RT_PixmapDisplayData {
    int changed;
  public:
    RT_PixmapDisplayData(RT_PixmapDisplay *_px, char *_name);
    ~RT_PixmapDisplayData();
    GLenum type;
    Display *display;
    Tk_Window tkwin;
    Window window;
    int screen;
    XVisualInfo *visualInfo;
    Colormap cmap;
    GLXContext context;
    RT_PixmapDisplay *px;
    int result, left, middle, right, mapped, enter, del; 
    static void reset_win(ClientData);
    void eventProc(XEvent*);
    static void staticEventProc(ClientData, XEvent*);
    void configure();
    void reconfigure();

    void setChanged() { changed = 1; }
    void setUnChanged () { changed = 0; }
    isChanged() const { return changed; }
    void geometry(int _w, int _h) {
	if (px->w!=_w || px->h!=_h) setChanged();
	px->w = _w; px->h = _h;
    }
};

RT_PixmapDisplayData::RT_PixmapDisplayData(RT_PixmapDisplay *_px, char *_name) {
    int erb, evb; 
    setChanged();
    // config for doublebuffer mode
    int configuration_db[] = {
	GLX_RGBA,
	GLX_RED_SIZE, 1,
        GLX_GREEN_SIZE, 1,
        GLX_BLUE_SIZE, 1,
        GLX_DOUBLEBUFFER,
        GLX_DEPTH_SIZE, 1,
        None,
    };
    // config for singlebuffer mode
    int configuration_sb[] = {
        GLX_DEPTH_SIZE, 1,
        None,
    };

    cmap = NULL;
    window = NULL;
    display = NULL;
    context = NULL;
    mapped = result = NULL;
    
    if((tkwin=Tk_CreateWindowFromPath(rt_Ip, rt_TkWin, _name, (char *) NULL))==NULL) {
	result=TCL_ERROR;
	return;
    }
    Tk_SetClass(tkwin, "TkPixmap");
    px = _px;
    geometry(Tk_Width(tkwin), Tk_Height(tkwin));
    display=Tk_Display(tkwin);
    if (!glXQueryExtension(display, &erb, &evb))
	rt_Output->fatal ("X server has no OpenGL GLX extension !");
    px->sglBuf=0;
    // try to initialize doublebuffer mode 
    // if this fails use singelbuffer 
    if ((visualInfo=glXChooseVisual(Tk_Display(tkwin), Tk_ScreenNumber(tkwin), configuration_db))==NULL) {
	px->sglBuf=1;
	if ((visualInfo=glXChooseVisual(Tk_Display(tkwin), Tk_ScreenNumber(tkwin), configuration_sb))==NULL) 
	    rt_Output->fatal ("no appropriate RGB visual with depth buffer");
    }
    cmap=XCreateColormap(Tk_Display(tkwin), RootWindow(Tk_Display(tkwin), Tk_ScreenNumber(tkwin)), visualInfo->visual, AllocNone);
    if (Tk_SetWindowVisual(tkwin ,visualInfo->visual, visualInfo->depth, cmap)==0) 
	rt_Output->fatal ("can`t set Tk_Window visual !");
    if((context= glXCreateContext(Tk_Display(tkwin), visualInfo, globalContext, GL_TRUE))==NULL) 
	rt_Output->fatal ("Can't create a context !"); 
    if (!globalContext)	globalContext=context;
    Tk_CreateEventHandler(tkwin, ButtonPressMask| ButtonReleaseMask| PointerMotionMask| ButtonMotionMask| StructureNotifyMask | ExposureMask | EnterWindowMask | LeaveWindowMask , RT_PixmapDisplayData::staticEventProc, (ClientData)this);
    del = 0;
}

RT_PixmapDisplayData::~RT_PixmapDisplayData() {
    Tk_DestroyWindow( tkwin );
    if (display) {
	if (cmap) XFreeColormap(display, cmap);
	if (visualInfo) XFree(visualInfo);
    }
}

void RT_PixmapDisplayData::reset_win( ClientData cd ) {
    if (!cd) return;
    RT_PixmapDisplayData *d = (RT_PixmapDisplayData*)cd;
    d->px->activate();
    if(d->isChanged()) {
	glViewport(0, 0,(GLsizei)d->px->w, (GLsizei)d->px->h);
	d->setUnChanged();
    }
    if (d->px->xcamera) d->px->xcamera->refresh(); 
}

void RT_PixmapDisplayData::eventProc(XEvent *eventPtr) {
    switch (eventPtr->type) {
      case DestroyNotify:
	if (!del) delete px;			
	px = NULL;
	break;
      case Expose:
	if (eventPtr->xexpose.count ==0) 
	    // Reset the viewport in the pixmap:
	    Tk_DoWhenIdle( RT_PixmapDisplayData::reset_win,(ClientData)this);
	break;
      case EnterNotify:
	enter = 1;
	break;
      case LeaveNotify:
	enter = 0;
	break;
      case ButtonPress: {
	  XButtonEvent *evb = (XButtonEvent *)eventPtr;
	  RT_ButtonEvent *pev = new RT_ButtonEvent;
	  if (evb->button == Button1) pev->left = 1;
	  if (evb->button == Button2) pev->middle = 1;
	  if (evb->button == Button3) pev->right = 1;
	  if (evb->state & ShiftMask) pev->shift = 1;
	  if (evb->state & ControlMask) pev->ctrl = 1;
	  if (evb->state & Mod1Mask) pev->alt = 1;
	  pev->w = px->w;
	  pev->h = px->h;
	  pev->x = evb->x;
	  pev->y = px->h - evb->y;
	  if (px->xcamera) px->xcamera->event(*pev);
	  delete pev;
	  break;
      }
      case MotionNotify: {
	  XPointerMovedEvent *evm = (XPointerMovedEvent *)eventPtr;
	  RT_MotionEvent *pev = new RT_MotionEvent;
	  if (evm->state & Button1Mask) pev->left = 1;
	  if (evm->state & Button2Mask) pev->middle = 1;
	  if (evm->state & Button3Mask) pev->right = 1;
	  if (evm->state & ShiftMask) pev->shift = 1;
	  if (evm->state & ControlMask) pev->ctrl = 1;
	  if (evm->state & Mod1Mask) pev->alt = 1;
	  pev->w = px->w;
	  pev->h = px->h;
	  pev->x = evm->x;
	  pev->y = px->h - evm->y;
	  if (px->xcamera) px->xcamera->event(*pev);
	  delete pev;
	  break;
      }
      case MapNotify:
	mapped = 1;
	break;
      case UnmapNotify:
	mapped = 0;
	break;
      case ConfigureNotify:
	if (window == None) configure();
	else reconfigure();
	break;
    } 
}
    
void RT_PixmapDisplayData::configure() {
    geometry(Tk_Width(tkwin), Tk_Height(tkwin));
    if (( window = Tk_WindowId(tkwin)) == None)  return;
    if (!glXMakeCurrent(Tk_Display(tkwin), Tk_WindowId(tkwin), context)) {
	rt_Output->fatal ("Can't connect context and window !");
    } 
    glEnable( GL_DEPTH_TEST );
    glEnable( GL_LIGHTING );
}

void RT_PixmapDisplayData::reconfigure() { geometry(Tk_Width(tkwin), Tk_Height(tkwin)); }

RT_PixmapDisplay::RT_PixmapDisplay(char *_name, int _w, int _h): RT_Pixmap(_name, _w, _h) {
    data = new RT_PixmapDisplayData(this, _name);
    w = _w; h = _h; 
    if (data->result == TCL_ERROR) return;
    if (w > 0 && h > 0)	Tk_GeometryRequest(data->tkwin, w, h);
}

RT_PixmapDisplay::~RT_PixmapDisplay() {
    data->del = 1;
    delete data;
}  

void RT_PixmapDisplay::activate() {
    if (!glXMakeCurrent(data->display, data->window, data->context))
	rt_Output->fatal("Can't connect context and window.");
}

void RT_PixmapDisplay::singlebuffer() {
    rt_Output->warning( "Can't change in singlebuffer mode !");
}

void RT_PixmapDisplay::doublebuffer() {
    rt_Output->warning( "Can't change in doublebuffer mode !");
}

// the event handling is done by tk\'s main loop 
void RT_PixmapDisplay::event() {}    

void RT_PixmapDisplay::putPixel(int x, int y, const RT_Color &colr) {
    GLfloat f[3];
    f[0] = colr.r; f[1] = colr.g; f[2] = colr.b;
    
    if (x == 0 && y == data->px->h-1) {
	// glDisable( GL_CULL_FACE );     
	glDisable(GL_DEPTH_TEST);
	glDisable(GL_LIGHTING);
	clear(RT_Color(0,0,0));
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluOrtho2D(0.0, (GLfloat)Tk_Width(data->tkwin), 0.0, (GLfloat)Tk_Height(data->tkwin));
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
    }
    if (sglBuf==0) glDrawBuffer(GL_FRONT_AND_BACK);
    glColor3fv (f);
    glRecti(x, y, x+1 ,y+1);
    glFlush();
}

RT_Color RT_PixmapDisplay::getPixel(int x, int y) {
    if (!checkIndices( x, y)) return RT_Color( 0,0,0);
    GLfloat c[3];
    glReadPixels(x, y, 1, 1, GL_RGB, GL_FLOAT, c);
    return(RT_Color(c[0], c[1], c[2]));
}

void RT_PixmapDisplay::clear(const RT_Color &colr) {
    float f[3];
    f[0] = colr.r; f[1] = colr.g; f[2] = colr.b; 
    glClearColor( f[0], f[1], f[2], 0.0 );
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
}

void RT_PixmapDisplayData::staticEventProc(ClientData cd, XEvent *eventPtr) {
    ((RT_PixmapDisplayData *)cd)->eventProc(eventPtr);
} 


#include "opgl.C"
