////////////////////////////////////////////////////////////////////////////////
//  implementation of communication.                                          //  
//  LAST EDIT: Tue Nov 22 11:08:04 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART VR extension. Copying, distribution and     //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright '94 '95 Ekkehard 'Ekki' Beier                                //
////////////////////////////////////////////////////////////////////////////////

#include "vr_comm.h"
#include "vr_scene.h"

extern "C" {
    #include <netinet/in.h>
    #include <unistd.h>
    #include <arpa/inet.h>
    #include <netdb.h>
    int gethostname( char*, int );
}

VR_Hostname::VR_Hostname(): RT_String( 256 ) {
    char shost[256]; // each subdomain is limited to 63 characters
    gethostname( shost, 255 );
    hostent *he = gethostbyname( shost );
    setValue( inet_ntoa( *(in_addr *)he->h_addr_list[0]) );
}

VR_Hostname vr_Hostname;

void vr_updateCamera() {
    static RT_LookatCamera *vr_Cam = 0;
    static RT_Primitive *p = 0;

    RT_Object *o;

    if (!vr_Cam) {
	if ( o = RT_Object::getObject( "vr_Cam" )) vr_Cam = (RT_LookatCamera*)o;
	else return;
    }

    if (!p) {
	if ( strcmp( RT_eval( "set vr_UID"), "0" )) {
	    RT_String s( 10 );
	    s = "us";
	    s += RT_eval( "set vr_NO" );
	    if ( o = RT_Object::getObject( (char*)s )) p = (RT_Primitive*)o;
	    else return;
	}
	else return;
    }
    
    // viewpoint and reference point:
    static RT_Vector vp( 0, 1.7, 0);
    static RT_Vector rp( 0, 1.7, 5);

    vr_Cam->viewpoint( p->mc2wc( vp ) );
    vr_Cam->refpoint( p->mc2wc( rp ) );

    RT_eval( "after 100 {vr_User -update}" );
}

VR_SceneCommunicator *vr_SceneCommunicator;

VR_SceneCommunicator::VR_SceneCommunicator() { 
    rt_Output->setProgram( "VR_SCENE" );
    
    ip = Tcl_CreateInterp(); 
    Tcl_CreateCommand( ip, "login", VR_SceneCommunicator::loginCMD, 0, 0 );
    Tcl_CreateCommand( ip, "logout", VR_SceneCommunicator::logoutCMD, 0, 0 );
    Tcl_CreateCommand( ip, "send", VR_SceneCommunicator::sendCMD, 0, 0 );
    Tcl_CreateCommand( ip, "command", VR_SceneCommunicator::sendCMD, 0, 0 );
    Tcl_CreateCommand( ip, "forward", VR_SceneCommunicator::forwardCMD, 0, 0 );
    Tcl_CreateCommand( ip, "upward", VR_SceneCommunicator::forwardCMD, 0, 0 );
    Tcl_CreateCommand( ip, "rotate", VR_SceneCommunicator::forwardCMD, 0, 0 );
    Tcl_CreateCommand( ip, "pick", VR_SceneCommunicator::pickCMD, 0, 0 );
    Tcl_CreateCommand( ip, "resetPosition", VR_SceneCommunicator::logoutCMD, 0, 0 );
}

VR_SceneCommunicator::~VR_SceneCommunicator() { 
    Tcl_DeleteInterp( ip ); 
}

int VR_SceneCommunicator::YARTeval( Tcl_Interp *ip, char *argv[] ) {
    RT_String s = "server -";
    while ( *argv ) { s += *argv++; s += ' '; }
    Tcl_SetResult( ip, RT_eval( (char*)s ), TCL_VOLATILE ); 
    return TCL_OK;
}

void VR_SceneCommunicator::sendText2user(VR_User *, const char *txt) {
    Tcl_VarEval( ip, "vr_User -message {", txt, "}", 0 );
}

void VR_SceneCommunicator::sendCmd2user(VR_User *, const char *) {
    vr_updateCamera();
    // do nothing else cos we're working with the original scene
}

void VR_SceneCommunicator::sendBlob2user(VR_User *, const char *, const char*, int) {
}

char *VR_SceneCommunicator::eval(char *cmds) {
    Tcl_GlobalEval( ip, cmds );
    return ip->result;
}

void VR_SceneCommunicator::loop() {
    class LCB: public RT_Callback {
	char cmd[1001];
	void exec(RT_InputDevice*) {    
	    fgets( cmd, 1000, stdin ); 
	    fprintf( stdout, "%s\n-> ", vr_SceneCommunicator->eval( cmd ) ); fflush( stdout ); 
	}
      public:
	LCB() { fprintf( stdout, "-> " ); fflush( stdout ); }
    };
    (new RT_FileDevice( 0, 0, 1 ))->addCB( new LCB );
    rt_InputServer->loop();
}

int VR_SceneCommunicator::loginCMD(ClientData, Tcl_Interp *ip, int argc, char *argv[]) {
    if (argc != 3) {
	Tcl_AppendResult( ip, argv[0],": wrong # args: should be \"",
			 argv[0]," <user@host> <representation>!\"",
			 0 );
	return TCL_ERROR;
    }
    return YARTeval( ip, argv );
}

int VR_SceneCommunicator::logoutCMD(ClientData, Tcl_Interp *ip, int argc, char *argv[]) {
    if (argc != 2) {
	Tcl_AppendResult( ip, argv[0],": wrong # args: should be \"",
			 argv[0]," <userID>!\"",
			 0 );
	return TCL_ERROR;
    }
    return YARTeval( ip, argv );
}

int VR_SceneCommunicator::sendCMD(ClientData, Tcl_Interp *ip, int argc, char *argv[]) {
    if (argc != 3) {
	Tcl_AppendResult( ip, argv[0],": wrong # args: should be \"",
			 argv[0]," <userID> <message>!\"",
			 0 );
	return TCL_ERROR;
    }
    return YARTeval( ip, argv );
}

int VR_SceneCommunicator::forwardCMD(ClientData, Tcl_Interp *ip, int argc, char *argv[]) {
    if (argc != 3) {
	Tcl_AppendResult( ip, argv[0],": wrong # args: should be \"",
			 argv[0]," <userID> <value>!\"",
			 0 );
	return TCL_ERROR;
    }
    return YARTeval( ip, argv );
}

int VR_SceneCommunicator::pickCMD(ClientData, Tcl_Interp *ip, int argc, char *argv[]) {
    if (argc != 3) {
	Tcl_AppendResult( ip, argv[0],": wrong # args: should be \"",
			 argv[0]," <userID> <Object>!\"",
			 0 );
	return TCL_ERROR;
    }
    return YARTeval( ip, argv );
}

int exitCMD(ClientData, Tcl_Interp *, int, char *[]) {
    exit( 0 );
    return TCL_OK;
}

VR_UserCommunicator::VR_UserCommunicator( Tcl_Interp *_ip, const char *scd) {
    rt_Output->setProgram( "VR_USER" );

    ip = _ip;
    Tcl_CreateCommand ( ip, "sceneEval", VR_UserCommunicator::sceneEvalCMD, 0, 0 );

    if (scd) {
	// we're working on a local scene
	vr_SceneCommunicator = new VR_SceneCommunicator;
	vr_Scene = new VR_Scene( scd );

	Tcl_VarEval( ip, "vr_User -message {This is ", (char*)vr_Scene->getSceneName(),
		       " in local mode.}", 0 );
	
	VR_User *us = vr_Scene->login( getlogin(), getRepresentation() );
	vr_Scene->newUser( us );

	RT_String s(20);
	s = "set vr_UID ";
	char is[10];
	sprintf( is, "%i", us->getID() );
	s += is;
	Tcl_GlobalEval( ip, s );

	s = "set vr_NO ";
	sprintf( is, "%i", us->getNumber() );
	s += is;
	Tcl_GlobalEval( ip, s );

	// bring back the exit command:
	RTM_command( "exit", exitCMD );
	vr_updateCamera();
    }
}

void VR_UserCommunicator::send(char *s) {
    vr_SceneCommunicator->eval( s ); 
    // assuming its a vr_SceneCommunicator (i.e. local)
}

int VR_UserCommunicator::sceneEvalCMD(ClientData, Tcl_Interp *ip, int argc, char *argv[]) {
    if (argc != 2) {
	Tcl_AppendResult( ip, argv[0],": wrong # args: should be \"",
			 argv[0]," <command>!\"",
			 0 );
	return TCL_ERROR;
    }
    vr_UserCommunicator->send( RT_String( argv[1] ) );
    return TCL_OK;
}

const char *VR_UserCommunicator::getRepresentation() {
    char *h = getenv( "HOME" );
    assert( h );
    RT_String repr( 100 );
    repr += h;
    repr += "/.yartvr";

    FILE *fp = fopen( (char*)repr, "r" );
    if (!fp) rt_Output->fatalVar( "Couldn't read your representation file: ", (char*)repr, "!", 0 );
 
    static char urp[VR_MAX_USER_REPRESENTATION + 1];
    fread( (void*)urp, VR_MAX_USER_REPRESENTATION, 1, fp );
    fclose( fp );
    return urp;
}

VR_UserCommunicator *vr_UserCommunicator;
    
void VR_userMessage(const RT_String &m) {
    Tcl_VarEval( rt_Ip, "VR_userMessage {", (char*)m, "}", 0 );
}



 

