/*
 * StrUtil.cc - utility routines that work on Strings
 * 
 * -----------------------------------------------------------------------------
 * Copyright 1993 Allan Brighton.
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies.  Allan
 * Brighton make no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 * -----------------------------------------------------------------------------
 */


#include <string.h>
#include <stdio.h>
#include <StrUtil.h>


/*
 * write the string to the stream
 */
ostream& operator<<(ostream& os, const String& s)
{ 
    os.write(s.string(), s.length()); 
    return os;
}


/*
 * concat strings
 */
CopyString operator+(const String& s1, const String& s2)
{
    int l1 = s1.length();
    int l2 = s2.length();
    int len = l1 + l2;
    char* buf = new char[len + 1];
    strncpy(buf, s1.string(), l1);
    strncpy(buf+l1, s2.string(), l2);
    buf[len] = '\0';
    return CopyString(buf, len, 0);
}


/*
 * Return the basename of the string in the same
 * way as the sh basename command.
 */
String basename(const String& s)
{
    int i = s.rindex('/');
    if (i > 0) {
	return s.right(i+1);
    } else {
	return s;
    }
}


/*
 * Return the directory name of the string in the same
 * way as the sh dirname command.
 */
String dirname(const String& s)
{
    int i = s.rindex('/');
    if (i >= 0) {
        if (i == 0)
            return "/";
	return s.left(i);
    } else {
	return ".";
    }
}



/*
 * convert int to string
 */
CopyString itos(int i)
{
    char buf[32];
    sprintf(buf, "%d", i);
    return buf;
}

