/******************************************************************************
 * The XJNSlib X library (XJNSlib.c and XJNSlib.h) are Copyright (c) 1995 by  *
 * Jon N. Steiger, and is licensed for non-commercial use *only*.  If you     *
 * use any of this code in your own programs, please give credit where credit *
 * is due.  Thanks.                                           -Jon-           *
 ******************************************************************************/
#include <X11/Xlib.h>
#include <X11/Xutil.h>

int CenterWidth(XFontStruct *TheFont, char *string, int width);
int CenterHeight(XFontStruct *TheFont, int height);
void Draw3D(Display *TheDisplay, Window TheWindow, GC TheGC, 
            int xpos, int ypos, char *string,
            int maincolor, int highcolor, int lowcolor);

void Draw2D(Display *TheDisplay, Window TheWindow, GC TheGC, 
            int xpos, int ypos, int depth, char *string,
            int maincolor, int lowcolor);

int ColorAdjust(int color);

void BevelWindow(Display *TheDisplay, Drawable TheDrawable, GC TheGC,
                 int DirectionFlag, 
                 int Xpos, int Ypos,
                 int BevelWidth, int BevelHeight, int BevelThickness,
                 int lightcolor, int darkcolor, int BackgroundFlag);

void DigitalSectionPrint(Display *TheDisplay, Drawable TheDrawable, GC TheGC,
                         int XPos, int YPos, int longside, 
                         int thickness, int step, int sidespace, 
                         int forecolor, int SectionNum);
void DigitalInterpret(Display *TheDisplay, Drawable TheDrawable, GC TheGC,
                      int XPos, int YPos,  
                      int longlength, int thickness, int step,
                      int sidespace, 
                      int forecolor, int backcolor,
                      int number);    

void DigitalIntegerPrint(Display *TheDisplay, Drawable TheDrawable, GC TheGC,
                     int XPos, int YPos, 
                     int longlength, int thickness, int step,
                     int sidespace, int spacing, 
                     int forecolor, int backcolor,
                     int number);

void DigitalPrint(Display *TheDisplay, Drawable TheDrawable, GC TheGC,
                  int XPos, int YPos, int DrawableWidth, int DrawableHeight,
                  int PixelHeight, int ForeColor, int FlagBackColor,
                  int FlagShadeColor, int number);

void DigitalPrintRJ(Display *TheDisplay, Drawable TheDrawable, GC TheGC,
                  int XPos, int YPos, int DrawableWidth, int DrawableHeight,
                  int PixelHeight, int ForeColor, int FlagBackColor,
                  int FlagShadeColor, int columns, int number);

void ClearDigitalField(Display *TheDisplay, Drawable TheDrawable, GC TheGC,
                      int XPos, int YPos, int PixelHeight, int backcolor, 
                      int columns);

int CharsIn(int number);

int CursorSpin (Display *TheDisplay, Drawable TheDrawable,
                Cursor TheCursorArray[], int numcursor, int direction);

void DrawTriangle(Display *TheDisplay, Drawable TheDrawable, GC TheGC,
                         int XPos, int YPos, 
                         int Size, int Direction, int Height,  
                         int DarkColor, int MainColor); 

