#include <sys/types.h>

/* struct inquiry_data {
	char dev_type:5;
 	char periph_qual:3;	

	char dev_type_mod:7;
	char rmb:1;

	char ansi_ver:3;	
	char ecma_ver:3;
	char iso_ver:2;

	char rdf:4;
	char reserved_3:2;
	char TrmIOP:1;
	
	char add_length;
	char reserved_5;
	char reserved_6;
	
	char RelAdr:1; 
	char WBus32:1; 
	char WBus16:1; 
	char Sync:1; 
	char Linked:1; 
	char reserved_7:1;
	char CmdQue:1; 
	char SftRe:1;

	char vendor[8];
	char product[16];
	char revision[4];	
};
*/

extern int fd;
#define ADD_SENSECODE 12
#define ADD_SC_QUALIFIER 13


#define COLOR_POSITIVE 0x0003
#define COLOR_NEGATIVE 0x0002
#define MONO_POSITIVE  0x0001
#define MONO_NEGATIVE  0x0000
#define LINEAR_GAMMA 	0x0000
#define TV_GAMMA 	0x0001
#define USER_GAMMA_1	0x0002
#define USER_GAMMA_2	0x0003
#define USER_GAMMA_3	0x0004
#define USER_GAMMA_4	0x0005
#define FORMAT_PPM 	0x1230
#define FORMAT_PGM	0x1231
#define nextargi (--argc,atoi(*++argv))
#define nextargf (--argc,atof(*++argv))
#define nextargs (--argc,*++argv)

#define MAX_X 3888
#define MAX_Y 2592
struct cs_state_struct {
	char outfile[100];
	int outputformat;
	int film_type;
	int red;
	int green;
	int blue;
	int exp_time;
	int bright_red,bright_green,bright_blue;
	int contrast_red,contrast_green,contrast_blue;

	int output_color;
	int x1,y1,x2,y2,px,py,nx,ny;
	int gamma;
	int analog_gamma;
	int averaging;
	int if_timeout;
	int prescan_valid;
	int do_prescan;

}cs_state;

struct cs_idata_s {
	u_short ad_bits;
	u_short res_02_0e[7];
	u_short apval;
	u_short res_12[1];
	u_short ucb_r,ucb_g,ucb_b;
	u_short brt_r,brt_g,brt_b;
	u_short cnt_r,cnt_g,cnt_b;
	u_short sft_r,sft_g,sft_b;
	u_short res_2c_3e[10];
	short x_address;
	u_short res_42_5e[15];	
	u_short film_type;
	u_short res_62_7e[15];
	u_short undoc80[3];
	u_short res_86;
	u_short undoc88[3];
	u_short res_8e;
	u_short undoc90[3];
	u_short res_96_fe[53];
	u_char endcode;
}cs_idata;

/*	SCSI Commands	*/

extern int sg_xfer(u_char *,int ,u_char *, int );
extern int inquire_device(char *mfg,char *model);
extern int read_data_10(unsigned char type,unsigned char *dest,int len);
extern int write_data_10(char *data,int len);
extern int test_unit_ready( );
extern void write_string(unsigned char *format,...);
extern int is_coolscan(char *devname);


extern int find_coolscan(void);

/*
 *
 *	COOLSCAN commands :
 *
 */

extern void wait_for_ack(int timeout);
extern int get_data_block(int type,unsigned char *buf,int buflen);
extern void set_film_type(int type);
extern void prescan();
extern int exp_time(int volume);
extern void register_color_balance_negative(int ,int ,int ,int  );
extern void register_color_balance_positive(int k,int red,int green,int blue);
extern void register_color_balance(int k, int red, int green, int blue,int film_type );
extern void specify_color_balance(int which);
extern void read_color_balance(int which);
extern void line_sequential_output();
extern void pixel_interleave_output();
extern void mono_output_color(char c);
extern void scan( char *filename,int format,int x1,int y1,int px,int py,int nx,int ny);
extern void read_line(int line,char *buf);
extern void print_line(int line);
extern void tv_gamma();
extern void linear_gamma();
extern void brightness(int red,int green,int blue) ;
extern void contrast(int red,int green, int blue);
extern void agon();
extern void agof();
extern void avon();
extern void avof();
extern void read_rom_ver();
extern void test_interface();
extern int read_error();
extern void rcnd(struct cs_idata_s *data);
extern void print_idata(struct cs_idata_s *d);
extern void dump_idata(struct cs_idata_s *d);
extern void reset();
extern void init_mem();
extern void apin() ;
extern void eject();
extern void stage_move_to(int n);
extern void abort_scan();
extern void read_empty();
extern void init(struct cs_state_struct *s);
extern void set_state( struct cs_state_struct *s);
extern void interactive_main(int argc, char **argv);
