### Copyright (C) 1995 Jesper K. Pedersen
### This program is free software; you can redistribute it and/or modify
### it under the terms of the GNU General Public License as published by
### the Free Software Foundation; either version 2 of the License, or
### (at your option) any later version.
###
### This program is distributed in the hope that it will be useful,
### but WITHOUT ANY WARRANTY; without even the implied warranty of
### MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
### GNU General Public License for more details.
###
### You should have received a copy of the GNU General Public License
### along with this program; if not, write to the Free Software
### Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


############################################################
# First of all check for the right version of wish
############################################################
if {$tk_version != "4.0"} {
  puts {!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
                            WARNING

    The Dotfile Generator requires at least Tcl 7.4 / Tk4.0}
  puts "    Your version is $tk_version"
  puts {
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!}
}
    
############################################################
#                     Sourceing funktion files
############################################################
foreach file {
  parse types menus help functions util save setup inout fillouts} {
  source [lindex $argv 0]/$file.tcl
}

############################################################
#                    General initializion
############################################################
if {![info exists setup(dotfile)]} {
    set setup(dotfile) {{file1 Dotfile output.dot}}
}
foreach elm $setup(dotfile) {
    set fileHandles([lindex $elm 0]) [lindex $elm 2]
}
if {![info exists setup(file)]} {
  set setup(file) 1
}
if {![info exists setup(print)]} {
  set setup(print) 1
}
if {![info exists setup(commentchar)]} {
  set commentChar ""
}
if {![info exists setup(onePage)]} {
  set setup(onePage) 0
}
if {![info exists setup(generateDefault)]} {
  set setup(generateDefault) 0
}
upvar \#0 setup(generateDefault) generateDefault
if {![info exists setup(saveOnGenerate)]} {
  set setup(saveOnGenerate) 0
}
if {![info exists setup(commentchar)]} {
  set setup(commentchar) ""
}
if {![info exists module(overAllDesc)]} {
  set module(overAllDesc) "\$commentChar This file has been auto generated\n\$commentChar by the $module(name) module for the Dotfile Generator\n\$commentChar on \[exec date\]\n"
}
if {$argv0 == "wish"} {
  puts "To start this program, type wish <template file> <dotfile path> <module path>"
  exit -1
}

set changed 0
set fillOutCounter 0    ;# just to avoid testing existens
set editInfo(name) ""   ;# just to avoid testing existens
set editInfo(trace) 0
parseFile

############################################################
#                      Menu WINDOW
############################################################

frame .menu
pack .menu -expand 1 -fill both
subType "/"

frame .buttons
pack .buttons -side bottom -expand 1 -fill both
pack [frame .buttons.f1] [frame .buttons.f2] \
    -expand 1 -fill x
button .buttons.f1.quit -text "QUIT" -command quit -width 9
button .buttons.f1.about -text "About" -command about -width 9
button .buttons.f1.setup -text "Setup" -command setup -width 9
button .buttons.f2.save -text "Save" -command saveFile -width 9
button .buttons.f2.reset -text "Reset Page" -command resetToDefult -width 9
button .buttons.f2.generate -text "Generate" -command generate -width 9
bind .buttons.f1.setup <3> "generalHelp Setup"
bind .buttons.f2.save <3> "generalHelp \"Internal Status\""
bind .buttons.f2.reset <3> "generalHelp \"Reset Page\""
bind .buttons.f2.generate <3> "generalHelp Generate"

pack .buttons.f1.about .buttons.f1.setup .buttons.f1.quit  -side left -expand 1 -fill both
pack  .buttons.f2.save .buttons.f2.reset .buttons.f2.generate -expand 1 -fill both -side left

############################################################
#               global bindings for entry's
############################################################
bind Entry <Double-ButtonPress-3> {%W delete sel.first sel.last}
bind . <Control-s> generate
wm withdraw .
wm geometry . +0+0
wm deiconify .
wm title . "Dotfile Generator"

############################################################
#                 sourceing .dotfilerc
############################################################
if {[file exists ~/.dotfilerc]} {
  source ~/.dotfilerc
}

############################################################
#           and now for the copyright notice
############################################################
puts "The Dotfile Generator version 1.1b Copyright (C) 1995 Jesper K. Pedersen"
puts "The Dotfile Generator comes with ABSOLUTELY NO WARRANTY; for details"
puts "see the \"about\" menu. This is free software, and you are welcome to"
puts "redistribute it under certain conditions; see the \"about\" menu"
puts "for details."

############################################################
#                checking for an export file
############################################################
if {[file exists ~/.dotfile/$module(name)]} {
  set answer [tk_dialog .dialog "Load data" "A save file exists. Load it?" questhead 0 Yes No]
  if {$answer == 0} {
    importFile
  }
}
