# Tools used in the Fvwm module

proc getColors {} {
  set names {}
  foreach i {/usr/local/lib/X11/rgb.txt /usr/lib/X11/rgb.txt
    /X11/R5/lib/X11/rgb.txt /X11/R4/lib/rgb/rgb.txt
    /usr/openwin/lib/X11/rgb.txt} {
    if ![file readable $i] {
      continue;
    }
    set f [open $i]
    while {[gets $f line] >= 0} {
      if {[llength $line] == 4} {
	lappend names [lindex $line 3]
      }
    }
    close $f
    break
  }
  return [lsort $names]
}

proc getFonts {} {
  set result {}
  if {[auto_execok xlsfonts]} {
    set result [exec xlsfonts]
  }
  return [lsort $result]
}

proc makeContextOrModifier {contextList} {
  set result {}
  foreach var $contextList {
    append result [string index $var 0]
  }
  return $result
}
