### Copyright (C) 1995 Jesper K. Pedersen
### This program is free software; you can redistribute it and/or modify
### it under the terms of the GNU General Public License as published by
### the Free Software Foundation; either version 2 of the License, or
### (at your option) any later version.
###
### This program is distributed in the hope that it will be useful,
### but WITHOUT ANY WARRANTY; without even the implied warranty of
### MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
### GNU General Public License for more details.
###
### You should have received a copy of the GNU General Public License
### along with this program; if not, write to the Free Software
### Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


proc saveFile {} {
  global module progList changed saveInfo children widgetArgs ok \
      fillList fillOutCounter scrollValue
  set saved {}
  set hash {############################################################}

  if {![file exists ~/.dotfile]} {
    exec mkdir [glob ~/].dotfile
  }
  set FILE [open ~/.dotfile/$module(name) w]
  foreach menu $progList {
    set changed 0
    set any 0
    foreach var [uplevel \#0 info vars ${menu}_*] {
      if {!$any} {puts $FILE "$hash\n\# $menu\n$hash"}
      
      if {[catch "uplevel \#0 set $var"]} {
	foreach subvar [uplevel \#0 array names $var] {
	  puts $FILE \
	      "set ${var}($subvar) \"[escape [uplevel set ${var}($subvar)]]\""
	}
      } else {
	puts $FILE "set $var \"[escape [uplevel \#0 set $var]]\""
      }
      set any 1
    }
    if {$any} {
      lappend saved $menu
    }
  }
  puts $FILE "$hash\n\# setup\n$hash"
  foreach elm [array names setup] {
    puts $FILE "set setup($elm) \{$setup($elm)\}"
  }

  puts $FILE "$hash\n\# saveInfo\n$hash"
  foreach elm [array names saveInfo] {
    puts $FILE "set saveInfo($elm) $saveInfo($elm)"
  }

  if {[info exists fillList]} {
    puts $FILE "$hash\n\# fillList (fillouts)\n$hash"
    foreach elm [array names fillList] {
      puts $FILE "set fillList($elm) \{$fillList($elm)\}"
    }
    puts $FILE "set fillOutCounter $fillOutCounter"
  }
  if {[info exists scrollValue]} {
    puts $FILE "$hash\n\# scrollValue (scrollbars)\n$hash"
    foreach elm [array names scrollValue] {
      puts $FILE "set scrollValue($elm) \{$scrollValue($elm)\}"
    }
  }


  puts $FILE "$hash\n\# update info\n$hash"
  puts $FILE "toplevel .loading"
  puts $FILE "label .loading.text -text {Loading Information...Please wait}"
  puts $FILE "pack .loading.text"
  puts $FILE "for {set i 0} {\$i < [llength $saved]} {incr i} \{"
  puts $FILE "\tlabel .loading.\$i -relief groove -bd 1"
  puts $FILE "\tpack .loading.\$i -side left -fill x -expand 1"
  puts $FILE "\}"
  puts $FILE "set oldpage \$editInfo(name)"
  puts $FILE "set i 0"
  puts $FILE "foreach menu {$saved} \{"
  puts $FILE "\tset loaded(\$menu) 1"
  puts $FILE "\tset editInfo(name) \$menu"
  puts $FILE "\tset changeFunc(\$menu) {}"
  puts $FILE "\tset ok(\$menu) {}"
  puts $FILE "\tset desc(\$menu) {}"
  puts $FILE "\tset pageEnd(\$menu) {}"
  puts $FILE "\t\$menu"
  puts $FILE "\t.loading.\$i configure -background black"
  puts $FILE "\tupdate"
  puts $FILE "\tincr i"
  puts $FILE "\}"
  puts $FILE "set editInfo(name) \$oldpage"
  puts $FILE "destroy .loading"
  close $FILE
}

proc importFile {} {
  global module editInfo
  
  if {![file exists ~/.dotfile/$module(name)]} {
    error "no importfile:\n \"~/.dotfile/$module(name)\" doesn't exists"
  }
  uplevel \#0 source ~/.dotfile/$module(name)
  if {$editInfo(name) != ""} {
    packAll .edit.options $editInfo(name) 0 0
  }
}

proc escape {string} {
  set length [string length $string]
  set result ""
  for {set i 0} {$i < $length} {incr i} {
    set char [string index $string $i]
    if {$char == {"} || $char == {#} || $char == "\\" || $char == {$} ||
$char == "\{" || $char == "\}" || $char == "\[" || $char == "\]"} {
       append result "\\$char"
    } else {
      append result $char
    }
  }
  return $result
}
