### Copyright (C) 1995 Jesper K. Pedersen
### This program is free software; you can redistribute it and/or modify
### it under the terms of the GNU General Public License as published by
### the Free Software Foundation; either version 2 of the License, or
### (at your option) any later version.
###
### This program is distributed in the hope that it will be useful,
### but WITHOUT ANY WARRANTY; without even the implied warranty of
### MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
### GNU General Public License for more details.
###
### You should have received a copy of the GNU General Public License
### along with this program; if not, write to the Free Software
### Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


proc setup {} {
  global setup temp widget2Help saveInfo 

  if {[winfo exists .setup]} {
    raise .setup
    wm deiconify .setup
    return
  }
  toplevel .setup

  foreach var {file print commentchar
    onePage generateDefault saveOnGenerate} {
    set temp($var) $setup($var)
  }
  
  label .setup.label -text "Setup"
  pack .setup.label

  frame .setup.filename
  pack .setup.filename -expand 1 -fill both
  set i 0
  foreach elm $setup(dotfile) {
    pack [frame .setup.filename.$i] -expand 1 -fill x
    label .setup.filename.$i.label -text [lindex $elm 1]
    entry .setup.filename.$i.entry -textvariable temp(dotfile$i) \
	-bd 2 -relief sunken
    label .setup.filename.$i.label2 -text "Comment character: "
    entry .setup.filename.$i.commentChar -textvariable temp(commentChar$i)\
	-width 5
    pack .setup.filename.$i.label .setup.filename.$i.entry \
	.setup.filename.$i.label2 .setup.filename.$i.commentChar -side left
    set temp(dotfile$i) [lindex $elm 2]
    set temp(commentChar$i) [lindex $elm 3]
    incr i
  }

  frame .setup.save
  pack .setup.save -expand 1 -fill x
  checkbutton .setup.save.1 -text "Generate to file" \
      -variable temp(file) -anchor w 
  checkbutton .setup.save.2 -text "Print" \
      -variable temp(print) -anchor w 
  pack .setup.save.1 .setup.save.2 -fill x -side left -fill x -expand 1
  
  checkbutton .setup.whatTosave -text "Generate defaults too" \
      -variable temp(generateDefault) -anchor w
  checkbutton .setup.onePage -text "Just generate one page at a time"\
      -variable temp(onePage) -anchor w
  checkbutton .setup.saveOnGenerate -text "Save when generating" \
      -variable temp(saveOnGenerate) -anchor w
  pack .setup.whatTosave .setup.onePage .setup.saveOnGenerate -fill both -expand 1

  frame .setup.buttons
  pack .setup.buttons -expand 1 -fill x
  button .setup.buttons.ok -text "OK" -command {
    foreach var {file print commentchar
      onePage generateDefault saveOnGenerate} {
      set setup($var) $temp($var)
    }
    set i 0
    set new {}
    foreach elm $setup(dotfile) {
	lappend new [list [lindex $elm 0] [lindex $elm 1] \
			 $temp(dotfile$i) $temp(commentChar$i)]
	set fileHandles([lindex $elm 0]) $temp(dotfile$i)
	incr i
    }
    set setup(dotfile) $new
    if {[winfo exists .edit.save]} {
      if {$setup(onePage)} {
	if {[winfo exists .edit.save.yes]} {
	  destroy .edit.save.yes .edit.save.no
	}
	if {![winfo exists .edit.save.label]} {
	  pack [label .edit.save.label -text "Only this page will be generated"]
	}
      } else {
	if {[winfo exist .edit.save.label]} {
	  destroy .edit.save.label
	}
	if {![winfo exist .edit.save.yes]} {
	  radiobutton .edit.save.yes -text "Will be generated" \
	      -variable saveInfo($editInfo(name)) -value 1
	  radiobutton .edit.save.no -text "Will not be generated" \
	      -variable saveInfo($editInfo(name)) -value 0
	  pack .edit.save.yes .edit.save.no -side left -expand 1
	}
      }
    }
    destroy .setup
  }
  button .setup.buttons.cancel -text "CANCEL" -command {
    destroy .setup
  }
 
  pack .setup.buttons.ok .setup.buttons.cancel -side left -fill x -expand 1
  bind .setup <3> "generalHelp Setup"
}
