# jdoc_hypertext.tcl - hypertext procedures for jdoc
# 
# Copyright 1992-1994 by Jay Sekora.  All rights reserved, except 
# that this file may be freely redistributed in whole or in part 
# for nonprofit, noncommercial use.

##############################################################################
# jdoc:x_link w x y - go to link clicked on (hypertext)
##############################################################################

proc jdoc:x_link { {w} {x} {y} args } {
  set tags [$w tag names @$x,$y]
  
  foreach tag $tags {				;# find topic-name tag
    if [string match "jdoc:link:*" $tag] {
      set link [string range $tag 10 end]	;# strip off "jdoc:link:"
      if [string match "#*" $link] {		;# anchor within this doc
        set anchor [string trimleft $link "#"]
        jdoc:go_to_anchor $anchor $w $x $y
      } else {					;# separate doc
        exec jdoc $link &
      }
      break
    }
  }
}

##############################################################################
# jdoc:x_topic w x y - view doc clicked on (hypertext)
##############################################################################

proc jdoc:x_topic { {w} {x} {y} args } {
  puts stderr "Warning: obsolete procedure jdoc:x_topic invoked."
  set tags [$w tag names @$x,$y]
  
  foreach tag $tags {				;# find topic-name tag
    if [string match "jdoc:topic:*" $tag] {
      set topic [string range $tag 11 end]	;# strip off "jdoc:topic:"
      exec jdoc $topic &
      break
    }
  }
}

##############################################################################
# jdoc:x_section w x y - go to section name clicked on (hypertext)
##############################################################################

proc jdoc:x_section { {w} {x} {y} args } {
  puts stderr "Warning: obsolete procedure jdoc:x_section invoked."
  set tags [$w tag names @$x,$y]
  
  foreach tag $tags {				;# find section-name tag
    if [string match "jdoc:section:*" $tag] {
      set section [string range $tag 13 end]	;# strip off "jdoc:section:"
      .menu.sections.m invoke $section
      break
    }
  }
}

##############################################################################
# jdoc:x_manpage w x y - view man page name clicked on (hypertext)
##############################################################################

proc jdoc:x_manpage { {w} {x} {y} args } {
  set tags [$w tag names @$x,$y]
  
  foreach tag $tags {				;# find manpage-name tag
    if [string match "jdoc:manpage:*" $tag] {
      set manpage [string range $tag 13 end]	;# strip off "jdoc:manpage:"
      catch {exec man $manpage |& ul -i} mantext
      j:more -height 30 \
        -title "Manual page for `$manpage'" \
        -text $mantext
      break
    }
  }
}

######################################################################
# jdoc:go_to_anchor anchor w x y - go to a particular anchor
######################################################################

proc jdoc:go_to_anchor { anchor w args } {
  if [catch {$w yview jdoc:anchorname:${anchor}.first}] {
    j:alert -text "Unable to find anchor `${anchor}' in this document."
  }
}
