# jdoc_ui.tcl - gui procedures for jdoc (also bindings)
# 
# Copyright 1992-1994 by Jay Sekora.  All rights reserved, except 
# that this file may be freely redistributed in whole or in part 
# for non-profit, noncommercial use.

##############################################################################
# jdoc:mkmenus - menu bar
##############################################################################

proc jdoc:mkmenus {} {
  frame .menu -borderwidth 2 -relief raised
  
  jdoc:mkmenu:doc
  jdoc:mkmenu:document
  jdoc:mkmenu:sections
  
  pack .menu -in . -side top -fill x
  
  tk_menuBar .menu .menu.doc .menu.document .menu.sections
}

##############################################################################
# jdoc:mkmenu:doc - doc menu
##############################################################################

proc jdoc:mkmenu:doc {} {
  menubutton .menu.doc -text {Doc Viewer} -menu .menu.doc.m
  pack .menu.doc -in .menu -side left

  menu .menu.doc.m
  .menu.doc.m add command -label {Help with Doc Viewer} -accelerator {[h]} \
    -command {jdoc:cmd:help}
  .menu.doc.m add command -label {About the Doc Viewer . . .} \
    -command {jdoc:cmd:about}
  .menu.doc.m add command -label {Global Preferences . . .} \
    -accelerator {[G]} \
    -command {j:global_pref_panel}
  .menu.doc.m add command -label {Doc Viewer Preferences . . .} \
    -accelerator {[P]} \
    -command {jdoc:cmd:doc_prefs}
  .menu.doc.m add separator
  .menu.doc.m add command -label {Issue Tcl Command . . .} \
    -accelerator {[T]} -command {j:prompt_tcl}
  .menu.doc.m add command -label {Issue Unix Command . . .} \
    -accelerator {[U]} -command {j:prompt_unix}
  .menu.doc.m add separator
  .menu.doc.m add command -label {Quit} -accelerator {[q]} \
    -command {destroy .}
}

##############################################################################
# jdoc:mkmenu:document - document menu
##############################################################################

proc jdoc:mkmenu:document {} {
  menubutton .menu.document -text {Document} -menu .menu.document.m
  menu .menu.document.m
  .menu.document.m add command -label {Load . . .} \
    -accelerator {[l]} -command {jdoc:cmd:load}
  .menu.document.m add command -label {Save As . . .} \
    -command "j:tc:saveas .t"
  .menu.document.m add command -label {Print} \
    -command "jdoc:cmd:print_postscript"
  .menu.document.m add separator
  .menu.document.m add command -label {Find . . .} -accelerator {[f]} \
    -command "j:find -replace 0 .t"

  pack .menu.document -in .menu -side left
}

##############################################################################
# jdoc:mkmenu:sections - sections menu
##############################################################################

proc jdoc:mkmenu:sections {} {
  menubutton .menu.sections -text {Sections} -menu .menu.sections.m
  pack .menu.sections -in .menu -side left

  menu .menu.sections.m
}

##############################################################################
# jdoc:mkbuttons - buttons at bottom
##############################################################################

proc jdoc:mkbuttons {} {
  j:buttonbar .b -buttons {
    {done Done {destroy .}}
    {open "Load..." {jdoc:cmd:load}}
    {print "Print" {jdoc:cmd:print_postscript}}
    {find "Find..." {j:find -replace 0 .t}}
  }
  pack .b [j:rule .] -in . -side bottom -fill x
}

##############################################################################
# jdoc:mktext - text widget
##############################################################################

proc jdoc:mktext {} {
  global J_PREFS
  if {[lsearch [array names J_PREFS] {scrollbarside}] == -1} {
    set J_PREFS(scrollbarside) right ;# make sure it's defined
  }
  text .t -yscrollcommand {.s set} \
    -width 70 -height 18 -borderwidth 4 \
    -setgrid true -wrap word
  scrollbar .s -relief flat -command {.t yview}
  pack .s [j:rule .] -in . -side $J_PREFS(scrollbarside) -fill y
  pack .t -in . -side $J_PREFS(scrollbarside) -fill both -expand y
  jdoc:configure_text .t
  
  focus .t
  catch {focus default .t}			;# caught for Tk 4.0
  tk_bindForTraversal .t
}


##############################################################################
# jdoc:mkbindings widgets - text widget command bindings
##############################################################################

proc jdoc:mkbindings { { widgets .t } } {
  foreach w $widgets {
    bind $w <Meta-f> {j:find -replace 0 .t}
    bind $w <Meta-h> {jdoc:cmd:help}
    bind $w <Meta-l> {jdoc:cmd:load}
    bind $w <Meta-q> {jdoc:cmd:quit}
    bind $w <Meta-G> {j:global_pref_panel}
    bind $w <Meta-P> {jdoc:cmd:doc_prefs}
    bind $w <Meta-T> {j:prompt_tcl}
    bind $w <Meta-U> {j:prompt_unix}
  }
}
