# exmh-mode.tcl - mode for composing mail in exmh
#
# To use this, set your editor in exmh to "jedit -mode exmh -for &"
######################################################################

proc mode:exmh:init { t } {
  global JEDIT_MODEPREFS
  
  j:read_prefs -array JEDIT_MODEPREFS -prefix exmh \
    -directory ~/.tk/jeditmodes -file mh-defaults {
    {textfont default}
    {textwidth 80}
    {textheight 24}
    {textwrap char}
    {sabbrev 0}
    {dabbrev 0}
    {autobreak 1}
    {autoindent 0}
    {savestate 0}
    {buttonbar 1}
    {menu,editor 1}
    {menu,file 1}
    {menu,edit 1}
    {menu,prefs 0}
    {menu,abbrev 1}
    {menu,filter 1}
    {menu,format 0}
    {menu,display 0}
    {menu,mode1 1}
    {menu,mode2 1}
    {menu,user 1}
  }
  
  # catch {$t tag configure header -background LemonChiffon}
  $t tag configure header -relief flat		;# just to create it
  $t tag lower header
  catch {$t tag configure sig -font {-*-courier-bold-r-normal--10-100-*}}
  $t tag lower sig
  
  # problematical: gets in the way of dabbrevs
  #
  bind $t <Double-Tab> "mode:exmh:to_body $t"
  bind $t <Tab> "mode:exmh:next_header $t"
}

######################################################################
# special hooks:

proc mode:exmh:post_read_hook { filename t } {
  set separator {}
  if [regexp -indices "\n-*\n" [$t get 0.0 end] separator] {
    set headerend [lindex $separator 0]
    $t tag add header 0.0 "0.0 + $headerend chars + 1 char"
  }
}

proc mode:exmh:pre_quit_hook { t } {
  global JEDIT_CALLER
  set filename [jedit:get_filename $t]
  set draft_id [file tail $filename]
  send $JEDIT_CALLER "EditDialog $draft_id"
}

######################################################################
# more procedures:

proc mode:exmh:border { t } {
  j:text:insert_string $t \
    "     * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\n"
}

# delete the signature if it exists (and is tagged so):

proc mode:exmh:delete_sig { t } {
  catch {
    $t delete sig.first end
  }
}

proc mode:exmh:insert_sig { t } {
  global env
  mode:exmh:delete_sig $t
  set end [$t index end]
  $t insert end "\n"
  $t insert end [exec cat $env(HOME)/.signature]
  $t insert end "\n"
  $t tag add sig $end end
}

proc mode:exmh:start_reply { t } {
  set reply [exec cat "@" | sed {1,/^$/d} | \
    sed {s/^>/  /} | sed {s/^/  /}]
  $t insert end $reply
}

proc mode:exmh:whom { t } {
  jedit:cmd:save $t
  set filename [jedit:get_filename $t]
  j:more -height 10 -width 60 -title "Recipients" \
    -text [exec whom -check $filename]
}

proc mode:exmh:to_body { t } {
  $t mark set insert end
  $t yview -pickplace insert
}

# BUG - doesn't handle multi-line headers.

proc mode:exmh:next_header { t } {
  if [$t compare header.last <= insert] {
    $t mark set insert 1.0
  }
  
  set headpart [$t get insert header.last]
  
  set regex [format {(^|%s)[A-Za-z-]*:[ %s]*} "\n" "\t"]
  if [regexp -indices -- $regex $headpart indices] {
    $t tag remove sel 1.0 end
    set valuestart [expr [lindex $indices 1] + 1]
    $t mark set hdrfrom "insert + $valuestart chars"
    $t tag add sel hdrfrom {hdrfrom lineend}
    $t mark set insert {hdrfrom lineend}
    $t yview -pickplace insert
  } else {
    # assume we're in the last header field, so jump to body
    mode:exmh:to_body $t
  }
}

######################################################################
# define the MH menu:
######################################################################

proc mode:exmh:mkmenu1 { menu t } {
  menubutton $menu -text {MH} -menu $menu.m
  
  menu $menu.m
  $menu.m add command -label {Start Reply} \
    -accelerator {[2]} -command "
    mode:exmh:start_reply $t
  "
  $menu.m add command -label {Sign Email} -command "
    mode:exmh:insert_sig $t
  "
  $menu.m add command -label {List Recipients} \
    -accelerator {[7]} -command "
    mode:exmh:whom $t
  "
  $menu.m add command -label {Insert Border} \
    -accelerator {[8]} -command "
    mode:exmh:border $t
  "
  $menu.m add command -label {Done} -command "
    jedit:cmd:done $t
  "
  
  bind $t <Meta-Key-2> "mode:exmh:start_reply $t"
  bind $t <Meta-Key-7> "mode:exmh:whom $t"
  bind $t <Meta-Key-8> "mode:exmh:border $t"
}

######################################################################
# define the button bar:
######################################################################

proc mode:exmh:mkbuttons { w t } {
  j:buttonbar $w -pady 2 -buttons [format {
    {done Done {jedit:cmd:done %s}}
    {border {* * *} {mode:exmh:border %s}}
    {whom Whom {mode:exmh:whom %s}}
    {sign Sign {mode:exmh:insert_sig %s}}
    {reply {@} {mode:exmh:start_reply %s}}
  } $t $t $t $t $t]
  return $w
}

