# jdoc-mode.tcl - mode for rich-text hypertext documents
######################################################################

proc mode:jdoc:init { t } {
  global JEDIT_MODEPREFS
  
  j:read_prefs -array JEDIT_MODEPREFS -prefix jdoc \
    -directory ~/.tk/jeditmodes -file jdoc-defaults {
    {textfont default}
    {textwidth 80}
    {textheight 24}
    {textwrap word}
    {sabbrev 0}
    {dabbrev 0}
    {autobreak 0}
    {autoindent 0}
    {savestate 0}
    {buttonbar 1}
    {menu,editor 1}
    {menu,file 1}
    {menu,edit 1}
    {menu,prefs 0}
    {menu,abbrev 1}
    {menu,filter 1}
    {menu,format 1}
    {menu,display 1}
    {menu,mode1 1}
    {menu,mode2 1}
    {menu,user 1}
  }

  $t tag bind jdoc:xref:link <Control-ButtonRelease-1> \
    {jdoc:x_link %W %x %y}
  $t tag bind jdoc:xref:manpage <Control-ButtonRelease-1> \
    {jdoc:x_manpage %W %x %y}
  $t tag configure jdoc:xref:link -underline 1
  $t tag configure jdoc:xref:manpage -underline 1
  
  # not marked in jdoc, but marked here so you get visual feedback
  # when you create it:
  $t tag configure jdoc:anchor:anchorname -background grey75 -bgstipple gray25
  
  #
  # OBSOLETE:
  #
  $t tag configure jdoc:xref:topic -underline 1 \
    -background grey75 -borderwidth 1 -relief raised
  $t tag configure jdoc:xref:section -underline 1 \
    -background grey75 -borderwidth 1 -relief raised
}

######################################################################
# save entire contents of text widget, including tags and marks
#   (overrides normal write procedure)
######################################################################

proc mode:jdoc:write { filename t } {
  j:tag:archive_text_widget $t $filename
}

######################################################################
# read in archive of text widget, including tags and marks
#   (overrides normal read procedure)
######################################################################

proc mode:jdoc:read { filename t } {
  jedit:font:roman $t				;# start tagging as roman
  if { ! [file exists $filename] } then {
    $t delete 1.0 end
    $t mark set insert 1.0
    jedit:set_label $t "$filename (new file)"
  } else {					;# file exists
    j:tag:restore_text_widget $t $filename
    global JEDIT_MODEPREFS
    if { ! $JEDIT_MODEPREFS(jdoc,savestate) } {
      $t tag remove sel 1.0 end
      $t mark set insert 1.0
      $t yview 1.0
    }
  }
}

######################################################################
# show tags at insert point (useful for seeing anchor names, etc.)
######################################################################
### THIS SHOULD BE ADDED TO BASE JEDIT FUNCTIONALITY

proc mode:jdoc:show_tags { t } {
  set tags [$t tag names insert]
  j:more -title "Current Tags" -width 40 -height 10 \
    -text [join [lsort $tags] "\n"]
}

######################################################################

proc mode:jdoc:mkx_anchor { t } {
  set from [$t index sel.first]
  set to [$t index sel.last]
  set anchor [string trim [$t get $from $to]]
  regsub -all -- {[ +-]} $anchor {_} anchor
  set anchor [j:prompt -title "Anchor Name" -text "Anchor name:" \
    -default $anchor]
  
  if {"x$anchor" == "x"} {
    return 1
  }
  
  foreach tag [list \
    jdoc:anchor:anchorname \
    jdoc:anchorname:$anchor \
  ] {
    j:tag:tag_text $t $tag $from $to
  }
  return 0
}

proc mode:jdoc:mkx_link { t } {
  set from [$t index sel.first]
  set to [$t index sel.last]
  set link "[string trim [$t get $from $to]].jdoc"
  regsub -all -- {[ +-]} $link {_} link
  set link [j:prompt -file 1 -title "Link Name" -text "Link to:" \
    -default $link -file 1]
  
  if {"x$link" == "x"} {
    return 1
  }
  
  foreach tag [list \
    jdoc:xref:link \
    jdoc:link:$link \
  ] {
    j:tag:tag_text $t $tag $from $to
  }
  return 0
}

proc mode:jdoc:mkx_anchor_link { t } {
  set from [$t index sel.first]
  set to [$t index sel.last]
  set link "#[string trim [$t get $from $to]]"
  regsub -all -- {[ +-]} $link {_} link
  set link [j:prompt -title "Link Name" -text "Link to:" \
    -default $link -file 1]
  
  if {"x$link" == "x"} {
    return 1
  }
  
  foreach tag [list \
    jdoc:xref:link \
    jdoc:link:$link \
  ] {
    j:tag:tag_text $t $tag $from $to
  }
  return 0
}

### proc mode:jdoc:mkx_topic { t } {
###   set from [$t index sel.first]
###   set to [$t index sel.last]
###   set topic [$t get $from $to]
###   
###   foreach tag [list \
###     jdoc:xref:topic \
###     jdoc:topic:$topic \
###     richtext:font:bold \
###   ] {
###     j:tag:tag_text $t $tag $from $to
###   }
### }
### 
### proc mode:jdoc:mkx_section { t } {
###   set from [$t index sel.first]
###   set to [$t index sel.last]
###   set section [$t get $from $to]
###   
###   foreach tag [list \
###     jdoc:xref:section \
###     jdoc:section:$section \
###     richtext:font:bolditalic \
###   ] {
###     j:tag:tag_text $t $tag $from $to
###   }
### }

proc mode:jdoc:mkx_manpage { t } {
  set from [$t index sel.first]
  set to [$t index sel.last]
  set manpage [string trim [$t get $from $to]]
  set manpage [j:prompt -title "Link Name" -text "Manual page:" \
    -default $manpage]
  
  if {"x$manpage" == "x"} {
    return 1
  }
  
  foreach tag [list \
    jdoc:xref:manpage \
    jdoc:manpage:$manpage \
    richtext:font:typewriter \
  ] {
    j:tag:tag_text $t $tag $from $to
  }
  return 0
}

######################################################################
# mode:jdoc:mksectionsmenu menu t - find all level 1 headings in text
######################################################################

proc mode:jdoc:mksectionsmenu { menu t } {
  set ranges [$t tag ranges richtext:font:heading1]
  set sections {}
  
  ;# step through ranges two-at-a-time (start and end)
  while { [llength $ranges] > 0 } {
    set start [lindex $ranges 0]
    set end [lindex $ranges 1]
    set ranges [lreplace $ranges 0 1]	;# with nothing, ie shift
    set section_name [string trim [$t get $start $end]]
    set section_name [lindex [split $section_name "\n"] 0]
    lappend sections [list $section_name $start]
  }
  
  $menu delete 0 last
  
  $menu add command -label "Top" -command \
    "$t mark set insert 1.0; $t yview -pickplace insert"
  $menu add separator
  foreach pair $sections {
    set section [lindex $pair 0]
    set location [lindex $pair 1]
    $menu add command -label $section \
      -command "$t mark set insert $location; $t yview insert"
  }
  $menu add separator
  $menu add command -label "Bottom" -command \
    "$t mark set insert end; $t yview -pickplace insert"
}

######################################################################

proc mode:jdoc:mkmenu1 { menu t } {
  menubutton $menu -text {jdoc} -menu $menu.m
  
  menu $menu.m
  $menu.m add command -label {Make Section Title} \
    -accelerator {[1]} \
    -command "jedit:font:heading1 $t"
  $menu.m add command -label {Make Subsection Heading} \
    -accelerator {[2]} \
    -command "jedit:font:heading2 $t"
  $menu.m add command -label {Make Subsubsection Heading} \
    -accelerator {[3]} \
    -command "jedit:font:heading2 $t"
  $menu.m add command -label {Make Overall Topic Title} \
    -command "jedit:font:heading0 $t"
  $menu.m add separator
  $menu.m add command -label {Show Tags at Insert . . .} \
    -accelerator {[5]} \
    -command "
      mode:jdoc:show_tags $t
    "
  $menu.m add separator
  $menu.m add command -label {Anchor Name . . .} \
    -accelerator {[6]} \
    -command "
      mode:jdoc:mkx_anchor $t
    "
  $menu.m add command -label {Local Cross Reference . . .} \
    -accelerator {[7]} \
    -command "
      mode:jdoc:mkx_anchor_link $t
    "
  $menu.m add command -label {Cross Reference . . .} \
    -accelerator {[8]} \
    -command "
      mode:jdoc:mkx_link $t
    "
  $menu.m add command -label {Man Page Reference . . .} \
    -accelerator {[9]} \
    -command "
      mode:jdoc:mkx_manpage $t
    "
  
  bind $t <Meta-Key-1> "jedit:font:heading1 $t"
  bind $t <Meta-Key-2> "jedit:font:heading2 $t"
  bind $t <Meta-Key-3> "jedit:font:heading3 $t"
  bind $t <Meta-Key-5> "mode:jdoc:show_tags $t"
  bind $t <Meta-Key-6> "mode:jdoc:mkx_anchor $t"
  bind $t <Meta-Key-7> "mode:jdoc:mkx_anchor_link $t"
  bind $t <Meta-Key-8> "mode:jdoc:mkx_link $t"
  bind $t <Meta-Key-9> "mode:jdoc:mkx_manpage $t"
}

proc mode:jdoc:mkmenu2 { menu t } {
  menubutton $menu -text {Sections} -menu $menu.m
  
  menu $menu.m -postcommand "mode:jdoc:mksectionsmenu $menu.m $t"
}
