/*
   NAME:     Colors
   AUTHOR:   Ole Gunnar Westgaard
   DATE:     Jul 28 1995
             
*/
#include "otools.h"
#include "macros.h"
#include "protos.h"

//=============================================================================
//  Color class functions
//=============================================================================

Color::Color()                  // Default constructor, leaves all colors black
{
  fg = 0;
  bg = 0;
  sd = 0;
  bd = 0;
  hl = 0;
  light = 0;
  dark = 0;
}

Color::Color(Color *c)                    // Copy allready existing Color class
{
  fg = c->fg;
  bg = c->bg;
  sd = c->sd;
  bd = c->bd;
  hl = c->hl;
  light = c->light;
  dark = c->dark;
}

Color::Color(char *a,char *b,char *c,char *d,char *e,char *f,char *g)
{
  bd    = o_AllocNamedColor(a);                            // Create new colors
  sd    = o_AllocNamedColor(b);
  bg    = o_AllocNamedColor(c);
  hl    = o_AllocNamedColor(d);
  fg    = o_AllocNamedColor(e);
  dark  = o_AllocNamedColor(f);
  light = o_AllocNamedColor(g);
}

void Color::Change(char *a,char *b,char *c,char *d,char *e,char *f,char *g)
{
  bd    = o_AllocNamedColor(a);                            // Create new colors
  sd    = o_AllocNamedColor(b);
  bg    = o_AllocNamedColor(c);
  hl    = o_AllocNamedColor(d);
  fg    = o_AllocNamedColor(e);
  dark  = o_AllocNamedColor(f);
  light = o_AllocNamedColor(g);
}

void Color::Skrive()
{
  printf("Color: %ld %ld %ld %ld %ld %ld %ld\n",fg,bg,sd,hl,bd,light,dark);
}

