/*
   File:   smp.c
   Author: Ole Gunnar Westgaard 
           root@ogware.oslo.no
           Copyright (c) May 1995.  All Rights Reserved.
*/
#include "otools.h"
#include "colors.h"
#include "protos.h"

#define SIZE 10
Figlet f[SIZE],b[SIZE],q,title,mutl,mutr,b1,b2;
Color  *c,*d;

void Quit(Figlet *f,int x,int y) { o_running = 0; }

int main(int argc,char *argv[])
{
  Color *c;
  int    t;
  
  o_Init("Figlet example #1","figex","7x13bold",
         100,100,400,300,160,120,640,480,C_GRAY,
	 argc,argv);

  c = new Color(C_RED);
  d = new Color(C_PEACH);

  o_draw = new Chain();

  for (t=0; t<SIZE; t++) {
    o_draw->Add(new Slider(0,0,0,0,IN,c,t,"slider",FANCY,X,10,NULL,0.5));
    o_draw->Add(new Button(0,0,0,0,IN,d,t,"value",CLICK,OUT,NULL));
  }
  o_draw->Stack(5,45,xMax-5,yMax-54,2,0,4,4);
  o_test = o_draw;

  o_draw->Add(new Figlet(5,5,xMax-5,35,DOUBLE,&o_color,50,"Equalizer"));
  o_draw->Add(new Button(5,yMax-45,80,yMax-5,SINGLE,&o_color,51,"Quit",
			 CLICK,OUT,Quit));
  o_draw->Add(new Switch(90,yMax-45,190,yMax-27,SINGLE,&o_color,52,"Mute left",
			 DIAMOND,OUT,8,NULL));
  o_draw->Add(new Switch(90,yMax-23,190,yMax-5,SINGLE,&o_color,53,"Mute right",
			 DIAMOND,OUT,8,NULL));
  o_draw->Add(new Slider(200,yMax-45,xMax-5,yMax-27,SINGLE,&o_color,54,"left",
			 BAR,X,10,NULL,0.4));
  o_draw->Add(new Slider(200,yMax-23,xMax-5,yMax-5,SINGLE,&o_color,54,"right",
			 BAR,X,10,NULL,0.3));

  o_EnterLoop();
  o_Quit();
}
