/*
   NAME:     p02
   AUTHOR:   Ole Gunnar Westgaard <olew@maud.ifi.uio.no>
   DATE:     Aug  9 1995
             Example program #2
*/

#include "otools.h"  // class declarations and defines
#include "colors.h"  // color defines
#include "macros.h"  // Macros to draw in your window
#include "protos.h"  // Declaration of procedures and variables in Otools

//-----------------------------------------------------------------------------
// Callback function that can be used with buttons in otools.
// When a button is pressed, this routine will be called, with a pointer
// To the button, and where (x,y) the mousepointer is right now.
//
void Quit(Button *b,int x,int y)
{
  // To quit, set o_running to zero, o_EnterLoop(); will then exit;
  o_running = 0;
}

//-----------------------------------------------------------------------------
// Main routine of the application, used to initialize and set up the window
//
int main(int argc,char *argv[])
{
  // Start the X window with this sentence
  o_Init("My window","My icon","7x13bold",50,50,320,240,160,120,640,480,
	 C_GRAY,argc,argv);

  // Create a new chain for drawing in the window
  o_draw = new Chain();

  // Add a title to the application
  // 10,10,xMax-10,60 - coordinates for Button (xMax,yMax - size of window)
  // DOUBLE           - choose NONE,SINGLE,DOUBLE,IN,OUT,HEXAGON,SHADOW border
  // &o_color         - Color class, this time the applications own
  // 0                - Internal value of program
  // "My program"     - The title of the Button
  o_draw->Add( new Figlet(10,10,xMax-10,60,DOUBLE,&o_color,0,"My program") );

  // Add a Quit button to the application
  // 'Add' a 'new Button' to 'o_draw'
  // Parameters: (Figlet params,type,state,callback)
  // type                    - should it be CLICK'ed or HOLD
  // state                   - should it point IN or OUT initially
  // callback                - Function to call when clicked or held
  o_draw->Add(new Button(10,70,xMax-10,110,SINGLE,&o_color,0,"Quit",
			 CLICK,OUT,Quit));

  // Tell the application to test for everything in the draw chain
  o_test = o_draw;

  // Start loop that gets information about actions in the application
  o_EnterLoop();

  // Stop the application now
  o_Quit();
}

