/* VGAlib version 1.2 - (c) 1993 Tommy Frandsen 		   */
/*								   */
/* This library is free software; you can redistribute it and/or   */
/* modify it without any restrictions. This library is distributed */
/* in the hope that it will be useful, but without any warranty.   */

/* Multi-chipset support Copyright (c) 1993 Harm Hanemaayer */
/* partially copyrighted (C) 1993 by Hartmut Schirmer */

#ifndef _DRIVER_H
#define _DRIVER_H

#include <stdio.h>
#include "libvga.h"
#include "timing.h"
#include "accel.h"

#define MAX_REGS 269

typedef struct {
/* Basic functions. */
	int (*saveregs)();
	void (*setregs)();
	void (*unlock)();
	void (*lock)();
	int (*test)();
	int (*init)();
	void (*setpage)();
	void (*setrdpage)();
	void (*setwrpage)();
	int (*setmode)();
	int (*modeavailable)();
	void (*setdisplaystart)();
	void (*setlogicalwidth)();
	void (*getmodeinfo)();
/* Obsolete blit functions. */
	void (*bitblt)();
	void (*imageblt)();
	void (*fillblt)(); 
	void (*hlinelistblt)();
	void (*bltwait)();
/* Other functions. */
	int (*ext_set)();
	int (*accel)();
	int (*linear)();
	AccelSpecs *accelspecs;
} DriverSpecs;

extern DriverSpecs vga_driverspecs;
extern DriverSpecs cirrus_driverspecs;
extern DriverSpecs et4000_driverspecs;
extern DriverSpecs tvga8900_driverspecs;
extern DriverSpecs oak_driverspecs;
extern DriverSpecs ega_driverspecs;
extern DriverSpecs s3_driverspecs;
extern DriverSpecs mach32_driverspecs;
extern DriverSpecs et3000_driverspecs;
extern DriverSpecs gvga6400_driverspecs;
extern DriverSpecs ark_driverspecs;
extern DriverSpecs ati_driverspecs;

extern DriverSpecs *driverspecs;
extern DriverSpecs *driverspecslist[];

enum { 
	CHIPSET_SAVEREGS = 0, CHIPSET_SETREGS, CHIPSET_UNLOCK, CHIPSET_LOCK,
	CHIPSET_TEST, CHIPSET_INIT, CHIPSET_SETPAGE, CHIPSET_SETRDPAGE,
	CHIPSET_SETWRPAGE, CHIPSET_SETMODE,
	CHIPSET_MODEAVAILABLE, CHIPSET_SETDISPLAYSTART,
	CHIPSET_SETLOGICALWIDTH, CHIPSET_GETMODEINFO,
	CHIPSET_BITBLT, CHIPSET_IMAGEBLT, CHIPSET_FILLBLT,
	CHIPSET_HLINELISTBLT, CHIPSET_BLTWAIT,
	CHIPSET_EXT_SET, CHIPSET_ACCEL, CHIPSET_LINEAR
};

enum {
	LINEAR_QUERY_BASE, LINEAR_QUERY_GRANULARITY, LINEAR_QUERY_RANGE,
	LINEAR_ENABLE, LINEAR_DISABLE
};

extern int CRT_I;
extern int CRT_D;
extern int IS1_R;
extern int __svgalib_driver_report;	/* driverreport */
extern int __svgalib_videomemoryused;	/* videomemoryused */
extern int __svgalib_critical;
extern int __svgalib_chipset;
extern int __svgalib_monitortype;
extern int __svgalib_grayscale;
extern int __svgalib_modeinfo_linearset;
extern const int __svgalib_max_modes;

void __svgalib_read_options(char **commands, char *(*func)(int ind,int mode));

/* ----------------------------------------------------------------------
** A modetable holds a pair of values 
** for each mode :
**
**    <mode number> <pointer to registers>
**
** the last entry is marked by 
**  
**    <any number>  <NULL>
*/

typedef struct {
   unsigned short mode_number;
   const unsigned char  *regs;
} ModeTable;

#define DISABLE_MODE	  ((unsigned char *)1)
#define OneModeEntry(res) {G##res,g##res##_regs}
#define DisableEntry(res) {G##res,DISABLE_MODE}
#define END_OF_MODE_TABLE { 0, NULL }

extern const unsigned char *__vga_mode_in_table(const ModeTable *modes, int mode);
#define LOOKUPMODE __vga_mode_in_table

/* ---------------------------------------------------------------------- */

extern int __vga_hicolor(int dac_type, int mode);
/* Enters hicolor mode - 0 for no hi, 1 for 15 bit, 2 for 16, 3 for 24 */
/* For any modes it doesn't know about, etc, it attempts to turn hicolor off. */


#define STD_DAC		0
#define HI15_DAC	1
#define HI16_DAC	2
#define TC24_DAC	3

/* ----------------------------------------------------------------------
** regextr.h  -  extract graphics modes and register information
**               from C source file
*/

extern void __vga_readmodes(FILE *inp, ModeTable **modes, int *dac, unsigned *clocks);

#endif


