#include <curses.h>

/*
 *	make sure we are getting an ASCII character - top bit 0
 *
 *	if not - call non_ascii() to warn, strip parity bit and
 *		contine.
 *
 *      for some reason, linux seems to mess this up, resulting
 *      in an odd looking display.  We only want nonl() mode on
 *      when we are reading in characters.  This happens on my
 *      version of Linux and ncurses.  I don't know if it will
 *      happen on anyone elses.
 */

#ifdef BROKEN_CURSES
#define GETCH7(ch) {nonl(); \
	ch = getch(); \
	if( (ch & 0x80) != 0 ) { non_ascii(); ch = (ch & 0x7f);} \
	nl(); }
#else /* BROKEN_CURSES */
#define GETCH7(ch) {ch = getch(); \
	if( (ch & 0x80) != 0 ) { non_ascii(); ch = (ch & 0x7f);} }
#endif /* NOT BROKEN_CURSES */
