
/*
 * Copyright 1993, 1994, 1995 by the Regents of the University of California
 * see the file "Copyright" in the distribution for conditions of use.
 */

#ifdef ultrix
#include <sys/ttyio.h>
#endif
#include <sys/ioctl.h>

#ifdef POSIX
#include <termios.h>
#include <unistd.h>
#endif /* POSIX */

#ifdef POSIX
static struct termios ltc;
static cc_t save_susp;
static cc_t save_dsusp;
#else /* POSIX */
static char save_susp;
static char save_dsusp;
static struct ltchars ltc;
#endif /* NOT POSIX */

/*
 *	undefine_suspend() undefines the suspend and dsuspend characters,
 *		first saving the previous values.
 *	restore_suspend() restores the previously saved values
 *
 *	reason:  if we directly call gopher, etc, don't want people
 *		to suspend the gopher & end up in never-never land.
 */

undefine_suspend()
{
#ifdef POSIX
	long vdisable;
	tcgetattr(1, &ltc);
	if ( (vdisable = fpathconf(STDIN_FILENO, _PC_VDISABLE)) < 0)
	{
		fprintf(STDERR_FILENO, 
                        "_POSIX_VDISABLE not in effect or fpathconf error\n");
		vdisable = 0;
	}
	save_susp  = ltc.c_cc[VSUSP];
	ltc.c_cc[VSUSP] = vdisable;
	tcsetattr(1, TCSANOW, &ltc);
#else /* POSIX */
	ioctl(1, TIOCGLTC, &ltc);
	save_susp  = ltc.t_suspc;
	save_dsusp = ltc.t_dsuspc;
	ltc.t_suspc  = 0377;
	ltc.t_dsuspc = 0377;
	ioctl(1, TIOCSLTC, &ltc);
#endif /* NOT POSIX */
}

restore_suspend()
{
#ifdef POSIX
	tcgetattr(1, &ltc);
	ltc.c_cc[VSUSP] = save_susp;
	tcsetattr(1, TCSANOW, &ltc);
#else /* POSIX */
	ioctl(1, TIOCGLTC, &ltc);
	ltc.t_suspc  = save_susp;
	ltc.t_dsuspc = save_dsusp;
	ioctl(1, TIOCSLTC, &ltc);
#endif /* NOT POSIX */
}
