/* $Id: eject.c,v 1.1 1995/01/27 22:30:35 root Rel $
 * VERSION: 048
 *
 * This program is free.
 *
 */
#include <stdio.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <linux/cdrom.h>

const char* DEV = "/dev/cdrom";
const int BAD = 1;
const int GOOD = 0;

int main(int argc, char** argv)
{
	int fd;
	const char* dev;

	dev = argc > 1 ? argv[1] : DEV;

	if (-1 == (fd = open(dev, O_RDONLY))) {
		perror(argv[0]);
		exit(BAD);
	}

	if (-1 == ioctl(fd, CDROMEJECT, NULL)) {
		perror(argv[0]);
		exit(BAD);
	}

	return GOOD;
}
