/*
 * Definitions for the Mitsumi CDROM interface
 * Copyright (C) 1995 Heiko Schlittermann
 * $Id: mcd.h,v 1.6 1995/01/28 02:27:25 root Rel $
 * VERSION: 048
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Thanks to
 *  The Linux Community at all and ...
 *	Martin Harris (he wrote the first Mitsumi Driver)
 *  Eberhard Moenkeberg (he gave me much support)
 *  Bernd Huebner, Ruediger Helsch (Unifix-Software Gmbh, they
 *		rewrote the original driver)
 *  John Tombs, Bjorn Ekwall (module support)
 *  Daniel v. Mosnenck (he sent me the Technical and Programming Reference)
 *  ... somebody forgotten?
 *  
 */

/*
 *	The following lines are for user configuration
 *	~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 *
 *	{0|1} -- 1 if you want the driver detect your drive, may crash and
 *	needs a long time to seek.  The higher the address the longer the
 *	seek.
 *
 *  WARNING: AUTOPROBE doesn't work.
 */
#define MCD_AUTOPROBE 0

/*
 *	Drive specific settings according to the jumpers on the controller
 *	board(s).
 *	o	MCD_NDRIVES  :  umber of used entries of the following table
 *	o	MCD_DRIVEMAP :  table of {minor, i/o base, irq} per controller
 *
 *	NOTE: I didn't get a drive at irq 9(2) working.  Not even alone.
 */
#if MCD_AUTOPROBE == 0
	#define MCD_NDRIVES 1
	#define MCD_DRIVEMAP {		\
			{0, 0x300, 11},		\
			{1, 0x304, 05},  	\
	  	}
#else
	#error Autoprobing is not implemented yet.
#endif

/*	The name of the device */
#define MCD "mcd"	

#define MCD_DEBUG_INIT 0
#define MCD_DEBUG_TALK 0 
#define MCD_DEBUG_OPENCLOSE 0
#define MCD_DEBUG_TRANSFER 0
#define MCD_DEBUG_IRQ 0
#define MCD_DEBUG_IOCTL 0
#define MCD_DEBUG_REQUEST 0

/*	The following addresses are taken from the Mitsumi Reference 
 *  and describe the possible i/o range for the controller.
 */
#define MCD_IO_BEGIN	((char*) 0x300)	/* first base of i/o addr */
#define MCD_IO_END		((char*) 0x3fc)	/* last base of i/o addr */

/*	Per controller 4 bytes i/o are needed. */
#define MCD_IO_SIZE		4

/*
 *	The Ports & bits
 */

#define MCD_RREG_DATA	((unsigned long) (stuff->port + 0))
#	define MCD_RBIT_OPEN	0x80
#	define MCD_RBIT_DISKSET	0x40
#	define MCD_RBIT_CHANGED	0x20
#	define MCD_RBIT_CHECK	0x10
#	define MCD_RBIT_AUDIOTR	0x08
#	define MCD_RBIT_RDERR	0x04
#	define MCD_RBIT_AUDIOBS 0x02
#	define MCD_RBIT_CMDERR	0x01
#define MCD_RREG_STATUS	((unsigned long) (stuff->port + 1))
#	define MCD_RBIT_DOOR	0x10
#	define MCD_RBIT_STEN	0x04
#	define MCD_RBIT_DTEN	0x02

#define MCD_WREG_DATA	((unsigned long) (stuff->port + 0))
#define MCD_WREG_RESET	((unsigned long) (stuff->port + 1))
#define MCD_WREG_HCON	((unsigned long) (stuff->port + 2))
#define MCD_WREG_CHN	((unsigned long) (stuff->port + 3))


/*
 *	The commands.
 */

#define OPCODE						1		/* offset of opcode */
#define MCD_CMD_REQUEST_TOC			1, 0x10
#define MCD_CMD_REQUEST_MULTI		1, 0x11
#define MCD_CMD_REQUEST_STATUS		1, 0x40 
#define MCD_CMD_RESET				1, 0x60
#define MCD_CMD_REQUEST_DRIVE_MODE	1, 0xc2
#define MCD_CMD_MODE_SET			2, 0x50, 0
	#define MCD_TEST				0x80
	#define MCD_RAW					0x40
	#define MCD_ECC					0x20
	#define MCD_SERVO				0x08
	#define MCD_TOC					0x04
	#define MCD_MUTE_CONTROL		0x01
#define MCD_CMD_SET_INTERLEAVE		2, 0xc8, 0
#define MCD_CMD_CONFIG				4, 0x90, 0, 0, 0
	#define MCD_DMASEL				0x02
	#define MCD_IRQEN				0x10
#define MCD_CMD_DATAMODE_SET		2, 0xa0, 0
	#define MCD_DATAMODE1			0x01
	#define MCD_DATAMODE2			0x02
#define MCD_CMD_LOCKDOOR			2, 0xfe, 0
#define MCD_CMD_EJECT				1, 0xf6
#define MCD_CMD_CLOSE				1, 0xf8

#define MCD_BLNG				0x01
#define MCD_UPCR				0x04
#define MCD_TMOUT				0x08
#define MCD_SREAD				0xc0
#define MCD_DREAD				0xc1
#define MCD_CMD_REQUEST_VERSION		1, 0xdc

#define READ_AHEAD				4	/* 8 Sectors (4K) */

/*	Useful macros */
#define e_door(x)		((x) & MCD_RBIT_OPEN)
#define e_check(x)		(~(x) & MCD_RBIT_CHECK)
#define e_notset(x)		(~(x) & MCD_RBIT_DISKSET)
#define e_changed(x)	((x) & MCD_RBIT_CHANGED)
#define e_audio(x)		((x) & MCD_RBIT_AUDIOTR)
#define e_audiobusy(x)	((x) & MCD_RBIT_AUDIOBS)
#define e_cmderr(x)		((x) & MCD_RBIT_CMDERR)
#define e_readerr(x)	((x) & MCD_RBIT_RDERR)

/**	no drive specific */
#define MCD_CDBLK				2048	/* 2048 cooked data each blk */

#define MCD_DATA_TIMEOUT		10		/* jiffies */

/*
 * Access to the msf array
 */
#define MSF_MIN		0			/* minute */
#define MSF_SEC		1			/* second */
#define MSF_FRM		2			/* frame  */

/*
 * Errors
 */
#define MCD_E		1			/* unspec error */
#define MCD_EOM		2			/* end of media */
