# No_idle.S disables powersave function of harddisk
# Converted from dos version by Tomi Leppikangas, tomilepp@paju.oulu.fi
# 6.9.1994

#.text
#.data
#.bss

#.align 4

.globl _no_idle1              # for ld86
_no_idle1:
	call is_busy	# call the instruction at location 120xxxx:0103 
	mov $0x1f6, %dx	# select the drive/head
	mov $0xb0, %al	# (a0) setup for drive 0 (b0 for drive 1)
	out %al, %dx	# output to the port address
	call is_busy	# wait while busy
	mov $0x1f2, %dx	# select the sector count/timer register
	mov $0, %al	# set it to 0 msecs
	out %al, %dx	# output to the port address
	call is_busy	# wait while busy
	mov $0x1f7, %dx	# select the drive command register
	mov $0xfb, %al	# setup the Active/Set Idle command
	out %al, %dx	# output to the port address
	call is_busy	# wait while busy
	nop		# no operation (slight pause)
	nop
is_busy:
	mov $0x1f7, %dx	# select the status register
	in  %dx, %al	# input from the port
	and $0x80, %al	# isolate the busy bit
	jnz is_busy	# jump if not zero to location 120
	nop
	ret		# return (finished)

