/******************************************************************************
 * --- bt_config.h --- Copyright (C) 1994 by Thomas Weidenfeller
 *
 * File ID:
 *	$Id: bt_config.h,v 1.4 1994/10/27 19:27:39 root Exp $
 *
 * Purpose:
 *	Configurable parameters for the BiTronics parallel printer
 *	port driver.
 *
 * Copyright:
 *	Copyright (C) 1994 by T. Weidenfeller. All rights reserved
 *	
 *	You are free to copy, modify and distribute this software as you
 *	see fit, and to use it for any purpose, provided this copyright
 *	notice and the warranty disclaimer are included without any
 *	modification in all copies and modifications. You have to mark all
 *	modifications clearly and you are also commited to give propper
 *	acknowledgment of the original source if you include this software
 *	or parts of it in another software.
 *	
 * Warranty:
 *	The BiTronics device driver and the accompaning material is a free
 *	sample of no commercial value. It comes without any warranty:
 *	
 *	THERE IS NO WARRANTY OF ANY KIND WITH REGARDS TO THIS MATERIAL,
 *	INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *	MECHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. The author
 *	shall not be liable for errors contained in the material or for
 *	incidental or consequental damage in connection with the
 *	furnishing, performance, or use of this material.
 *	
 * Revisions: $Log: bt_config.h,v $
 *	Revision 1.4  1994/10/27  19:27:39  root
 *	Release configuration set.
 *
 *	Revision 1.3  1994/10/26  18:23:46  root
 *	General harmonisation (prep 1. ALPHA release).
 *
 * Revision 1.2  1994/10/23  19:37:43  root
 * Minor changes
 *
 * Revision 1.1  1994/10/19  19:11:53  root
 * Initial revision
 *
 *****************************************************************************/
#ifndef BT_CONFIG_H_
#define BT_CONFIG_H_

/*
 * how the driver identifies itselfe in printouts
 */
#define BT_DRIVER_NAME	"bt"


/*
 * define BT_TRACE if you want a tracing facility for debugging
 */
/* #define BT_TRACE */


/*
 * define BT_STAT_DUMP if you want some printer status dumps for debugging
 */
/* #define BT_STAT_DUMP */


/*
 * define BT_COOPERATE_WITH_LP if you want that the bt driver is aware of
 * an additional normal lp parallel printer driver
 * NOTE: untested, unsave, not recommendet
 */
/* #define BT_COOPERATE_WITH_LP */


/*
 * number of retrys if no read data available or read failed due to a
 * signalling error
 */
#define BT_READ_RETRYS	(3)


/******************************************************************************
 * Timer and delay values used
 * NOTE: unfortunately they don't use a common unit of measurement!
 *****************************************************************************/

#define BT_STD_DELAY	(500)	/* wait 500us before probe readback	*/

/*
 * define only if you want/need a delay before and after strobe
 */
/* #define BT_STROBE_DELAY	(1) */	/* wait 1us before and after strobe	*/

/* standard timeout used while waiting for a printer status (in 10ms) 	*/
#define BT_STD_TIMEOUT	(15)	/* 15 * 10ms = 150ms */

/* standard scheduling timeout (in 10ms)				*/
#define BT_SCHED_TIMEOUT (2)	/* 20ms */

/*
 * Timeout used during non-error read retries
 * (total time spen in read() is approx. BT_READ_RETRIES * BT_TO_RDOK)
 */
#define BT_TO_RDOK	(4)		/* 40 ms	*/

/*
 * Timeout used during error read reties
 * (total time spen in read() is approx. BT_READ_RETRIES * BT_TO_RDERR)
 */
#define BT_TO_RDERR	(10 * HZ)	/* 10 sec.	*/


/*
 * Printer was busy
 */
#define BT_TO_WRBUSY (2)		/* 20ms */

/*
 *  Timeout used during write retries
 */
#define BT_TO_WRERR	(10 * HZ)	/* 10 sec.	*/


#endif
