/******************************************************************************
 * --- bt_error.h --- Copyright (C) 1994 by Thomas Weidenfeller
 *
 * File ID:
 *	$Id: bt_error.h,v 1.2 1994/10/26 18:23:46 root Exp $
 *
 * Purpose:
 *	Macro-Style definitions of error codes and error messages for
 *	multiple inclusion in the BiTronics device driver source.
 *	
 * Copyright:
 *	Copyright (C) 1994 by T. Weidenfeller. All rights reserved
 *	
 *	You are free to copy, modify and distribute this software as you
 *	see fit, and to use it for any purpose, provided this copyright
 *	notice and the warranty disclaimer are included without any
 *	modification in all copies and modifications. You have to mark all
 *	modifications clearly and you are also commited to give propper
 *	acknowledgment of the original source if you include this software
 *	or parts of it in another software.
 *	
 * Warranty:
 *	The BiTronics device driver and the accompaning material is a free
 *	sample of no commercial value. It comes without any warranty:
 *	
 *	THERE IS NO WARRANTY OF ANY KIND WITH REGARDS TO THIS MATERIAL,
 *	INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *	MECHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. The author
 *	shall not be liable for errors contained in the material or for
 *	incidental or consequental damage in connection with the
 *	furnishing, performance, or use of this material.
 *	
 * Revisions: $Log: bt_error.h,v $
 *	Revision 1.2  1994/10/26  18:23:46  root
 *	General harmonisation (prep 1. ALPHA release).
 *
 * Revision 1.1  1994/10/23  19:37:43  root
 * Initial revision
 *
 *****************************************************************************/

/*
 * Error Messages and error values
 * NOTE: They are defined in a way that the old macro inclusion trick works...
 */
#ifdef BTERROR
BTERROR(BT_NO_ERROR,		"No error"),
BTERROR(BT_WRITE_TIMEOUT,	"Timeout during write"),
BTERROR(BT_WRITE_READY,		"Printer not ready for receiving data"),
BTERROR(BT_FROM_IDLE,		"Read failed from idle port"),
BTERROR(BT_START_NIBBLE_1,	"Detection of 1st nibble start failed during read"),
BTERROR(BT_END_NIBBLE_1,	"Detection of 1st nibble end failed during read"),
BTERROR(BT_START_NIBBLE_2,	"Detection of 2nd nibble start failed during read"),
BTERROR(BT_END_NIBBLE_2,	"Detection of 2nd nibble end failed during read"),
BTERROR(BT_PERROR_SYNC,		"PError not synchronized with nFault (required for input data)"),
BTERROR(BT_NOT_BT_DEVICE,	"No response to negotiation (no BiTronics printer?)"),
BTERROR(BT_END_NEGOTIATE,	"Failed to end BiTronics negogiation"),
BTERROR(BT_START_TERMINATE,	"Failed to start BiTronics termination"),
BTERROR(BT_END_TERMINATE,	"Failed to end BiTronics termination"),
BTERROR(BT_UNSUPPORTED_MODE,	"Specific BiTronics mode not supported (only nibble mode is supported)"),
BTERROR(BT_ID_TIMEOUT,		"Timeout during read of ID"),
BTERROR(BT_UNKNOWN_ERR,		"internal error"),
#undef BTERROR
#endif
