/* das1200.h, M. Welsh (mdw@cs.cornell.edu)
 * Definitions for Linux DAS-1200 kernel module.
 *
 * (c)1995 M. Welsh
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#ifndef _LINUX_DAS1200_H
#define _LINUX_DAS1200_H

#include <linux/ioctl.h>

/* Used with DAS12000_IO_{SET,GET}CHAN ioctl calls */
struct das1200_chan {
  int das_schan;   /* Start channel for conversion */
  int das_echan;   /* End channel for conversion */
};

/* Set channel start/end */
#define DAS1200_IO_SETCHAN	_IOW('d', 1, struct das1200_chan)
/* Get channel start/end */
#define DAS1200_IO_GETCHAN	_IOR('d', 2, struct das1200_chan)

/* Set digitial I/O pins */
#define DAS1200_IO_SETDIO	_IOW('d', 3, unsigned char)
/* Get digital I/O pins */
#define DAS1200_IO_GETDIO	_IOR('d', 4, unsigned char)
/* Read STATUSA register */
#define DAS1200_IO_STATUSA	_IOR('d', 5, unsigned char)
/* Read STATUSB register */
#define DAS1200_IO_STATUSB	_IOR('d', 6, unsigned char)

/* Define the following for your system */
#define DAS1200_MAJOR 31                /* Device major number */
#define DAS1200_BASE 0x300              /* I/O base address of card */
#define DAS1200_IRQ 5                   /* IRQ of card */
#define DAS1200_DMA 3                   /* DMA channel of card */

/* Must be at least one page */
#define DAS1200_DMABUF_SIZE PAGE_SIZE   /* Size of DMA buffer */

/* Port settings */
#define DAS1200_AD0 (DAS1200_BASE)
#define DAS1200_AD1 (DAS1200_BASE+0x01)
#define DAS1200_MUX (DAS1200_BASE+0x02)
#define DAS1200_DIO (DAS1200_BASE+0x03)
#define DAS1200_STATUSA (DAS1200_BASE+0x08)
#define DAS1200_CTRL (DAS1200_BASE+0x09)
#define DAS1200_CNTEN (DAS1200_BASE+0x0a)
#define DAS1200_GAIN (DAS1200_BASE+0x0b)
#define DAS1200_TIMER0 (DAS1200_BASE+0x0c)
#define DAS1200_TIMER1 (DAS1200_BASE+0x0d)
#define DAS1200_TIMER2 (DAS1200_BASE+0x0e)
#define DAS1200_TIMER3 (DAS1200_BASE+0x0f)
#define DAS1200_TIMERCTL (DAS1200_BASE+0x400)
#define DAS1200_PIOPA (DAS1200_BASE+0x401)
#define DAS1200_PIOPB (DAS1200_BASE+0x402)
#define DAS1200_PIOPC (DAS1200_BASE+0x403)
#define DAS1200_DISARM (DAS1200_BASE+0x404)
#define DAS1200_BMDEN (DAS1200_BASE+0x405)
#define DAS1200_1600MDEN (DAS1200_BASE+0x406)
#define DAS1200_STATUSB (DAS1200_BASE+0x407)

#endif /* _LINUX_DAS1200_H */
