/* dasgraph.c, M. Welsh (mdw@cs.cornell.edu)
 * Simple program to read samples from DAS1200 board, pick out one 
 * A/D channel, and display samples as voltage. Send the output of
 * this program to 'gnuplot' to see results visually. 
 *
 * (c)1995 M. Welsh
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>

void main(void) {

  unsigned char buf[32];
  int fd;
  int c, n = 0;
  int count; 
  double voltage;

  /* Open board */
  fd = open("/dev/das1200",O_RDONLY);
  if (fd < 0) {
	perror("open");
	exit(-1);
  }

  while (1) {

     /* Read 16 samples at a time from the card */
     c = read(fd,buf,32);
     if (c != 32) {
       perror("read");
       exit(-1);
     }

     /* Convert to volts; this calculation is described in
      * the Keithley DAS1200 manual. Here, the board voltage
      * range is assumed to be +/- 5V. If you reset the gain
      * (and recalibrate the board!) this will change.
      */

     /* N.B. Here we pick out the first sample returned by the 
      * card, regardless of which channel this corresponds to.
      * A simple modification could loop over samples and pick
      * out a particular channel... I'm just lazy. */

     count = (((buf[0]&0xf0) >> 4) | (buf[1] << 4));
     voltage = (count - 2048) * (10.0) / 4096.0;
     printf("%d %lf\n",n++,voltage);

  }

}
