/*
 * Copyright (C) 1995 Lars Fenneberg
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
 
#include <stdlib.h>
#include <pwd.h>
#include <stdlib.h>
#include <signal.h>
#include <getopt.h>
#include <ctype.h>
#include <sys/socket.h>
#include "ipquota.h"
#include "pathnames.h"

int skfd = -1;

void usage(void)
{
	fprintf(stderr,"Usage: %s [-vhs] <username/uid> <quota>\n", pname);
	exit(1);
}

void catch_sig(int sig)
{
	close_database(_PATH_VAR_LOG_QUOTA_STATS);
	log("terminating (signal %i)", sig);
	exit(1);
}

void main (int argc,char **argv) {

	signed long quota;
	signed long mul = 1;
	struct passwd *pwd = NULL;
  	extern int optind; 
  	extern char *optarg;
  	char *lc;
  	int c;
  	int set = 0;
  	int do_all = 0;

	use_syslog = 0;
 	pname = argv[0];

	signal(SIGINT, catch_sig);
	signal(SIGTERM, catch_sig);
	signal(SIGQUIT, catch_sig);
	signal(SIGHUP, catch_sig);

  	while ((c = getopt(argc,argv,"vhs")) > 0) 
  	{
  		switch (c)
  		{
			case 'v':
					version();
					break;
			case 's':
					set++;
					break;
  			case 'h':
  			default:
  					usage();
  					break; /* never reached */
  		}
  	}
	
	if ((argc-optind)==2) {
		if (!(do_all = (strcmp(argv[optind],"everyone") == 0))
			&& ((pwd = getpwnam(argv[optind])) == NULL) 
			&& ((pwd = getpwuid(atoi(argv[optind]))) == NULL)) 
		{
			log("no such user/uid: %s", argv[optind]);
			exit(1);
		}

		lc = argv[optind+1]+strlen(argv[optind+1])-1;

		if (!isdigit(*lc))
		{
			if (*lc=='b') mul = 1;
			else if (*lc=='k') mul = 1024;
			else if (*lc=='m') mul = 1024*1024;
			else {
				log("malformed second argument: %s", argv[optind+1]);
				exit(1);
			}
			*lc = '\0';
		}
	
		quota = strtol(argv[optind+1], &lc, 0) * mul;

		if (*lc!='\0')
		{
			log("malformed second argument: %s", argv[optind+1]);
			exit(1);
		}			
		
        	if ((skfd = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
                {
                	log(my_perror("can't create socket"));
                        exit (1);
                }

		init_hash();
		init_database(_PATH_VAR_LOG_QUOTA_STATS);
		
		if (do_all)
			change_all(quota, set);
		else if (exist_user(pwd->pw_uid))
			change_user(pwd->pw_uid, quota, set);
		else
			(void)add_user(pwd->pw_uid, quota, /* no flags*/ 0);

		ctrl_access_all();
		close_database(_PATH_VAR_LOG_QUOTA_STATS);
		if (pwd) free(pwd);
		close(skfd);		
	} else {
		usage();
	}
}
