#define NRML_ESDI_ID 0xddff
#define INTG_ESDI_ID 0xdf9f

#define ESDI_CMD_INT 0x3510
#define ESDI_STT_INT 0x3510
#define ESDI_CONTROL 0x3512
#define ESDI_STATUS  0x3512
#define ESDI_ATTN    0x3513
#define ESDI_INTRPT  0x3513

#define STATUS_ENABLED    0x01
#define STATUS_ALTERNATE  0x02
#define STATUS_BUSY       0x10
#define STATUS_INTR       0x01
#define STATUS_RESET_FAIL 0xea
#define STATUS_CMD_INF	  0x04

#define CTRL_SOFT_RESET   0xe4
#define CTRL_HARD_RESET   0x80
#define CTRL_EOI          0xe2
#define CTRL_ENABLE_DMA   0x02
#define CTRL_ENABLE_INTR  0x01

#define PORT_SYS_A   0x92
#define PORT_DMA_FN  0x18
#define PORT_DMA_EX  0x1a

#define ON (unsigned char)0x40
#define OFF (unsigned char)~ON
#define LITE_ON outb(inb(PORT_SYS_A) | ON,PORT_SYS_A)
#define LITE_OFF outb((inb(PORT_SYS_A) & OFF),PORT_SYS_A)

#define NUMBER_OF_SLOTS 8
#define PORT_POS_SEL 0x096
#define PORT_POS_REG_0 0x100
#define PORT_POS_REG_1 0x101
#define PORT_POS_REG_2 0x102

#define FAIL 0
#define SUCCES 1

#define SELECT_BIT 0x08

#define INT_TRANSFER_REQ 0x0B
#define INT_ATTN_ERROR   0x0F
#define INT_CMD_COMPLETE 0x01

#define DMA_MASK_CHAN 0x90
#define DMA_UNMASK_CHAN 0xA0
#define DMA_WRITE_ADDR 0x20
#define DMA_WRITE_TC 0x40
#define DMA_WRITE_MODE 0x70

#define CMD_READ 0x4601
#define CMD_WRITE 0x4602
#define DMA_READ_16 0x4C
#define DMA_WRITE_16 0x44


#define MB 1024*1024
#define SECT_SIZE 512   

#define ERROR 1
#define OK 0

#define HDIO_GETGEO 0x0301

struct ps2esdi_geometry {
	unsigned char heads;
	unsigned char sectors;
	unsigned short cylinders;
	unsigned long start;
};
