/* Demo: complete pop-ups */

#include "forms.h"

FL_FORM *pup;
FL_OBJECT *done, *pret;
void create_form_pup(void);

int main(int argc,char *argv[])
{
    FL_IOPT aa;

    unsigned mask = FL_PDVisual;
    aa.vclass = FL_DefaultVisual;
    fl_set_defaults(mask, &aa);
    fl_initialize("pup","Demo", 0, 0, &argc, argv);
    create_form_pup();
    fl_show_form(pup, FL_PLACE_MOUSE, FL_TRANSIENT,"PupDemo");
    while (fl_do_forms() != done)
      ;
    return 0;
}

void
set_pup_return(int i)
{
    char buf[25];
    sprintf(buf,"Pop-up Returned %d",i);
    fl_set_object_label(pret, buf);
}

static subm = -1, m = -1, ssm; 

int ssm_cb(int a)
{
   set_pup_return(a);
   return a;
}


void
do_pup(FL_OBJECT *ob, long q)
{
   if(subm == -1)
   {
      /* define two radio groups */
      ssm = fl_defpup(FL_ObjWin(ob),
        "SubSubM%F%t|SSMItem20%x20%R1|SSMItem21%x21%r1|SSMItem22%x22%r1%l|"
        "SSMitem30%x30%R2|SSMItem31%x31%r2|SSMItem32%x32%r2", ssm_cb);

      subm = fl_defpup(FL_ObjWin(ob), "SubMenu%t|SMItemA%x10%h|"
      "SMItemB%x11%h|SMItemC%x12%h|SMItemD%x13%h%m|SMItemE%x14",
        "Aa#a","Bb#b","Cc#c", "Dd#d", ssm);
       fl_setpup_mode(subm, 14, FL_PUP_GREY);

      m = fl_defpup(FL_ObjWin(ob),
        "PopUP%t|MenuItem1%h|MenuItem2%m%h|MenuItem3%h|MenuItem4%h",
        "1#1",subm,"2#2", "3#3","4#4");
   }

   if(fl_get_button_numb(ob) >= FL_SHORTCUT)
      fl_setpup_position(ob->form->x + ob->x, 
                      ob->form->y + ob->y + ob->h); 
   set_pup_return(fl_dopup(m));
}

void create_form_pup(void)
{
  FL_OBJECT *obj;

  if (pup)
     return;
  pup = fl_bgn_form(FL_NO_BOX,260,210);
  obj = fl_add_box(FL_UP_BOX,0,0,260,210,"Pop-up");
  done = obj = fl_add_button(FL_NORMAL_BUTTON,150,25,90,35,"Done");
  obj = fl_add_button(FL_TOUCH_BUTTON,30,80,130,40,"PopUp");
  fl_set_object_shortcut(obj,"Pp#p",1);
  fl_set_object_callback(obj, do_pup, 0);
  pret = obj = fl_add_text(FL_NORMAL_TEXT,40,140,180,30,"");
  fl_end_form();
}

