#!/bin/sh
if [ "$1" = "" ]; then
  echo "You didn't specify a filename, will use image.pbm"
fi
FILE=${1:-image.pbm}
TMPF=scan${$}.tmp
while [ "$BPL" = "" ]; do
  echo -n "Please enter resolution (1-4): [4]00 dpi "; read RES
  case ${RES:-4} in
    1 ) BPL=52; PPL=416;;
    2 ) BPL=104; PPL=832;;
    3 ) BPL=155; PPL=1240;;
    4 ) BPL=207; PPL=1656;;
  esac
done
echo -n "Please enter height in scanlines: [1000] "; read SL
SL=${SL:-1000}
dd if=/dev/scan of=$TMPF bs=$BPL count=$SL
echo -e "P4\n# pbm file created by scan.sh (c) 1994 Thomas Faehnle\n$PPL $SL" | \
	cat - $TMPF > $FILE
rm -f $TMPF
