#ifndef _M105_H
#define _M105_H

/*
 *  Copyright (c) 1994 Thomas Faehnle  (Thomas.Faehnle@student.uni-ulm.de)
 *
 *  m105.h,v 1.7 1994/04/13 22:28:42 blurf Exp
 */

#include "scanner.h"

#define M105_SCANNER_NAME	"Scanner"
#define M105_SCANNER_MAJOR	26	/* our major number */
#define GI1904_IOBASE		0x2ab	/* base address of scanner interface
					   (0x22b, 0x26b, 0x2ab, 0x2eb,
					   0x32b, 0x36b, 0x3ab or 0x3eb) */
#define GI1904_IRQ		10	/* used IRQ  (3, 5 or 10) */
#define GI1904_DMA		3	/* used DMA channel  (1 or 3) */

#define DEFAULT_BUFLINES	50	/* default # of scanlines in buffer */

/****************************************************************************
 *
 * It may be wise not to touch anything below this line...
 *
 ****************************************************************************/

#define MAX_BUFSIZ		(1<<19) /* max. buffer size (bytes), prevents one
					   from locking up all mem as scan buffer 8-) */

#define MAX_BLK			(4072 - HEADERSIZ) /* <--- don't touch this */
					/* max. chunk of mem we can get with kmalloc()
					   note: this is likely to change in the future */

#if GI1904_IRQ == 3
#  define GI1904_IRQ_MASK	0x10
#elif GI1904_IRQ == 5
#  define GI1904_IRQ_MASK	0x20
#elif GI1904_IRQ == 10
#  define GI1904_IRQ_MASK	0x08
#else
#error "I can't use an IRQ line other than 3, 5 or 10!"
#endif

#if GI1904_DMA == 1
#  define GI1904_DMA_MASK	0x01
#elif GI1904_DMA == 3
#  define GI1904_DMA_MASK	0x04
#else
#error "DMA lines other than 1 or 3 can't be used!"
#endif

#if DEFAULT_BUFLINES >= 500
#error "Well, I think a buffer with >= 500 lines is a bit excessive, isn't it?"
#endif

#define GI1904_DMA_IRQ		GI1904_IOBASE
#define GI1904_CONTROL		(GI1904_IOBASE + 1)
#define GI1904_MISC0		(GI1904_IOBASE + 2)
#define GI1904_MISC1		(GI1904_IOBASE + 3)
#define GI1904_IDENT		(GI1904_IOBASE + 3)
#define GI1904_MISC2		(GI1904_IOBASE + 4)
#define STANDBY			0x05
#define OPERATE			(0x01 | (gi1904_regs.ctl_mask & ~0x05))
#define OFF			0
#define GI1904_MAGIC		0xa5
#define GI1904_MODE_MASK	0x3f

static unsigned char m105_modebits[] = { 0x02, 0x04, 0x07, 0x09, 0x0c, 0x0e, 0x10, 0x13 };

static struct m105_modeinfo_struct m105_modeinfo[] = {
  { 100, 52 },
  { 200, 104 },
  { 300, 155 },
  { 400, 207 }
  /* ,{ 500, 258 }, */
  /* { 600, 310 }, */
  /* { 700, 362 }, */
  /* { 800, 414 } */
};

static struct gi1904_regs_struct gi1904_regs = { 0xce, 0, 0, 0x90 };

#define HEADERSIZ		12	/* size of buffer header (take alignment into account) */

struct buffer_block_struct {
  struct buffer_block_struct *next;
  unsigned int blksiz;
  unsigned int blkoff;
  unsigned char data[MAX_BLK];
};

struct device_status_struct {
  char device_open:	1;
  char irq_enabled:	1;
  char process_sleeps:	1;
  char buffer_empty:	1;
};

struct buffer_pointer {
  struct buffer_block_struct *blkptr;
  unsigned int index;
};
#endif /* _M105_H */
