/** Demo, showing ther different fonts in the different sizes. **/

#include <stdio.h>

#include "forms.h"

static FL_FORM *form;

static FL_OBJECT
        *textobj,
        *styleobj,
        *sizeobj;

void exit_cb(FL_OBJECT *obj, long arg)
  { exit(0); }

void style_cb(FL_OBJECT *obj, long arg)
{
  fl_set_object_lstyle(textobj, fl_get_browser(obj) - 1);
  fl_redraw_object(textobj);
}

void size_cb(FL_OBJECT *obj, long arg)
{
  switch (fl_get_browser(obj))
  {
    case 1: fl_set_object_lsize(textobj,8); break;
    case 2: fl_set_object_lsize(textobj,10); break;
    case 3: fl_set_object_lsize(textobj,11); break;
    case 4: fl_set_object_lsize(textobj,12); break;
    case 5: fl_set_object_lsize(textobj,13); break;
    case 6: fl_set_object_lsize(textobj,14); break;
    case 7: fl_set_object_lsize(textobj,18); break;
    case 8: fl_set_object_lsize(textobj,24); break;
    case 9: fl_set_object_lsize(textobj,30); break;
  }
}

void create_form_form(void)
{
  FL_OBJECT *obj;
  form = fl_bgn_form(FL_NO_BOX,550.0,370.0);
  obj = fl_add_box(FL_UP_BOX,0.0,0.0,550.0,370.0,"");
    fl_set_object_color(obj,FL_SLATEBLUE,FL_COL1);
  textobj = obj = fl_add_box(FL_FRAME_BOX,10.0,190.0,530.0,170.0,"The quick brown\nfox jumps over\nthe lazy dog.");
    fl_set_object_color(obj,FL_INDIANRED,FL_COL1);
    fl_set_object_dblbuffer(obj, 1);
  styleobj = obj = fl_add_browser(FL_HOLD_BROWSER,10.0,10.0,240.0,170.0,"");
    fl_set_object_boxtype(obj,FL_FRAME_BOX);
    fl_set_object_color(obj,FL_TOP_BCOL,FL_YELLOW);
    fl_set_object_callback(obj,style_cb,0);
  sizeobj = obj = fl_add_browser(FL_HOLD_BROWSER,260.0,10.0,160.0,170.0,"");
    fl_set_object_boxtype(obj,FL_FRAME_BOX);
    fl_set_object_color(obj,FL_TOP_BCOL,FL_YELLOW);
    fl_set_object_callback(obj,size_cb,0);
  obj = fl_add_button(FL_NORMAL_BUTTON,430.0,10.0,100.0,30.0,"Exit");
    fl_set_object_callback(obj,exit_cb,0);
  fl_end_form();
}

void create_the_forms(void)
{
  create_form_form();
}

void addit(const char *str)
  { fl_add_browser_line(styleobj,str); }

int
main(int argc, char *argv[])
{
  fl_initialize(argv[0], "FormDemo", 0, 0 ,&argc, argv);
  create_the_forms();

  fl_enumerate_fonts(addit, 1);
  fl_select_browser_line(styleobj,1);
  fl_addto_browser(sizeobj,"8 (small)");
  fl_addto_browser(sizeobj,"10(normal1)");
  fl_addto_browser(sizeobj,"11(scaled)");
  fl_addto_browser(sizeobj,"12(normal2)");
  fl_addto_browser(sizeobj,"13(scaled)");
  fl_addto_browser(sizeobj,"14(normal2)");
  fl_addto_browser(sizeobj,"18 (large)");
  fl_addto_browser(sizeobj,"24 (Huge)");
  fl_addto_browser(sizeobj,"30 (scaled)");
  fl_select_browser_line(sizeobj,2);
  fl_set_object_lstyle(textobj,FL_NORMAL_STYLE);
  style_cb(styleobj,0);
  size_cb(sizeobj,0);
  fl_show_form(form,FL_PLACE_CENTER,FL_NOBORDER,NULL);

  while (fl_do_forms())
   ;
  return 0;
}
