/* A demo that shows the use of push buttons.  */

#include "forms.h"

FL_FORM *form;
FL_OBJECT *but[8], *box[8], *exitbut;

void makeform(void)
{
  int i;
  form = fl_bgn_form(FL_UP_BOX,400,400);
  for (i=0; i<8; i++)
  {
    but[i] = fl_add_button(FL_PUSH_BUTTON,40,60+40*i,80,30,"");
    fl_set_object_color(but[i],FL_BLACK+i+1,FL_BLACK+i+1);
    box[i] = fl_add_box(FL_DOWN_BOX,150+30*i,40,25,320,"");
    fl_set_object_color(box[i],FL_BLACK+i+1,FL_BLACK+i+1);
    fl_hide_object(box[i]);
  }
  exitbut = fl_add_button(FL_NORMAL_BUTTON,40,20,80,30,"Exit");
  fl_end_form();
}

int
main(int argc, char *argv[])
{ 
  FL_OBJECT *obj;
  int i;

  fl_initialize(argv[0], "FormDemo", 0, 0 ,&argc, argv);

  makeform();
  fl_show_form(form,FL_PLACE_CENTER,FL_NOBORDER,NULL);
  do
  {
    obj = fl_do_forms();
    for (i=0; i<8; i++)
      if (obj == but[i])
	if (box[i]->visible) fl_hide_object(box[i]);else fl_show_object(box[i]);
  } while (obj != exitbut);
  fl_hide_form(form);
  return 0;
}
