.TH "MSND" 7 "$Revision: 2.1.0.1 $"
.\"
.\"	Copyright (c) 1994-1995 by Markus Mummert
.\"
.\"	Redistribution and use of this software, modifcation and inclusion
.\"	into other forms of software are permitted provided that the following
.\"	conditions are met:
.\"
.\"	1. Redistributions of this software must retain the above copyright
.\"	   notice, this list of conditions and the following disclaimer.
.\"	2. If this software is redistributed in a modified condition
.\"	   it must reveal clearly that it has been modified.
.\"	
.\"	THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS''
.\"	AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
.\"	TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
.\"	PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR
.\"	CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
.\"	EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
.\"	PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
.\"	PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
.\"	OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
.\"	(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
.\"	USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
.\"	DAMAGE.
.\"
.SH "NAME"
msnd \- driver to record/play digital audio on MultiSound/Tahiti/Monterey
.SH "OVERVIEW"
MultiSound/Tahiti/Monterey are soundcards made by Turtle Beach Systems,
Inc. (TBS) which can, among other features, record and play 16bit audio
at rates up to 44.1kHz stereo, delivering CD-quality. This device
driver can adress the record/playback-facilities of a single card,
allowing continous operation (harddisk recording) without dropouts
even on a loaded system.  Other features of these cards as Synthesis,
MIDI and Signalprocessor (DSP) can NOT be accessed. Reading and
writing a the same time is also not supported.
.PP
The driver is implemented as a character device /dev/msnd. If
\fIread\fP(2) is used on the device after \fIopen\fP(2), recording will
be initiated. On the other hand, if is \fIwrite\fP(2) used, playback
will be initiated. The operational parameters of recording or playing
(e.g. sampling rate or record/playback-limits) can be set by
\fIioctl\fP(2) immediately after open. These settings will be kept
until altered again by the same procedure. Playback or recording is
stopped via \fIclose\fP(2) or if an error was encountered or if
the record/playback-limits have run out or, of course, if the
controlling process is killed.
.PP
To illustrate a very basic usage of the device it is assumed that
the default settings after booting the systems are
44.1kHz and stereo, a shell command like
.IP
cat </dev/msnd	>foo
.PP
would record audio data to the file foo until the process is killed
or a selected limit of samples is reached. After that one could use
the command
.IP
cat foo >/dev/msnd
.PP
to play the file back again. In order to set a different sampling rate
a process would have to perform ioctl-calls on the /dev/msnd.
For convenience the user commands \fImsndctl\fP(1), \fIrec\fP(1)
and \fIplay\fP(1) are available.
.SH "IOCTL-COMMANDS"
The following syntax is used to \fIioctl\fP(2) the device:
.PP
.nf
set a parameter:  int ioctl(int \fIfd\fP, int \fIcmd\fP, int \fIarg\fP)
read a parameter: int ioctl(int \fIfd\fP, int \fIcmd\fP, int \fI*argp\fP)
.fi
.PP
\fIfd\fP is the filedescriptor returned by \fIopen\fP(2). \fIcmd\fP can
take one of the following values and determine wether to set
(substitute x='S') or to read (substitute x='G') a parameter. 
The parameter can take the value of \fIarg\fP or \fI*argp\fP pertaining
to the specifed function (all values defined in sys/msndio.h): 
.PP
.nf
cmd             *argp/arg         function
-------------   ---------------   ----------------------------
M_xETRATE       M_CLKDIVr         r=1:44.1,2:22.05,3:11.025kHz
M_xETMODE       M_MONO,M_STEREO   mono or stereo
M_xETSMPFMT     M_SWAP,M_NOSWAP   sample format Intel/Motorola
M_xETMONITOR    M_AUTO,M_SILENT   monitor status
M_xETINPTVAL    0x0000llrr        input pot value left/right
M_xETAUXPTVAL   0x0000llrr        aux pot value left/right
M_xETRECBYTES   int or M_NOLIMIT  bytes to record
M_xETPLAYBYTES  int or M_NOLIMIT  bytes to play
M_REINIT                          reinitialize
.fi
.PP
Sample format refers to the fact that on Intel-architecture
a 16bit number is stored as low byte, high byte, referring
to increasing byte adresses (little-endian). On Motorola-architectures
it's just the other way round (big-endian).
.PP
If the monitor is set to M_AUTO, MultiSound will feed input
to output digitally if it is not recording. Otherwise there will
be no feedthrough.  M_AUTO is very useful to monitor distortion
due to overload, since the feedthrough passes AD- and DA-converters.
.PP
Reinitialization is necessary after changing values of the
input and aux pots. Unfortunatly, this takes about a second
and introduces a switching noise on the anlog output.
.PP
In any case, if parameters have been set, the device
has to be closed and reopened again for changed parameters
to become functional.
.SH "DIAGNOSTICS"
The driver returns system error codes (see also intro(2)) to the caller
with the following specific meanings:
.IP "\fIEBUSY\fP"
This code is returned upon open, if device is used by another process
or upon ioctl, if device had been already read or written after open.
.IP "\fIEFAULT\fP"
Driver encountered a fault in attempting to use an argument
of a system call.
.IP "\fIEINTR\fP"
Stopped playing/recording due to reception of signal.
.IP "\fIEINVAL\fP"
An invalid parameter in ioctl-call has been encountered.
.IP "\fIEIO\fP"
The process or the system did not deliver/fetch the data in time so
that samples have been lost.
.IP "\fIENODEV\fP"
The driver cannot access the MultiSound hardware, likely due to
inconsistance between space.c configuration and DIP-switch setting.
.IP "\fIENOMEM\fP"
Kernel memory for internal driver buffer could not be allocated
upon open.
.IP "\fIENOSPC\fP"
Optional playback limit was encountered during write.
.IP "\fIENXIO\fP"
It was attempted to open the device for reading and writing
simultaniously.
.SH "DRIVER AND HARDWARE SETUP ON SYSV386R3.2"
In the file \fIpack.d/msnd/space.c\fP of the kernel configuration tree
all operational parameter defaults of the driver can be readjusted.
To alter hardware settings, the file \fIsdevice.d/msnd\fP
of the kernel configuration tree has to be altered, observing the
file layout as decribed in sdevice(4)). In both cases
the kernel has to be rebuild using idbuild(1m).
.SH "FILES"
.nf
/dev/msnd
/usr/include/sys/msndio.h (installation dependend)
/etc/conf/pack.d/msnd/space.c (installation dependend)
/etc/conf/sdevice.d/msnd (installation dependend)
.fi
.SH "SEE ALSO"
msndctl(1), play(1), rec(1), idbuild(1m), intro(2), open(2), close(2),
read(2), write(2), ioctl(2), sdevice(4)
.SH "COPYRIGHT"
Copyright (C) 1994-1995 by Markus Mummert
.PP
See the file \fICOPYING\fP (distributed with the source code)
for policy.



