/* This file is part of the GMOD package */

#define TRUE 	1
#define FALSE	0

#define CMD_ARPEG		0x00
#define CMD_SLIDEUP		0x01
#define CMD_SLIDEDOWN		0x02
#define CMD_SLIDETO		0x03
#define CMD_VIBRATO		0x04
#define CMD_PORTANDVOL		0x05
#define CMD_VIBRAANDVOL		0x06
#define CMD_TREMOLO		0x07
#define CMD_SETOFFSET		0x09
#define CMD_VOLSLIDE		0x0a
#define CMD_JUMP		0x0b
#define CMD_VOLUME		0x0c
#define CMD_BREAK		0x0d
#define CMD_EXTENDED		0x0e
#define CMD_SPEED		0x0f
#define CMD_NOP			0xfe
#define CMD_NONOTE		0xff

/* "extended" commands */
#define CMD_FINEPORTUP		0x10
#define CMD_FINEPORTDOWN	0x20
#define CMD_GLISSANDO		0x30
#define CMD_VIBRA_WAVE		0x40
#define CMD_PATTERN_LOOP	0x60
#define CMD_TREMOLO_WAVE	0x70
#define CMD_RETRIGGER		0x90
#define CMD_FINEVOLUP		0xa0
#define CMD_FINEVOLDOWN		0xb0
#define CMD_CUT_NOTE		0xc0
#define CMD_DELAY_NOTE		0xd0
#define CMD_DELAY_PAT		0xe0

#define MIN(a, b)		((a) < (b) ? (a) : (b))

#define MAX_TRACK	8
#define MAX_PATTERN	128
#define MAX_POSITION	128

#define VOL_SLIDE_RATE	2	/* rate for volume slides, bigger is faster */

/* slide types */

#define SLIDE_UPDOWN	1	/* slide up or down */
#define SLIDE_ONCE	2	/* only slide once */
#define SLIDE_PORT	3	/* tone portamento */

/* move types (bit flags) */

#define MOVE_LOOP	0x01
#define MOVE_JUMP	0x02
#define MOVE_EXIT	0x04

#define NUM_PERIODS 36		/* number of periods in period table */
#define NUM_VIBRA 64		/* number of values in vibrato table */
#define NOTE_BASE 48		/* lowest note possible */
